/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.optimization.paramgen;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.optimization.AutoOptimizationService;
import org.pentaho.di.trans.dataservice.optimization.PushDownOptimizationMeta;
import org.pentaho.di.trans.dataservice.optimization.PushDownType;
import org.pentaho.di.trans.dataservice.optimization.paramgen.ParameterGeneration;
import org.pentaho.di.trans.dataservice.optimization.paramgen.ParameterGenerationFactory;
import org.pentaho.di.trans.dataservice.optimization.paramgen.SourceLineageMap;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.metaverse.api.ChangeType;
import org.pentaho.metaverse.api.ILineageClient;
import org.pentaho.metaverse.api.StepFieldOperations;
import org.pentaho.metaverse.api.model.Operations;

public class AutoParameterGenerationService
implements AutoOptimizationService {
    private final ILineageClient lineageClient;
    private final ParameterGenerationFactory serviceProvider;

    public AutoParameterGenerationService(ILineageClient lineageClient, ParameterGenerationFactory serviceProvider) {
        this.lineageClient = lineageClient;
        this.serviceProvider = serviceProvider;
    }

    public List<PushDownOptimizationMeta> apply(DataServiceMeta dataServiceMeta) {
        TransMeta transMeta = dataServiceMeta.getServiceTrans();
        LogChannelInterface logChannel = transMeta.getLogChannel() != null ? transMeta.getLogChannel() : LogChannel.GENERAL;
        try {
            String stepName = dataServiceMeta.getStepname();
            List<String> fields = Arrays.asList(transMeta.getStepFields(stepName).getFieldNames());
            Map operationPaths = this.lineageClient.getOperationPaths(transMeta, stepName, fields);
            SourceLineageMap sourceLineageMap = SourceLineageMap.create(operationPaths).filterKeys(this.stepSupported(transMeta)).filterKeys((Predicate<String>)Predicates.not((Predicate)Predicates.in(this.parametrizedSteps(dataServiceMeta)))).filter(this.fieldUnchanged());
            return this.generateOptimizationList(sourceLineageMap);
        }
        catch (Throwable e) {
            logChannel.logError("Unable to run Auto-Optimization", e);
            return Collections.emptyList();
        }
    }

    protected Set<String> parametrizedSteps(DataServiceMeta dataServiceMeta) {
        HashSet parametrizedSteps = Sets.newHashSet();
        for (PushDownOptimizationMeta existing : dataServiceMeta.getPushDownOptimizationMeta()) {
            if (!(existing.getType() instanceof ParameterGeneration)) continue;
            parametrizedSteps.add(existing.getStepName());
        }
        return parametrizedSteps;
    }

    private Predicate<Map.Entry<String, List<StepFieldOperations>>> fieldUnchanged() {
        return new Predicate<Map.Entry<String, List<StepFieldOperations>>>(){

            public boolean apply(Map.Entry<String, List<StepFieldOperations>> entry) {
                for (StepFieldOperations stepFieldOperations : entry.getValue()) {
                    Operations operations = stepFieldOperations.getOperations();
                    if (operations == null || !operations.containsKey((Object)ChangeType.DATA)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private Predicate<String> stepSupported(final TransMeta transMeta) {
        return new Predicate<String>(){

            public boolean apply(String inputStep) {
                StepMeta stepMeta = transMeta.findStep(inputStep);
                return stepMeta != null && AutoParameterGenerationService.this.serviceProvider.supportsStep(stepMeta);
            }
        };
    }

    private List<PushDownOptimizationMeta> generateOptimizationList(SourceLineageMap sourceLineageMap) {
        Map inputSteps = Multimaps.asMap((SetMultimap)sourceLineageMap);
        ArrayList optimizationList = Lists.newArrayListWithExpectedSize((int)inputSteps.size());
        for (Map.Entry inputStepLineage : inputSteps.entrySet()) {
            String inputStep = (String)inputStepLineage.getKey();
            Set lineageSet = (Set)inputStepLineage.getValue();
            PushDownOptimizationMeta pushDownOptimizationMeta = new PushDownOptimizationMeta();
            ParameterGeneration parameterGeneration = this.serviceProvider.createPushDown();
            pushDownOptimizationMeta.setName(MessageFormat.format("Parameter Generator: {0}", inputStep));
            pushDownOptimizationMeta.setStepName(inputStep);
            pushDownOptimizationMeta.setType(parameterGeneration);
            parameterGeneration.setParameterName("DATA_SERVICE_QUERY_" + inputStep.replaceAll("\\s", "_").toUpperCase());
            for (List fieldLineage : lineageSet) {
                StepFieldOperations origin = (StepFieldOperations)fieldLineage.get(0);
                StepFieldOperations last = (StepFieldOperations)Iterables.getLast((Iterable)fieldLineage);
                parameterGeneration.createFieldMapping(last.getFieldName(), origin.getFieldName());
            }
            optimizationList.add(pushDownOptimizationMeta);
        }
        return optimizationList;
    }

    public Set<Class<? extends PushDownType>> getProvidedOptimizationTypes() {
        return ImmutableSet.of(ParameterGeneration.class);
    }
}

