/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.optimization.paramgen;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.parameters.DuplicateParamException;
import org.pentaho.di.core.sql.SQL;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.DataServiceExecutor;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.optimization.OptimizationImpactInfo;
import org.pentaho.di.trans.dataservice.optimization.PushDownOptimizationException;
import org.pentaho.di.trans.dataservice.optimization.PushDownOptimizationMeta;
import org.pentaho.di.trans.dataservice.optimization.SourceTargetFields;
import org.pentaho.di.trans.dataservice.optimization.StepOptimization;
import org.pentaho.di.trans.dataservice.optimization.paramgen.ParameterGenerationFactory;
import org.pentaho.di.trans.dataservice.optimization.paramgen.ParameterGenerationService;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.metastore.persist.MetaStoreAttribute;

public class ParameterGeneration
extends StepOptimization {
    public static final String PUSH_DOWN_FIELD_MAPPINGS = "field_mappings";
    public static final String PUSH_DOWN_PARAMETER_NAME = "parameter_name";
    public static final String TYPE_NAME = "Parameter Generation";
    @MetaStoreAttribute(key="field_mappings")
    private List<SourceTargetFields> fieldMappings = new ArrayList<SourceTargetFields>();
    @MetaStoreAttribute(key="parameter_name")
    private String parameterName;
    protected ParameterGenerationFactory serviceProvider;

    public ParameterGeneration(ParameterGenerationFactory serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    public String getParameterName() {
        return this.parameterName == null ? "" : this.parameterName;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public List<SourceTargetFields> getFieldMappings() {
        return this.fieldMappings;
    }

    public SourceTargetFields createFieldMapping() {
        SourceTargetFields mapping = new SourceTargetFields();
        this.fieldMappings.add(mapping);
        return mapping;
    }

    public SourceTargetFields createFieldMapping(String source, String target) {
        SourceTargetFields mapping = new SourceTargetFields(source, target);
        this.fieldMappings.add(mapping);
        return mapping;
    }

    public SourceTargetFields removeFieldMapping(SourceTargetFields mapping) {
        this.fieldMappings.remove(mapping);
        return mapping;
    }

    protected Condition mapConditionFields(Condition condition) {
        Condition clone = (Condition)condition.clone();
        HashMap<String, SourceTargetFields> sourceMap = new HashMap<String, SourceTargetFields>();
        for (SourceTargetFields fieldMapping : this.fieldMappings) {
            sourceMap.put(fieldMapping.getSourceFieldName(), fieldMapping);
        }
        if (this.applyMapping(clone, sourceMap)) {
            clone.simplify();
            return clone;
        }
        return null;
    }

    private boolean applyMapping(Condition condition, Map<String, SourceTargetFields> sourceTargetFieldsMap) {
        if (condition.isAtomic()) {
            String key = condition.getLeftValuename();
            SourceTargetFields mapping = sourceTargetFieldsMap.get(key);
            if (mapping != null) {
                condition.setLeftValuename(mapping.getTargetFieldName());
                return true;
            }
            return false;
        }
        List children = condition.getChildren();
        int requireAllOp = condition.isNegated() ? 2 : 1;
        boolean requireAll = false;
        for (Condition child : children) {
            if (child.getOperator() != requireAllOp) continue;
            requireAll = true;
            break;
        }
        Iterator i = children.iterator();
        while (i.hasNext()) {
            Condition child;
            child = (Condition)i.next();
            if (this.applyMapping(child, sourceTargetFieldsMap)) continue;
            if (requireAll) {
                return false;
            }
            i.remove();
        }
        return !children.isEmpty();
    }

    @Override
    public void init(TransMeta transMeta, DataServiceMeta dataService, PushDownOptimizationMeta optMeta) {
        this.fieldMappings = Lists.newArrayList((Iterable)Iterables.filter(this.fieldMappings, SourceTargetFields.IS_DEFINED));
        StepMeta stepMeta = transMeta.findStep(optMeta.getStepName());
        ParameterGenerationService service = stepMeta != null ? this.serviceProvider.getService(stepMeta) : null;
        String parameterDefault = service != null ? service.getParameterDefault() : "";
        String description = String.format("Auto-generated parameter for Push Down Optimization: %s", optMeta.getStepName());
        try {
            transMeta.addParameterDefinition(this.getParameterName(), parameterDefault, description);
            transMeta.activateParameters();
        }
        catch (DuplicateParamException duplicateParamException) {
            // empty catch block
        }
    }

    @Override
    public boolean activate(DataServiceExecutor executor, StepInterface stepInterface) {
        ParameterGenerationService service = this.serviceProvider.getService(stepInterface.getStepMeta());
        Condition pushDownCondition = this.getPushDownCondition(executor.getSql());
        return this.handlePushDown(service, pushDownCondition, stepInterface);
    }

    @Override
    public OptimizationImpactInfo preview(DataServiceExecutor executor, StepInterface stepInterface) {
        ParameterGenerationService service = this.serviceProvider.getService(stepInterface.getStepMeta());
        Condition pushDownCondition = this.getPushDownCondition(executor.getSql());
        return service.preview(pushDownCondition, this, stepInterface);
    }

    private boolean handlePushDown(ParameterGenerationService service, Condition pushDownCondition, StepInterface stepInterface) {
        if (service == null || pushDownCondition == null || stepInterface == null) {
            return false;
        }
        try {
            service.pushDown(pushDownCondition, this, stepInterface);
        }
        catch (PushDownOptimizationException e) {
            return false;
        }
        return true;
    }

    private Condition getPushDownCondition(SQL query) {
        if (query.getWhereCondition() == null) {
            return null;
        }
        Condition whereCondition = query.getWhereCondition().getCondition();
        Condition pushDownCondition = this.mapConditionFields(whereCondition);
        if (pushDownCondition == null || StringUtils.isBlank((String)this.getParameterName())) {
            return null;
        }
        return pushDownCondition;
    }

    protected String setQueryParameter(String query, String parameterValue) {
        Variables varSpace = new Variables();
        varSpace.setVariable(this.getParameterName(), parameterValue);
        return varSpace.environmentSubstitute(query);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("fieldMappings", this.fieldMappings).add("parameterName", (Object)this.parameterName).toString();
    }
}

