/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.optimization.paramgen.ui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.pentaho.di.trans.dataservice.optimization.PushDownOptimizationMeta;
import org.pentaho.di.trans.dataservice.optimization.SourceTargetFields;
import org.pentaho.di.trans.dataservice.optimization.paramgen.ParameterGeneration;
import org.pentaho.di.trans.dataservice.optimization.paramgen.ParameterGenerationFactory;
import org.pentaho.di.trans.dataservice.optimization.paramgen.ui.SourceTargetAdapter;
import org.pentaho.di.trans.dataservice.ui.AbstractModel;
import org.pentaho.di.trans.dataservice.ui.model.DataServiceModel;

public class ParameterGenerationModel
extends AbstractModel {
    private final ParameterGenerationFactory factory;
    private final DataServiceModel dialogModel;
    private ImmutableMap<String, PushDownOptimizationMeta> parameterMap = ImmutableMap.of();
    private List<SourceTargetAdapter> mappings = Lists.newArrayList();
    private String selectedParameter;

    public ParameterGenerationModel(ParameterGenerationFactory factory, DataServiceModel dialogModel) {
        this.factory = factory;
        this.dialogModel = dialogModel;
    }

    public void add(PushDownOptimizationMeta meta) {
        this.dialogModel.add(meta);
        this.updateParameterMap();
    }

    public void remove(PushDownOptimizationMeta meta) {
        if (this.dialogModel.remove(meta)) {
            this.updateParameterMap();
        }
    }

    public ImmutableMap<String, PushDownOptimizationMeta> getParameterMap() {
        return this.parameterMap;
    }

    protected void updateParameterMap() {
        ImmutableList<PushDownOptimizationMeta> list = this.dialogModel.getPushDownOptimizations(ParameterGeneration.class);
        HashMap map = Maps.newHashMapWithExpectedSize((int)list.size());
        for (PushDownOptimizationMeta meta : list) {
            ParameterGeneration parameterGeneration = (ParameterGeneration)meta.getType();
            String parameterName = parameterGeneration.getParameterName();
            int offset = 0;
            while (map.containsKey(parameterName)) {
                parameterName = String.format("%s_%d", parameterGeneration.getParameterName(), ++offset);
            }
            if (offset > 0) {
                parameterGeneration.setParameterName(parameterName);
            }
            map.put(parameterName, meta);
        }
        this.setParameterMap(map);
        if (!map.containsKey(this.getSelectedParameter())) {
            this.setSelectedParameter(null);
        }
    }

    public void setParameterMap(Map<String, PushDownOptimizationMeta> map) {
        ImmutableMap<String, PushDownOptimizationMeta> previous = this.parameterMap;
        this.parameterMap = ImmutableMap.copyOf(map);
        this.firePropertyChange("parameterMap", previous, this.parameterMap);
        this.firePropertyChanges((Map<String, Object>)ImmutableMap.of());
    }

    public String getSelectedParameter() {
        return this.selectedParameter;
    }

    public PushDownOptimizationMeta getSelectedOptimization() {
        return this.selectedParameter != null ? (PushDownOptimizationMeta)this.parameterMap.get((Object)this.selectedParameter) : null;
    }

    public ParameterGeneration getParameterGeneration() {
        PushDownOptimizationMeta meta = this.getSelectedOptimization();
        return meta == null ? null : (ParameterGeneration)meta.getType();
    }

    public void setSelectedParameter(final String selectedParameter) {
        if (Objects.equals(selectedParameter, this.selectedParameter)) {
            return;
        }
        final ParameterGenerationModel model = this;
        this.modify(new Runnable(){

            @Override
            public void run() {
                model.selectedParameter = selectedParameter;
                ParameterGenerationModel.this.resetMappings(ParameterGenerationModel.this.getParameterGeneration());
            }
        });
    }

    @Override
    public Map<String, Object> snapshot() {
        HashMap map = Maps.newHashMap();
        map.put("selectedParameter", this.getSelectedParameter());
        map.put("selectedStep", this.getSelectedStep());
        map.put("enabled", this.isEnabled());
        map.put("mappings", this.getMappings());
        return map;
    }

    public DataServiceModel getDialogModel() {
        return this.dialogModel;
    }

    public String getSelectedStep() {
        PushDownOptimizationMeta meta = this.getSelectedOptimization();
        return meta != null ? meta.getStepName() : null;
    }

    public void setSelectedStep(String stepName) {
        PushDownOptimizationMeta meta = this.getSelectedOptimization();
        if (meta != null) {
            String previous = meta.getStepName();
            meta.setStepName(stepName);
            this.firePropertyChange("selectedStep", previous, stepName);
        }
    }

    public void setEnabled(boolean enabled) {
        PushDownOptimizationMeta meta = this.getSelectedOptimization();
        if (meta != null) {
            boolean previous = meta.isEnabled();
            meta.setEnabled(enabled);
            this.firePropertyChange("enabled", previous, enabled);
        }
    }

    public boolean isEnabled() {
        PushDownOptimizationMeta meta = this.getSelectedOptimization();
        return meta != null && meta.isEnabled();
    }

    private void resetMappings(ParameterGeneration parameterGeneration) {
        this.mappings = Lists.newArrayList();
        if (parameterGeneration != null) {
            Iterator<SourceTargetFields> iterator = parameterGeneration.getFieldMappings().iterator();
            while (iterator.hasNext()) {
                SourceTargetFields sourceTargetFields = iterator.next();
                if (sourceTargetFields.isDefined()) {
                    this.mappings.add(this.factory.createSourceTargetAdapter(sourceTargetFields));
                    continue;
                }
                iterator.remove();
            }
            for (int i = 0; i < 10; ++i) {
                this.mappings.add(this.factory.createSourceTargetAdapter(parameterGeneration.createFieldMapping()));
            }
        }
    }

    public ImmutableList<SourceTargetAdapter> getMappings() {
        return ImmutableList.copyOf(this.mappings);
    }
}

