/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.DataServiceContext;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.ui.DataServiceDelegate;
import org.pentaho.di.trans.dataservice.ui.DataServiceRemapStepChooserDialog;
import org.pentaho.di.trans.step.StepMeta;

@ExtensionPoint(id="DataServiceStepDeleteExtensionPointPlugin", extensionPointId="TransBeforeDeleteSteps", description="Handles deletion of steps to prevent leaving orphaned data services")
public class DataServiceStepDeleteExtensionPointPlugin
implements ExtensionPointInterface {
    private DataServiceContext context;
    private DataServiceDelegate dataServiceDelegate;

    public DataServiceStepDeleteExtensionPointPlugin(DataServiceContext context) {
        this.context = context;
        this.dataServiceDelegate = context.getDataServiceDelegate();
    }

    public void callExtensionPoint(LogChannelInterface log, Object object) throws KettleException {
        if (object != null && object instanceof StepMeta[]) {
            StepMeta[] stepsToBeRemoved = (StepMeta[])object;
            TransMeta trans = stepsToBeRemoved[0].getParentTransMeta();
            ArrayList<String> stepsToBeRemovedNames = new ArrayList<String>(stepsToBeRemoved.length);
            for (StepMeta step : stepsToBeRemoved) {
                stepsToBeRemovedNames.add(step.getName());
            }
            List<String> transSteps = Arrays.asList(trans.getStepNames());
            List remainingStepNames = ListUtils.subtract(transSteps, stepsToBeRemovedNames);
            block6: for (StepMeta stepToBeRemoved : stepsToBeRemoved) {
                DataServiceMeta dataService = this.dataServiceDelegate.getDataServiceByStepName(stepToBeRemoved.getParentTransMeta(), stepToBeRemoved.getName());
                if (dataService == null) continue;
                ArrayList<String> dataServiceSteps = new ArrayList<String>();
                for (DataServiceMeta ds : this.dataServiceDelegate.getDataServices(stepToBeRemoved.getParentTransMeta())) {
                    dataServiceSteps.add(ds.getStepname());
                }
                switch (this.dataServiceDelegate.showRemapConfirmationDialog(dataService, ListUtils.subtract((List)remainingStepNames, dataServiceSteps))) {
                    case CANCEL: {
                        throw new KettleException("Steps deletion cancelled by user");
                    }
                    case REMAP: {
                        if (this.dataServiceDelegate.showRemapStepChooserDialog(dataService, ListUtils.subtract((List)remainingStepNames, dataServiceSteps), trans) != DataServiceRemapStepChooserDialog.Action.CANCEL) continue block6;
                        throw new KettleException("Steps deletion cancelled by user");
                    }
                    case DELETE: {
                        this.context.getDataServiceDelegate().removeDataService(dataService);
                    }
                }
            }
        }
    }
}

