/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.ui.controller;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.components.XulPromptBox;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;

public abstract class AbstractController
extends AbstractXulEventHandler {
    private Supplier<BindingFactory> bindingFactorySupplier = new Supplier<BindingFactory>(){

        public BindingFactory get() {
            DefaultBindingFactory bindingFactory = new DefaultBindingFactory();
            bindingFactory.setDocument(AbstractController.this.document);
            return bindingFactory;
        }
    };

    public <T extends XulComponent> T getElementById(String id) {
        return (T)this.document.getElementById(id);
    }

    public XulPromptBox createPromptBox() throws XulException {
        XulPromptBox promptBox = (XulPromptBox)this.document.createElement("promptbox");
        promptBox.setModalParent(this.xulDomContainer.getOuterContext());
        return promptBox;
    }

    public XulMessageBox createMessageBox() throws XulException {
        XulMessageBox messageBox = (XulMessageBox)this.document.createElement("messagebox");
        messageBox.setModalParent(this.xulDomContainer.getOuterContext());
        return messageBox;
    }

    public void setBindingFactory(BindingFactory bindingFactory) {
        this.bindingFactorySupplier = Suppliers.ofInstance((Object)bindingFactory);
    }

    public BindingFactory getBindingFactory() {
        return (BindingFactory)this.bindingFactorySupplier.get();
    }

    protected void info(String title, String message) throws XulException {
        XulMessageBox messageBox = this.createMessageBox();
        messageBox.setTitle(title);
        messageBox.setMessage(message);
        messageBox.setIcon((Object)2);
        messageBox.setButtons(new Object[]{32});
        messageBox.open();
    }

    protected void error(String title, String message) throws XulException {
        XulMessageBox messageBox = this.createMessageBox();
        messageBox.setTitle(title);
        messageBox.setMessage(message);
        messageBox.setIcon((Object)8);
        messageBox.setButtons(new Object[]{32});
        messageBox.open();
    }

    protected LogChannelInterface getLogChannel() {
        return LogChannel.UI;
    }
}

