/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.ui.menu;

import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.DataServiceContext;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.serialization.DataServiceMetaStoreUtil;
import org.pentaho.di.ui.spoon.TreeSelection;
import org.pentaho.di.ui.spoon.delegates.SpoonTreeDelegateExtension;

@ExtensionPoint(id="DataServiceTreeDelegateExtension", description="Refreshes data services subtree", extensionPointId="SpoonTreeDelegateExtension")
public class DataServiceTreeDelegateExtension
implements ExtensionPointInterface {
    private static final Class<?> PKG = DataServiceTreeDelegateExtension.class;
    public static final String STRING_DATA_SERVICES = BaseMessages.getString(PKG, (String)"DataServicePopupMenu.TITLE", (String[])new String[0]);
    private DataServiceMetaStoreUtil metaStoreUtil;

    public DataServiceTreeDelegateExtension(DataServiceContext context) {
        this.metaStoreUtil = context.getMetaStoreUtil();
    }

    public void callExtensionPoint(LogChannelInterface log, Object extension) throws KettleException {
        SpoonTreeDelegateExtension treeDelExt = (SpoonTreeDelegateExtension)extension;
        int caseNumber = treeDelExt.getCaseNumber();
        if (!(treeDelExt.getTransMeta() instanceof TransMeta)) {
            return;
        }
        TransMeta transMeta = (TransMeta)treeDelExt.getTransMeta();
        String[] path = treeDelExt.getPath();
        List objects = treeDelExt.getObjects();
        TreeSelection object = null;
        if (path[2].equals(STRING_DATA_SERVICES)) {
            switch (caseNumber) {
                case 3: {
                    object = new TreeSelection(path[2], DataServiceMeta.class, (Object)transMeta);
                    break;
                }
                case 4: {
                    try {
                        DataServiceMeta dataService = this.metaStoreUtil.getDataService(path[3], transMeta);
                        object = new TreeSelection(path[3], (Object)dataService, (Object)transMeta);
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (object != null) {
            objects.add(object);
        }
    }
}

