/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.ui.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.dataservice.optimization.OptimizationImpactInfo;
import org.pentaho.ui.xul.XulEventSourceAdapter;

public class DataServiceTestModel
extends XulEventSourceAdapter {
    private String sql;
    protected static final LogLevel DEFAULT_LOGLEVEL = LogLevel.DETAILED;
    private LogLevel logLevel = DEFAULT_LOGLEVEL;
    private String alertMessage;
    private List<OptimizationImpactInfo> optimizationImpact = new ArrayList<OptimizationImpactInfo>();
    private List<Object[]> resultRows = new ArrayList<Object[]>();
    private RowMetaInterface resultRowMeta;
    private LogChannelInterface serviceTransLogChannel;
    private LogChannelInterface genTransLogChannel;
    private int maxRows = 0;
    public static final List<Integer> MAXROWS_CHOICES = Arrays.asList(100, 500, 1000);
    private boolean executing = false;

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public LogChannelInterface getServiceTransLogChannel() {
        return this.serviceTransLogChannel;
    }

    public void setServiceTransLogChannel(LogChannelInterface serviceTransLogChannel) {
        this.serviceTransLogChannel = serviceTransLogChannel;
    }

    public void setGenTransLogChannel(LogChannelInterface logChannel) {
        this.genTransLogChannel = logChannel;
    }

    public LogChannelInterface getGenTransLogChannel() {
        return this.genTransLogChannel;
    }

    public void addResultRow(Object[] row) {
        this.resultRows.add(row);
    }

    public List<Object[]> getResultRows() {
        return this.resultRows;
    }

    public void clearResultRows() {
        this.resultRows.clear();
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public List<String> getAllLogLevels() {
        return Arrays.asList(LogLevel.logLevelDescriptions);
    }

    public int getMaxRows() {
        return MAXROWS_CHOICES.get(this.maxRows);
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public List<Integer> getAllMaxRows() {
        return MAXROWS_CHOICES;
    }

    public String getAlertMessage() {
        return this.alertMessage;
    }

    public void setAlertMessage(String alertMessage) {
        this.alertMessage = alertMessage;
        this.firePropertyChange("alertMessage", null, alertMessage);
    }

    public RowMetaInterface getResultRowMeta() {
        return this.resultRowMeta;
    }

    public void setResultRowMeta(RowMetaInterface resultRowMeta) {
        this.resultRowMeta = resultRowMeta;
    }

    public void clearOptimizationImpact() {
        this.optimizationImpact.clear();
        this.firePropertyChange("optimizationImpactDescription", null, this.getOptimizationImpactDescription());
    }

    public void addOptimizationImpact(OptimizationImpactInfo info) {
        this.optimizationImpact.add(info);
        this.firePropertyChange("optimizationImpactDescription", null, this.getOptimizationImpactDescription());
    }

    public String getOptimizationImpactDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        if (this.optimizationImpact.size() == 0) {
            builder.append("[No Push Down Optimizations Defined]\n");
        }
        for (OptimizationImpactInfo info : this.optimizationImpact) {
            builder.append(info.getDescription());
            builder.append("\n- - - - - - - - - - - - - - - - - - - - - -\n\n");
        }
        return builder.toString();
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public void setExecuting(boolean executing) {
        this.executing = executing;
        this.firePropertyChange("executing", null, executing);
    }
}

