/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.validation;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Collection;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.optimization.PushDownOptimizationMeta;
import org.pentaho.di.trans.dataservice.optimization.paramgen.ParameterGeneration;
import org.pentaho.di.trans.step.StepMeta;

public class ValidationUtil {
    public static Collection<ParameterGeneration> getParameterGenerationsForStep(DataServiceMeta dataServiceMeta, final String stepName) {
        return Collections2.transform((Collection)Collections2.filter(dataServiceMeta.getPushDownOptimizationMeta(), (Predicate)new Predicate<PushDownOptimizationMeta>(){

            public boolean apply(PushDownOptimizationMeta pushDownOptimizationMeta) {
                return pushDownOptimizationMeta.getType() instanceof ParameterGeneration && stepName.equals(pushDownOptimizationMeta.getStepName());
            }
        }), (Function)new Function<PushDownOptimizationMeta, ParameterGeneration>(){

            public ParameterGeneration apply(PushDownOptimizationMeta pushDownOptimizationMeta) {
                return (ParameterGeneration)pushDownOptimizationMeta.getType();
            }
        });
    }

    public static boolean paramSubstitutionModifiesString(String string, VariableSpace space) {
        return !space.environmentSubstitute(string).equals(string);
    }

    public static CheckResult warn(String msg, StepMeta stepMeta) {
        return new CheckResult(3, msg, (CheckResultSourceInterface)stepMeta);
    }

    public static CheckResult comment(String msg, StepMeta stepMeta) {
        return new CheckResult(2, msg, (CheckResultSourceInterface)stepMeta);
    }
}

