/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle;

import org.apache.commons.logging.Log;
import org.apache.sqoop.manager.oracle.OraOopLogFactory;

public class OraOopLog
implements Log,
OraOopLogFactory.OraOopLog2 {
    private Log log;
    private StringBuilder cache;

    public OraOopLog(Log otherLog) {
        this.log = otherLog;
    }

    public void debug(Object message) {
        if (this.cacheLogEntry(message)) {
            return;
        }
        this.log.debug(message);
    }

    public void debug(Object message, Throwable t) {
        if (this.cacheLogEntry(message)) {
            return;
        }
        this.log.debug(message, t);
    }

    public void error(Object message) {
        if (this.cacheLogEntry(message)) {
            return;
        }
        this.log.error(message);
    }

    public void error(Object message, Throwable t) {
        if (this.cacheLogEntry(message)) {
            return;
        }
        this.log.error(message, t);
    }

    public void fatal(Object message) {
        if (this.cacheLogEntry(message)) {
            return;
        }
        this.log.fatal(message);
    }

    public void fatal(Object message, Throwable t) {
        if (this.cacheLogEntry(message)) {
            return;
        }
        this.log.fatal(message, t);
    }

    public void info(Object message) {
        if (this.cacheLogEntry(message)) {
            return;
        }
        this.log.info(message);
    }

    public void info(Object message, Throwable t) {
        if (this.cacheLogEntry(message)) {
            return;
        }
        this.log.info(message, t);
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.log.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    public void trace(Object message) {
        this.log.trace(message);
        this.cacheLogEntry(message);
    }

    public void trace(Object message, Throwable t) {
        if (this.cacheLogEntry(message)) {
            return;
        }
        this.log.trace(message, t);
    }

    public void warn(Object message) {
        if (this.cacheLogEntry(message)) {
            return;
        }
        this.log.warn(message);
    }

    public void warn(Object message, Throwable t) {
        if (this.cacheLogEntry(message)) {
            return;
        }
        this.log.warn(message, t);
    }

    @Override
    public boolean getCacheLogEntries() {
        return this.cache != null;
    }

    @Override
    public String getLogEntries() {
        if (this.cache != null) {
            return this.cache.toString();
        }
        return "";
    }

    @Override
    public void setCacheLogEntries(boolean value) {
        if (this.getCacheLogEntries() && !value) {
            this.cache = null;
        } else if (!this.getCacheLogEntries() && value) {
            this.cache = new StringBuilder();
        }
    }

    @Override
    public void clearCache() {
        if (this.getCacheLogEntries()) {
            this.cache = new StringBuilder();
        }
    }

    private boolean cacheLogEntry(Object message) {
        boolean result = this.getCacheLogEntries();
        if (result && message != null) {
            this.cache.append(message.toString());
        }
        return result;
    }
}

