/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.tool;

import com.cloudera.sqoop.ConnFactory;
import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.cli.RelatedOptions;
import com.cloudera.sqoop.cli.ToolOptions;
import com.cloudera.sqoop.lib.DelimiterSet;
import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.metastore.JobData;
import com.cloudera.sqoop.tool.SqoopTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;
import org.apache.sqoop.util.CredentialsUtil;
import org.apache.sqoop.util.LoggingUtils;
import org.apache.sqoop.util.password.CredentialProviderHelper;

public abstract class BaseSqoopTool
extends SqoopTool {
    public static final Log LOG = LogFactory.getLog((String)BaseSqoopTool.class.getName());
    public static final String HELP_STR = "\nTry --help for usage instructions.";
    public static final String CONNECT_STRING_ARG = "connect";
    public static final String CONN_MANAGER_CLASS_NAME = "connection-manager";
    public static final String CONNECT_PARAM_FILE = "connection-param-file";
    public static final String DRIVER_ARG = "driver";
    public static final String USERNAME_ARG = "username";
    public static final String PASSWORD_ARG = "password";
    public static final String PASSWORD_PROMPT_ARG = "P";
    public static final String PASSWORD_PATH_ARG = "password-file";
    public static final String PASSWORD_ALIAS_ARG = "password-alias";
    public static final String DIRECT_ARG = "direct";
    public static final String BATCH_ARG = "batch";
    public static final String TABLE_ARG = "table";
    public static final String STAGING_TABLE_ARG = "staging-table";
    public static final String CLEAR_STAGING_TABLE_ARG = "clear-staging-table";
    public static final String COLUMNS_ARG = "columns";
    public static final String SPLIT_BY_ARG = "split-by";
    public static final String SPLIT_LIMIT_ARG = "split-limit";
    public static final String WHERE_ARG = "where";
    public static final String HADOOP_HOME_ARG = "hadoop-home";
    public static final String HADOOP_MAPRED_HOME_ARG = "hadoop-mapred-home";
    public static final String HIVE_HOME_ARG = "hive-home";
    public static final String WAREHOUSE_DIR_ARG = "warehouse-dir";
    public static final String TARGET_DIR_ARG = "target-dir";
    public static final String APPEND_ARG = "append";
    public static final String DELETE_ARG = "delete-target-dir";
    public static final String NULL_STRING = "null-string";
    public static final String INPUT_NULL_STRING = "input-null-string";
    public static final String NULL_NON_STRING = "null-non-string";
    public static final String INPUT_NULL_NON_STRING = "input-null-non-string";
    public static final String MAP_COLUMN_JAVA = "map-column-java";
    public static final String MAP_COLUMN_HIVE = "map-column-hive";
    public static final String FMT_SEQUENCEFILE_ARG = "as-sequencefile";
    public static final String FMT_TEXTFILE_ARG = "as-textfile";
    public static final String FMT_AVRODATAFILE_ARG = "as-avrodatafile";
    public static final String FMT_PARQUETFILE_ARG = "as-parquetfile";
    public static final String HIVE_IMPORT_ARG = "hive-import";
    public static final String HIVE_TABLE_ARG = "hive-table";
    public static final String HIVE_DATABASE_ARG = "hive-database";
    public static final String HIVE_OVERWRITE_ARG = "hive-overwrite";
    public static final String HIVE_COMPUTE_STATS_ARG = "hive-compute-stats";
    public static final String HIVE_DROP_DELIMS_ARG = "hive-drop-import-delims";
    public static final String HIVE_DELIMS_REPLACEMENT_ARG = "hive-delims-replacement";
    public static final String HIVE_PARTITION_KEY_ARG = "hive-partition-key";
    public static final String HIVE_PARTITION_VALUE_ARG = "hive-partition-value";
    public static final String HCATCALOG_PARTITION_KEYS_ARG = "hcatalog-partition-keys";
    public static final String HCATALOG_PARTITION_VALUES_ARG = "hcatalog-partition-values";
    public static final String CREATE_HIVE_TABLE_ARG = "create-hive-table";
    public static final String HCATALOG_TABLE_ARG = "hcatalog-table";
    public static final String HCATALOG_DATABASE_ARG = "hcatalog-database";
    public static final String CREATE_HCATALOG_TABLE_ARG = "create-hcatalog-table";
    public static final String DROP_AND_CREATE_HCATALOG_TABLE = "drop-and-create-hcatalog-table";
    public static final String HCATALOG_STORAGE_STANZA_ARG = "hcatalog-storage-stanza";
    public static final String HCATALOG_HOME_ARG = "hcatalog-home";
    public static final String MAPREDUCE_JOB_NAME = "mapreduce-job-name";
    public static final String NUM_MAPPERS_ARG = "num-mappers";
    public static final String NUM_MAPPERS_SHORT_ARG = "m";
    public static final String COMPRESS_ARG = "compress";
    public static final String COMPRESSION_CODEC_ARG = "compression-codec";
    public static final String COMPRESS_SHORT_ARG = "z";
    public static final String DIRECT_SPLIT_SIZE_ARG = "direct-split-size";
    public static final String INLINE_LOB_LIMIT_ARG = "inline-lob-limit";
    public static final String FETCH_SIZE_ARG = "fetch-size";
    public static final String EXPORT_PATH_ARG = "export-dir";
    public static final String FIELDS_TERMINATED_BY_ARG = "fields-terminated-by";
    public static final String LINES_TERMINATED_BY_ARG = "lines-terminated-by";
    public static final String OPTIONALLY_ENCLOSED_BY_ARG = "optionally-enclosed-by";
    public static final String ENCLOSED_BY_ARG = "enclosed-by";
    public static final String ESCAPED_BY_ARG = "escaped-by";
    public static final String MYSQL_DELIMITERS_ARG = "mysql-delimiters";
    public static final String INPUT_FIELDS_TERMINATED_BY_ARG = "input-fields-terminated-by";
    public static final String INPUT_LINES_TERMINATED_BY_ARG = "input-lines-terminated-by";
    public static final String INPUT_OPTIONALLY_ENCLOSED_BY_ARG = "input-optionally-enclosed-by";
    public static final String INPUT_ENCLOSED_BY_ARG = "input-enclosed-by";
    public static final String INPUT_ESCAPED_BY_ARG = "input-escaped-by";
    public static final String CODE_OUT_DIR_ARG = "outdir";
    public static final String BIN_OUT_DIR_ARG = "bindir";
    public static final String PACKAGE_NAME_ARG = "package-name";
    public static final String CLASS_NAME_ARG = "class-name";
    public static final String JAR_FILE_NAME_ARG = "jar-file";
    public static final String SQL_QUERY_ARG = "query";
    public static final String SQL_QUERY_BOUNDARY = "boundary-query";
    public static final String SQL_QUERY_SHORT_ARG = "e";
    public static final String VERBOSE_ARG = "verbose";
    public static final String HELP_ARG = "help";
    public static final String TEMP_ROOTDIR_ARG = "temporary-rootdir";
    public static final String UPDATE_KEY_ARG = "update-key";
    public static final String UPDATE_MODE_ARG = "update-mode";
    public static final String CALL_ARG = "call";
    public static final String SKIP_DISTCACHE_ARG = "skip-dist-cache";
    public static final String RELAXED_ISOLATION = "relaxed-isolation";
    public static final String VALIDATE_ARG = "validate";
    public static final String VALIDATOR_CLASS_ARG = "validator";
    public static final String VALIDATION_THRESHOLD_CLASS_ARG = "validation-threshold";
    public static final String VALIDATION_FAILURE_HANDLER_CLASS_ARG = "validation-failurehandler";
    public static final String INCREMENT_TYPE_ARG = "incremental";
    public static final String INCREMENT_COL_ARG = "check-column";
    public static final String INCREMENT_LAST_VAL_ARG = "last-value";
    public static final String ALL_TABLE_EXCLUDES_ARG = "exclude-tables";
    public static final String HBASE_TABLE_ARG = "hbase-table";
    public static final String HBASE_COL_FAM_ARG = "column-family";
    public static final String HBASE_ROW_KEY_ARG = "hbase-row-key";
    public static final String HBASE_BULK_LOAD_ENABLED_ARG = "hbase-bulkload";
    public static final String HBASE_CREATE_TABLE_ARG = "hbase-create-table";
    public static final String ACCUMULO_TABLE_ARG = "accumulo-table";
    public static final String ACCUMULO_COL_FAM_ARG = "accumulo-column-family";
    public static final String ACCUMULO_ROW_KEY_ARG = "accumulo-row-key";
    public static final String ACCUMULO_VISIBILITY_ARG = "accumulo-visibility";
    public static final String ACCUMULO_CREATE_TABLE_ARG = "accumulo-create-table";
    public static final String ACCUMULO_BATCH_SIZE_ARG = "accumulo-batch-size";
    public static final String ACCUMULO_MAX_LATENCY_ARG = "accumulo-max-latency";
    public static final String ACCUMULO_ZOOKEEPERS_ARG = "accumulo-zookeepers";
    public static final String ACCUMULO_INSTANCE_ARG = "accumulo-instance";
    public static final String ACCUMULO_USER_ARG = "accumulo-user";
    public static final String ACCUMULO_PASSWORD_ARG = "accumulo-password";
    public static final String STORAGE_METASTORE_ARG = "meta-connect";
    public static final String JOB_CMD_CREATE_ARG = "create";
    public static final String JOB_CMD_DELETE_ARG = "delete";
    public static final String JOB_CMD_EXEC_ARG = "exec";
    public static final String JOB_CMD_LIST_ARG = "list";
    public static final String JOB_CMD_SHOW_ARG = "show";
    public static final String METASTORE_SHUTDOWN_ARG = "shutdown";
    public static final String NEW_DATASET_ARG = "new-data";
    public static final String OLD_DATASET_ARG = "onto";
    public static final String MERGE_KEY_ARG = "merge-key";
    public static final String AUTORESET_TO_ONE_MAPPER = "autoreset-to-one-mapper";
    protected ConnManager manager;

    public BaseSqoopTool() {
    }

    public BaseSqoopTool(String toolName) {
        super(toolName);
    }

    public ConnManager getManager() {
        return this.manager;
    }

    public void setManager(ConnManager mgr) {
        this.manager = mgr;
    }

    protected boolean init(SqoopOptions sqoopOpts) {
        sqoopOpts.setToolName(this.getToolName());
        try {
            JobData data = new JobData(sqoopOpts, this);
            this.manager = new ConnFactory(sqoopOpts.getConf()).getManager(data);
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)("Got error creating database manager: " + StringUtils.stringifyException((Throwable)e)));
            if (System.getProperty("sqoop.throwOnError") != null) {
                throw new RuntimeException(e);
            }
            return false;
        }
    }

    protected void destroy(SqoopOptions sqoopOpts) {
        if (null != this.manager) {
            try {
                this.manager.close();
            }
            catch (SQLException sqlE) {
                LOG.warn((Object)("Error while closing connection: " + sqlE));
            }
        }
    }

    protected boolean hasUnrecognizedArgs(String[] argv, int offset, int len) {
        if (argv == null) {
            return false;
        }
        boolean unrecognized = false;
        boolean printedBanner = false;
        for (int i = offset; i < Math.min(argv.length, offset + len); ++i) {
            if (argv[i] == null || argv[i].length() <= 0) continue;
            if (!printedBanner) {
                LOG.error((Object)("Error parsing arguments for " + this.getToolName() + ":"));
                printedBanner = true;
            }
            LOG.error((Object)("Unrecognized argument: " + argv[i]));
            unrecognized = true;
        }
        return unrecognized;
    }

    protected boolean hasUnrecognizedArgs(String[] argv) {
        if (null == argv) {
            return false;
        }
        return this.hasUnrecognizedArgs(argv, 0, argv.length);
    }

    protected String[] getSubcommandArgs(String[] argv) {
        if (null == argv) {
            return null;
        }
        for (int i = 0; i < argv.length; ++i) {
            if (!argv[i].equals("--")) continue;
            return Arrays.copyOfRange(argv, i + 1, argv.length);
        }
        return null;
    }

    protected RelatedOptions getJobOptions() {
        RelatedOptions relatedOpts = new RelatedOptions("Job management arguments");
        OptionBuilder.withArgName((String)"jdbc-uri");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Specify JDBC connect string for the metastore");
        OptionBuilder.withLongOpt((String)STORAGE_METASTORE_ARG);
        relatedOpts.addOption(OptionBuilder.create());
        OptionGroup group = new OptionGroup();
        OptionBuilder.withArgName((String)"job-id");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Create a new saved job");
        OptionBuilder.withLongOpt((String)JOB_CMD_CREATE_ARG);
        group.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"job-id");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Delete a saved job");
        OptionBuilder.withLongOpt((String)JOB_CMD_DELETE_ARG);
        group.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"job-id");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Show the parameters for a saved job");
        OptionBuilder.withLongOpt((String)JOB_CMD_SHOW_ARG);
        group.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"job-id");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Run a saved job");
        OptionBuilder.withLongOpt((String)JOB_CMD_EXEC_ARG);
        Option execOption = OptionBuilder.create();
        group.addOption(execOption);
        OptionBuilder.withDescription((String)"List saved jobs");
        OptionBuilder.withLongOpt((String)JOB_CMD_LIST_ARG);
        group.addOption(OptionBuilder.create());
        relatedOpts.addOptionGroup(group);
        OptionBuilder.withDescription((String)"Print more information while working");
        OptionBuilder.withLongOpt((String)VERBOSE_ARG);
        relatedOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Print usage instructions");
        OptionBuilder.withLongOpt((String)HELP_ARG);
        relatedOpts.addOption(OptionBuilder.create());
        return relatedOpts;
    }

    protected RelatedOptions getCommonOptions() {
        RelatedOptions commonOpts = new RelatedOptions("Common arguments");
        OptionBuilder.withArgName((String)"jdbc-uri");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Specify JDBC connect string");
        OptionBuilder.withLongOpt((String)CONNECT_STRING_ARG);
        commonOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)CLASS_NAME_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Specify connection manager class name");
        OptionBuilder.withLongOpt((String)CONN_MANAGER_CLASS_NAME);
        commonOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"properties-file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Specify connection parameters file");
        OptionBuilder.withLongOpt((String)CONNECT_PARAM_FILE);
        commonOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)CLASS_NAME_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Manually specify JDBC driver class to use");
        OptionBuilder.withLongOpt((String)DRIVER_ARG);
        commonOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)USERNAME_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Set authentication username");
        OptionBuilder.withLongOpt((String)USERNAME_ARG);
        commonOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)PASSWORD_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Set authentication password");
        OptionBuilder.withLongOpt((String)PASSWORD_ARG);
        commonOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)PASSWORD_PATH_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Set authentication password file path");
        OptionBuilder.withLongOpt((String)PASSWORD_PATH_ARG);
        commonOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Read password from console");
        commonOpts.addOption(OptionBuilder.create((String)PASSWORD_PROMPT_ARG));
        OptionBuilder.withArgName((String)PASSWORD_ALIAS_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Credential provider password alias");
        OptionBuilder.withLongOpt((String)PASSWORD_ALIAS_ARG);
        commonOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"dir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Override $HADOOP_MAPRED_HOME_ARG");
        OptionBuilder.withLongOpt((String)HADOOP_MAPRED_HOME_ARG);
        commonOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"hdir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Override $HADOOP_MAPRED_HOME_ARG");
        OptionBuilder.withLongOpt((String)HADOOP_HOME_ARG);
        commonOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Skip copying jars to distributed cache");
        OptionBuilder.withLongOpt((String)SKIP_DISTCACHE_ARG);
        commonOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Print more information while working");
        OptionBuilder.withLongOpt((String)VERBOSE_ARG);
        commonOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Print usage instructions");
        OptionBuilder.withLongOpt((String)HELP_ARG);
        commonOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Defines the temporary root directory for the import");
        OptionBuilder.withLongOpt((String)TEMP_ROOTDIR_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"rootdir");
        commonOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Use read-uncommitted isolation for imports");
        OptionBuilder.withLongOpt((String)RELAXED_ISOLATION);
        commonOpts.addOption(OptionBuilder.create());
        return commonOpts;
    }

    protected RelatedOptions getHiveOptions(boolean explicitHiveImport) {
        RelatedOptions hiveOpts = new RelatedOptions("Hive arguments");
        if (explicitHiveImport) {
            OptionBuilder.withDescription((String)"Import tables into Hive (Uses Hive's default delimiters if none are set.)");
            OptionBuilder.withLongOpt((String)HIVE_IMPORT_ARG);
            hiveOpts.addOption(OptionBuilder.create());
        }
        OptionBuilder.withArgName((String)"dir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Override $HIVE_HOME");
        OptionBuilder.withLongOpt((String)HIVE_HOME_ARG);
        hiveOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Overwrite existing data in the Hive table");
        OptionBuilder.withLongOpt((String)HIVE_OVERWRITE_ARG);
        hiveOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Overwrite existing data in the Hive table");
        OptionBuilder.withLongOpt((String)HIVE_COMPUTE_STATS_ARG);
        hiveOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Fail if the target hive table exists");
        OptionBuilder.withLongOpt((String)CREATE_HIVE_TABLE_ARG);
        hiveOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"table-name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Sets the table name to use when importing to hive");
        OptionBuilder.withLongOpt((String)HIVE_TABLE_ARG);
        hiveOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"database-name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Sets the database name to use when importing to hive");
        OptionBuilder.withLongOpt((String)HIVE_DATABASE_ARG);
        hiveOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Drop Hive record \\0x01 and row delimiters (\\n\\r) from imported string fields");
        OptionBuilder.withLongOpt((String)HIVE_DROP_DELIMS_ARG);
        hiveOpts.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Replace Hive record \\0x01 and row delimiters (\\n\\r) from imported string fields with user-defined string");
        OptionBuilder.withLongOpt((String)HIVE_DELIMS_REPLACEMENT_ARG);
        hiveOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"partition-key");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Sets the partition key to use when importing to hive");
        OptionBuilder.withLongOpt((String)HIVE_PARTITION_KEY_ARG);
        hiveOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"partition-value");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Sets the partition value to use when importing to hive");
        OptionBuilder.withLongOpt((String)HIVE_PARTITION_VALUE_ARG);
        hiveOpts.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Override mapping for specific column to hive types.");
        OptionBuilder.withLongOpt((String)MAP_COLUMN_HIVE);
        hiveOpts.addOption(OptionBuilder.create());
        return hiveOpts;
    }

    protected RelatedOptions getHCatalogOptions() {
        RelatedOptions hCatOptions = new RelatedOptions("HCatalog arguments");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"HCatalog table name");
        OptionBuilder.withLongOpt((String)HCATALOG_TABLE_ARG);
        hCatOptions.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"HCatalog database name");
        OptionBuilder.withLongOpt((String)HCATALOG_DATABASE_ARG);
        hCatOptions.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"dir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Override $HIVE_HOME");
        OptionBuilder.withLongOpt((String)HIVE_HOME_ARG);
        hCatOptions.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"hdir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Override $HCAT_HOME");
        OptionBuilder.withLongOpt((String)HCATALOG_HOME_ARG);
        hCatOptions.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"partition-key");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Sets the partition key to use when importing to hive");
        OptionBuilder.withLongOpt((String)HIVE_PARTITION_KEY_ARG);
        hCatOptions.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"partition-value");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Sets the partition value to use when importing to hive");
        OptionBuilder.withLongOpt((String)HIVE_PARTITION_VALUE_ARG);
        hCatOptions.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Override mapping for specific column to hive types.");
        OptionBuilder.withLongOpt((String)MAP_COLUMN_HIVE);
        hCatOptions.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"partition-key");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Sets the partition keys to use when importing to hive");
        OptionBuilder.withLongOpt((String)HCATCALOG_PARTITION_KEYS_ARG);
        hCatOptions.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"partition-value");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Sets the partition values to use when importing to hive");
        OptionBuilder.withLongOpt((String)HCATALOG_PARTITION_VALUES_ARG);
        hCatOptions.addOption(OptionBuilder.create());
        return hCatOptions;
    }

    protected RelatedOptions getHCatImportOnlyOptions() {
        RelatedOptions hCatOptions = new RelatedOptions("HCatalog import specific options");
        OptionBuilder.withDescription((String)"Create HCatalog before import");
        OptionBuilder.withLongOpt((String)CREATE_HCATALOG_TABLE_ARG);
        hCatOptions.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Drop and Create HCatalog before import");
        OptionBuilder.withLongOpt((String)DROP_AND_CREATE_HCATALOG_TABLE);
        hCatOptions.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"HCatalog storage stanza for table creation");
        OptionBuilder.withLongOpt((String)HCATALOG_STORAGE_STANZA_ARG);
        hCatOptions.addOption(OptionBuilder.create());
        return hCatOptions;
    }

    protected RelatedOptions getOutputFormatOptions() {
        RelatedOptions formatOpts = new RelatedOptions("Output line formatting arguments");
        OptionBuilder.withArgName((String)"char");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Sets the field separator character");
        OptionBuilder.withLongOpt((String)FIELDS_TERMINATED_BY_ARG);
        formatOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"char");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Sets the end-of-line character");
        OptionBuilder.withLongOpt((String)LINES_TERMINATED_BY_ARG);
        formatOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"char");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Sets a field enclosing character");
        OptionBuilder.withLongOpt((String)OPTIONALLY_ENCLOSED_BY_ARG);
        formatOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"char");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Sets a required field enclosing character");
        OptionBuilder.withLongOpt((String)ENCLOSED_BY_ARG);
        formatOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"char");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Sets the escape character");
        OptionBuilder.withLongOpt((String)ESCAPED_BY_ARG);
        formatOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Uses MySQL's default delimiter set: fields: ,  lines: \\n  escaped-by: \\  optionally-enclosed-by: '");
        OptionBuilder.withLongOpt((String)MYSQL_DELIMITERS_ARG);
        formatOpts.addOption(OptionBuilder.create());
        return formatOpts;
    }

    protected RelatedOptions getInputFormatOptions() {
        RelatedOptions inputFormatOpts = new RelatedOptions("Input parsing arguments");
        OptionBuilder.withArgName((String)"char");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Sets the input field separator");
        OptionBuilder.withLongOpt((String)INPUT_FIELDS_TERMINATED_BY_ARG);
        inputFormatOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"char");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Sets the input end-of-line char");
        OptionBuilder.withLongOpt((String)INPUT_LINES_TERMINATED_BY_ARG);
        inputFormatOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"char");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Sets a field enclosing character");
        OptionBuilder.withLongOpt((String)INPUT_OPTIONALLY_ENCLOSED_BY_ARG);
        inputFormatOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"char");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Sets a required field encloser");
        OptionBuilder.withLongOpt((String)INPUT_ENCLOSED_BY_ARG);
        inputFormatOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"char");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Sets the input escape character");
        OptionBuilder.withLongOpt((String)INPUT_ESCAPED_BY_ARG);
        inputFormatOpts.addOption(OptionBuilder.create());
        return inputFormatOpts;
    }

    protected RelatedOptions getCodeGenOpts(boolean multiTable) {
        RelatedOptions codeGenOpts = new RelatedOptions("Code generation arguments");
        OptionBuilder.withArgName((String)"dir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Output directory for generated code");
        OptionBuilder.withLongOpt((String)CODE_OUT_DIR_ARG);
        codeGenOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"dir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Output directory for compiled objects");
        OptionBuilder.withLongOpt((String)BIN_OUT_DIR_ARG);
        codeGenOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Put auto-generated classes in this package");
        OptionBuilder.withLongOpt((String)PACKAGE_NAME_ARG);
        codeGenOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"null-str");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Null string representation");
        OptionBuilder.withLongOpt((String)NULL_STRING);
        codeGenOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"null-str");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Input null string representation");
        OptionBuilder.withLongOpt((String)INPUT_NULL_STRING);
        codeGenOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"null-str");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Null non-string representation");
        OptionBuilder.withLongOpt((String)NULL_NON_STRING);
        codeGenOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"null-str");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Input null non-string representation");
        OptionBuilder.withLongOpt((String)INPUT_NULL_NON_STRING);
        codeGenOpts.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Override mapping for specific columns to java types");
        OptionBuilder.withLongOpt((String)MAP_COLUMN_JAVA);
        codeGenOpts.addOption(OptionBuilder.create());
        if (!multiTable) {
            OptionBuilder.withArgName((String)"name");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Sets the generated class name. This overrides --package-name. When combined with --jar-file, sets the input class.");
            OptionBuilder.withLongOpt((String)CLASS_NAME_ARG);
            codeGenOpts.addOption(OptionBuilder.create());
        }
        return codeGenOpts;
    }

    protected RelatedOptions getHBaseOptions() {
        RelatedOptions hbaseOpts = new RelatedOptions("HBase arguments");
        OptionBuilder.withArgName((String)TABLE_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Import to <table> in HBase");
        OptionBuilder.withLongOpt((String)HBASE_TABLE_ARG);
        hbaseOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"family");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Sets the target column family for the import");
        OptionBuilder.withLongOpt((String)HBASE_COL_FAM_ARG);
        hbaseOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"col");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Specifies which input column to use as the row key");
        OptionBuilder.withLongOpt((String)HBASE_ROW_KEY_ARG);
        hbaseOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Enables HBase bulk loading");
        OptionBuilder.withLongOpt((String)HBASE_BULK_LOAD_ENABLED_ARG);
        hbaseOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"If specified, create missing HBase tables");
        OptionBuilder.withLongOpt((String)HBASE_CREATE_TABLE_ARG);
        hbaseOpts.addOption(OptionBuilder.create());
        return hbaseOpts;
    }

    protected RelatedOptions getAccumuloOptions() {
        RelatedOptions accumuloOpts = new RelatedOptions("Accumulo arguments");
        OptionBuilder.withArgName((String)TABLE_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Import to <table> in Accumulo");
        OptionBuilder.withLongOpt((String)ACCUMULO_TABLE_ARG);
        accumuloOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"family");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Sets the target column family for the import");
        OptionBuilder.withLongOpt((String)ACCUMULO_COL_FAM_ARG);
        accumuloOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"col");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Specifies which input column to use as the row key");
        OptionBuilder.withLongOpt((String)ACCUMULO_ROW_KEY_ARG);
        accumuloOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"vis");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Visibility token to be applied to all rows imported");
        OptionBuilder.withLongOpt((String)ACCUMULO_VISIBILITY_ARG);
        accumuloOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"If specified, create missing Accumulo tables");
        OptionBuilder.withLongOpt((String)ACCUMULO_CREATE_TABLE_ARG);
        accumuloOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"size");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Batch size in bytes");
        OptionBuilder.withLongOpt((String)ACCUMULO_BATCH_SIZE_ARG);
        accumuloOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"latency");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Max write latency in milliseconds");
        OptionBuilder.withLongOpt((String)ACCUMULO_MAX_LATENCY_ARG);
        accumuloOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"zookeepers");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Comma-separated list of zookeepers (host:port)");
        OptionBuilder.withLongOpt((String)ACCUMULO_ZOOKEEPERS_ARG);
        accumuloOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"instance");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Accumulo instance name.");
        OptionBuilder.withLongOpt((String)ACCUMULO_INSTANCE_ARG);
        accumuloOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"user");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Accumulo user name.");
        OptionBuilder.withLongOpt((String)ACCUMULO_USER_ARG);
        accumuloOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)PASSWORD_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Accumulo password.");
        OptionBuilder.withLongOpt((String)ACCUMULO_PASSWORD_ARG);
        accumuloOpts.addOption(OptionBuilder.create());
        return accumuloOpts;
    }

    protected void applyAccumuloOptions(CommandLine in, SqoopOptions out) {
        if (in.hasOption(ACCUMULO_TABLE_ARG)) {
            out.setAccumuloTable(in.getOptionValue(ACCUMULO_TABLE_ARG));
        }
        if (in.hasOption(ACCUMULO_COL_FAM_ARG)) {
            out.setAccumuloColFamily(in.getOptionValue(ACCUMULO_COL_FAM_ARG));
        }
        if (in.hasOption(ACCUMULO_ROW_KEY_ARG)) {
            out.setAccumuloRowKeyColumn(in.getOptionValue(ACCUMULO_ROW_KEY_ARG));
        }
        if (in.hasOption(ACCUMULO_VISIBILITY_ARG)) {
            out.setAccumuloVisibility(in.getOptionValue(ACCUMULO_VISIBILITY_ARG));
        }
        if (in.hasOption(ACCUMULO_CREATE_TABLE_ARG)) {
            out.setCreateAccumuloTable(true);
        }
        if (in.hasOption(ACCUMULO_BATCH_SIZE_ARG)) {
            out.setAccumuloBatchSize(Long.parseLong(in.getOptionValue(ACCUMULO_BATCH_SIZE_ARG)));
        }
        if (in.hasOption(ACCUMULO_MAX_LATENCY_ARG)) {
            out.setAccumuloMaxLatency(Long.parseLong(in.getOptionValue(ACCUMULO_MAX_LATENCY_ARG)));
        }
        if (in.hasOption(ACCUMULO_ZOOKEEPERS_ARG)) {
            out.setAccumuloZookeepers(in.getOptionValue(ACCUMULO_ZOOKEEPERS_ARG));
        }
        if (in.hasOption(ACCUMULO_INSTANCE_ARG)) {
            out.setAccumuloInstance(in.getOptionValue(ACCUMULO_INSTANCE_ARG));
        }
        if (in.hasOption(ACCUMULO_USER_ARG)) {
            out.setAccumuloUser(in.getOptionValue(ACCUMULO_USER_ARG));
        }
        if (in.hasOption(ACCUMULO_PASSWORD_ARG)) {
            out.setAccumuloPassword(in.getOptionValue(ACCUMULO_PASSWORD_ARG));
        }
    }

    protected void addValidationOpts(RelatedOptions validationOptions) {
        OptionBuilder.withDescription((String)"Validate the copy using the configured validator");
        OptionBuilder.withLongOpt((String)VALIDATE_ARG);
        validationOptions.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)VALIDATOR_CLASS_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Fully qualified class name for the Validator");
        OptionBuilder.withLongOpt((String)VALIDATOR_CLASS_ARG);
        validationOptions.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)VALIDATION_THRESHOLD_CLASS_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Fully qualified class name for ValidationThreshold");
        OptionBuilder.withLongOpt((String)VALIDATION_THRESHOLD_CLASS_ARG);
        validationOptions.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)VALIDATION_FAILURE_HANDLER_CLASS_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Fully qualified class name for ValidationFailureHandler");
        OptionBuilder.withLongOpt((String)VALIDATION_FAILURE_HANDLER_CLASS_ARG);
        validationOptions.addOption(OptionBuilder.create());
    }

    protected void applyCommonOptions(CommandLine in, SqoopOptions out) throws SqoopOptions.InvalidOptionsException {
        if (in.hasOption(VERBOSE_ARG)) {
            out.setVerbose(true);
            LoggingUtils.setDebugLevel();
            LOG.debug((Object)"Enabled debug logging.");
        }
        if (in.hasOption(HELP_ARG)) {
            ToolOptions toolOpts = new ToolOptions();
            this.configureOptions(toolOpts);
            this.printHelp(toolOpts);
            throw new SqoopOptions.InvalidOptionsException("");
        }
        if (in.hasOption(TEMP_ROOTDIR_ARG)) {
            out.setTempRootDir(in.getOptionValue(TEMP_ROOTDIR_ARG));
        }
        if (in.hasOption(CONNECT_STRING_ARG)) {
            out.setConnectString(in.getOptionValue(CONNECT_STRING_ARG));
        }
        if (in.hasOption(CONN_MANAGER_CLASS_NAME)) {
            out.setConnManagerClassName(in.getOptionValue(CONN_MANAGER_CLASS_NAME));
        }
        if (in.hasOption(CONNECT_PARAM_FILE)) {
            File paramFile = new File(in.getOptionValue(CONNECT_PARAM_FILE));
            if (!paramFile.exists()) {
                throw new SqoopOptions.InvalidOptionsException("Specified connection parameter file not found: " + paramFile);
            }
            InputStream inStream = null;
            Properties connectionParams = new Properties();
            try {
                inStream = new FileInputStream(new File(in.getOptionValue(CONNECT_PARAM_FILE)));
                connectionParams.load(inStream);
            }
            catch (IOException ex) {
                LOG.warn((Object)"Failed to load connection parameter file", (Throwable)ex);
                throw new SqoopOptions.InvalidOptionsException("Error while loading connection parameter file: " + ex.getMessage());
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException ex) {
                        LOG.warn((Object)"Failed to close input stream", (Throwable)ex);
                    }
                }
            }
            LOG.debug((Object)("Loaded connection parameters: " + connectionParams));
            out.setConnectionParams(connectionParams);
        }
        if (in.hasOption(NULL_STRING)) {
            out.setNullStringValue(in.getOptionValue(NULL_STRING));
        }
        if (in.hasOption(INPUT_NULL_STRING)) {
            out.setInNullStringValue(in.getOptionValue(INPUT_NULL_STRING));
        }
        if (in.hasOption(NULL_NON_STRING)) {
            out.setNullNonStringValue(in.getOptionValue(NULL_NON_STRING));
        }
        if (in.hasOption(INPUT_NULL_NON_STRING)) {
            out.setInNullNonStringValue(in.getOptionValue(INPUT_NULL_NON_STRING));
        }
        if (in.hasOption(DRIVER_ARG)) {
            out.setDriverClassName(in.getOptionValue(DRIVER_ARG));
        }
        if (in.hasOption(SKIP_DISTCACHE_ARG)) {
            LOG.debug((Object)"Disabling dist cache");
            out.setSkipDistCache(true);
        }
        this.applyCredentialsOptions(in, out);
        if (in.hasOption(HADOOP_MAPRED_HOME_ARG)) {
            out.setHadoopMapRedHome(in.getOptionValue(HADOOP_MAPRED_HOME_ARG));
        } else if (in.hasOption(HADOOP_HOME_ARG)) {
            out.setHadoopMapRedHome(in.getOptionValue(HADOOP_HOME_ARG));
        }
        if (in.hasOption(RELAXED_ISOLATION)) {
            out.setRelaxedIsolation(true);
        }
    }

    private void applyCredentialsOptions(CommandLine in, SqoopOptions out) throws SqoopOptions.InvalidOptionsException {
        if (in.hasOption(USERNAME_ARG)) {
            out.setUsername(in.getOptionValue(USERNAME_ARG));
            if (null == out.getPassword()) {
                out.setPassword("");
            }
        }
        if (in.hasOption(PASSWORD_ARG)) {
            LOG.warn((Object)"Setting your password on the command-line is insecure. Consider using -P instead.");
            out.setPassword(in.getOptionValue(PASSWORD_ARG));
        }
        if (in.hasOption(PASSWORD_PROMPT_ARG)) {
            out.setPasswordFromConsole();
        }
        if (in.hasOption(PASSWORD_PATH_ARG)) {
            if (in.hasOption(PASSWORD_ARG) || in.hasOption(PASSWORD_PROMPT_ARG) || in.hasOption(PASSWORD_ALIAS_ARG)) {
                throw new SqoopOptions.InvalidOptionsException("Only one of password, password alias or path to a password file must be specified.");
            }
            try {
                out.setPasswordFilePath(in.getOptionValue(PASSWORD_PATH_ARG));
                out.setPassword(CredentialsUtil.fetchPassword(out));
                CredentialsUtil.cleanUpSensitiveProperties(out.getConf());
            }
            catch (IOException ex) {
                LOG.warn((Object)"Failed to load password file", (Throwable)ex);
                throw (SqoopOptions.InvalidOptionsException)new SqoopOptions.InvalidOptionsException("Error while loading password file: " + ex.getMessage()).initCause(ex);
            }
        }
        if (in.hasOption(PASSWORD_ALIAS_ARG)) {
            if (in.hasOption(PASSWORD_ARG) || in.hasOption(PASSWORD_PROMPT_ARG) || in.hasOption(PASSWORD_PATH_ARG)) {
                throw new SqoopOptions.InvalidOptionsException("Only one of password, password alias or path to a password file must be specified.");
            }
            out.setPasswordAlias(in.getOptionValue(PASSWORD_ALIAS_ARG));
            if (!CredentialProviderHelper.isProviderAvailable()) {
                throw new SqoopOptions.InvalidOptionsException("CredentialProvider facility not available in the hadoop  environment used");
            }
            try {
                out.setPassword(CredentialProviderHelper.resolveAlias(out.getConf(), in.getOptionValue(PASSWORD_ALIAS_ARG)));
            }
            catch (IOException ioe) {
                throw (SqoopOptions.InvalidOptionsException)new SqoopOptions.InvalidOptionsException("Unable to process alias").initCause(ioe);
            }
        }
    }

    protected void applyHiveOptions(CommandLine in, SqoopOptions out) throws SqoopOptions.InvalidOptionsException {
        if (in.hasOption(HIVE_HOME_ARG)) {
            out.setHiveHome(in.getOptionValue(HIVE_HOME_ARG));
        }
        if (in.hasOption(HIVE_IMPORT_ARG)) {
            out.setHiveImport(true);
        }
        if (in.hasOption(HIVE_OVERWRITE_ARG)) {
            out.setOverwriteHiveTable(true);
        }
        if (in.hasOption(HIVE_COMPUTE_STATS_ARG)) {
            out.setComputeStatsHiveTable(true);
        }
        if (in.hasOption(CREATE_HIVE_TABLE_ARG)) {
            out.setFailIfHiveTableExists(true);
        }
        if (in.hasOption(HIVE_TABLE_ARG)) {
            out.setHiveTableName(in.getOptionValue(HIVE_TABLE_ARG));
        }
        if (in.hasOption(HIVE_DATABASE_ARG)) {
            out.setHiveDatabaseName(in.getOptionValue(HIVE_DATABASE_ARG));
        }
        if (in.hasOption(HIVE_DROP_DELIMS_ARG)) {
            out.setHiveDropDelims(true);
        }
        if (in.hasOption(HIVE_DELIMS_REPLACEMENT_ARG)) {
            out.setHiveDelimsReplacement(in.getOptionValue(HIVE_DELIMS_REPLACEMENT_ARG));
        }
        if (in.hasOption(HIVE_PARTITION_KEY_ARG)) {
            out.setHivePartitionKey(in.getOptionValue(HIVE_PARTITION_KEY_ARG));
        }
        if (in.hasOption(HIVE_PARTITION_VALUE_ARG)) {
            out.setHivePartitionValue(in.getOptionValue(HIVE_PARTITION_VALUE_ARG));
        }
        if (in.hasOption(MAP_COLUMN_HIVE)) {
            out.setMapColumnHive(in.getOptionValue(MAP_COLUMN_HIVE));
        }
    }

    protected void applyHCatalogOptions(CommandLine in, SqoopOptions out) {
        if (in.hasOption(HCATALOG_TABLE_ARG)) {
            out.setHCatTableName(in.getOptionValue(HCATALOG_TABLE_ARG));
        }
        if (in.hasOption(HCATALOG_DATABASE_ARG)) {
            out.setHCatDatabaseName(in.getOptionValue(HCATALOG_DATABASE_ARG));
        }
        if (in.hasOption(HCATALOG_STORAGE_STANZA_ARG)) {
            out.setHCatStorageStanza(in.getOptionValue(HCATALOG_STORAGE_STANZA_ARG));
        }
        if (in.hasOption(CREATE_HCATALOG_TABLE_ARG)) {
            out.setCreateHCatalogTable(true);
        }
        if (in.hasOption(DROP_AND_CREATE_HCATALOG_TABLE)) {
            out.setDropAndCreateHCatalogTable(true);
        }
        if (in.hasOption(HCATALOG_HOME_ARG)) {
            out.setHCatHome(in.getOptionValue(HCATALOG_HOME_ARG));
        }
        if (in.hasOption(HIVE_HOME_ARG)) {
            out.setHiveHome(in.getOptionValue(HIVE_HOME_ARG));
        }
        if (in.hasOption(HCATCALOG_PARTITION_KEYS_ARG)) {
            out.setHCatalogPartitionKeys(in.getOptionValue(HCATCALOG_PARTITION_KEYS_ARG));
        }
        if (in.hasOption(HCATALOG_PARTITION_VALUES_ARG)) {
            out.setHCatalogPartitionValues(in.getOptionValue(HCATALOG_PARTITION_VALUES_ARG));
        }
        if (in.hasOption(HIVE_PARTITION_KEY_ARG)) {
            out.setHivePartitionKey(in.getOptionValue(HIVE_PARTITION_KEY_ARG));
        }
        if (in.hasOption(HIVE_PARTITION_VALUE_ARG)) {
            out.setHivePartitionValue(in.getOptionValue(HIVE_PARTITION_VALUE_ARG));
        }
        if (in.hasOption(MAP_COLUMN_HIVE)) {
            out.setMapColumnHive(in.getOptionValue(MAP_COLUMN_HIVE));
        }
    }

    protected void applyOutputFormatOptions(CommandLine in, SqoopOptions out) throws SqoopOptions.InvalidOptionsException {
        if (in.hasOption(FIELDS_TERMINATED_BY_ARG)) {
            out.setFieldsTerminatedBy(SqoopOptions.toChar(in.getOptionValue(FIELDS_TERMINATED_BY_ARG)));
            out.setExplicitOutputDelims(true);
        }
        if (in.hasOption(LINES_TERMINATED_BY_ARG)) {
            out.setLinesTerminatedBy(SqoopOptions.toChar(in.getOptionValue(LINES_TERMINATED_BY_ARG)));
            out.setExplicitOutputDelims(true);
        }
        if (in.hasOption(OPTIONALLY_ENCLOSED_BY_ARG)) {
            out.setEnclosedBy(SqoopOptions.toChar(in.getOptionValue(OPTIONALLY_ENCLOSED_BY_ARG)));
            out.setOutputEncloseRequired(false);
            out.setExplicitOutputDelims(true);
        }
        if (in.hasOption(ENCLOSED_BY_ARG)) {
            out.setEnclosedBy(SqoopOptions.toChar(in.getOptionValue(ENCLOSED_BY_ARG)));
            out.setOutputEncloseRequired(true);
            out.setExplicitOutputDelims(true);
        }
        if (in.hasOption(ESCAPED_BY_ARG)) {
            out.setEscapedBy(SqoopOptions.toChar(in.getOptionValue(ESCAPED_BY_ARG)));
            out.setExplicitOutputDelims(true);
        }
        if (in.hasOption(MYSQL_DELIMITERS_ARG)) {
            out.setOutputEncloseRequired(false);
            out.setFieldsTerminatedBy(',');
            out.setLinesTerminatedBy('\n');
            out.setEscapedBy('\\');
            out.setEnclosedBy('\'');
            out.setExplicitOutputDelims(true);
        }
    }

    protected void applyInputFormatOptions(CommandLine in, SqoopOptions out) throws SqoopOptions.InvalidOptionsException {
        if (in.hasOption(INPUT_FIELDS_TERMINATED_BY_ARG)) {
            out.setInputFieldsTerminatedBy(SqoopOptions.toChar(in.getOptionValue(INPUT_FIELDS_TERMINATED_BY_ARG)));
            out.setExplicitInputDelims(true);
        }
        if (in.hasOption(INPUT_LINES_TERMINATED_BY_ARG)) {
            out.setInputLinesTerminatedBy(SqoopOptions.toChar(in.getOptionValue(INPUT_LINES_TERMINATED_BY_ARG)));
            out.setExplicitInputDelims(true);
        }
        if (in.hasOption(INPUT_OPTIONALLY_ENCLOSED_BY_ARG)) {
            out.setInputEnclosedBy(SqoopOptions.toChar(in.getOptionValue(INPUT_OPTIONALLY_ENCLOSED_BY_ARG)));
            out.setInputEncloseRequired(false);
            out.setExplicitInputDelims(true);
        }
        if (in.hasOption(INPUT_ENCLOSED_BY_ARG)) {
            out.setInputEnclosedBy(SqoopOptions.toChar(in.getOptionValue(INPUT_ENCLOSED_BY_ARG)));
            out.setInputEncloseRequired(true);
            out.setExplicitInputDelims(true);
        }
        if (in.hasOption(INPUT_ESCAPED_BY_ARG)) {
            out.setInputEscapedBy(SqoopOptions.toChar(in.getOptionValue(INPUT_ESCAPED_BY_ARG)));
            out.setExplicitInputDelims(true);
        }
    }

    protected void applyCodeGenOptions(CommandLine in, SqoopOptions out, boolean multiTable) throws SqoopOptions.InvalidOptionsException {
        if (in.hasOption(CODE_OUT_DIR_ARG)) {
            out.setCodeOutputDir(in.getOptionValue(CODE_OUT_DIR_ARG));
        }
        if (in.hasOption(BIN_OUT_DIR_ARG)) {
            out.setJarOutputDir(in.getOptionValue(BIN_OUT_DIR_ARG));
        }
        if (in.hasOption(PACKAGE_NAME_ARG)) {
            out.setPackageName(in.getOptionValue(PACKAGE_NAME_ARG));
        }
        if (in.hasOption(MAP_COLUMN_JAVA)) {
            out.setMapColumnJava(in.getOptionValue(MAP_COLUMN_JAVA));
        }
        if (!multiTable && in.hasOption(CLASS_NAME_ARG)) {
            out.setClassName(in.getOptionValue(CLASS_NAME_ARG));
        }
    }

    protected void applyHBaseOptions(CommandLine in, SqoopOptions out) {
        if (in.hasOption(HBASE_TABLE_ARG)) {
            out.setHBaseTable(in.getOptionValue(HBASE_TABLE_ARG));
        }
        if (in.hasOption(HBASE_COL_FAM_ARG)) {
            out.setHBaseColFamily(in.getOptionValue(HBASE_COL_FAM_ARG));
        }
        if (in.hasOption(HBASE_ROW_KEY_ARG)) {
            out.setHBaseRowKeyColumn(in.getOptionValue(HBASE_ROW_KEY_ARG));
        }
        out.setHBaseBulkLoadEnabled(in.hasOption(HBASE_BULK_LOAD_ENABLED_ARG));
        if (in.hasOption(HBASE_CREATE_TABLE_ARG)) {
            out.setCreateHBaseTable(true);
        }
    }

    protected void applyValidationOptions(CommandLine in, SqoopOptions out) throws SqoopOptions.InvalidOptionsException {
        if (in.hasOption(VALIDATE_ARG)) {
            out.setValidationEnabled(true);
        }
        if (in.hasOption(VALIDATOR_CLASS_ARG)) {
            out.setValidatorClass(this.getClassByName(in.getOptionValue(VALIDATOR_CLASS_ARG)));
        }
        if (in.hasOption(VALIDATION_THRESHOLD_CLASS_ARG)) {
            out.setValidationThresholdClass(this.getClassByName(in.getOptionValue(VALIDATION_THRESHOLD_CLASS_ARG)));
        }
        if (in.hasOption(VALIDATION_FAILURE_HANDLER_CLASS_ARG)) {
            out.setValidationFailureHandlerClass(this.getClassByName(in.getOptionValue(VALIDATION_FAILURE_HANDLER_CLASS_ARG)));
        }
    }

    protected Class<?> getClassByName(String className) throws SqoopOptions.InvalidOptionsException {
        try {
            return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new SqoopOptions.InvalidOptionsException(e.getMessage());
        }
    }

    protected void validateCommonOptions(SqoopOptions options) throws SqoopOptions.InvalidOptionsException {
        if (options.getConnectString() == null) {
            throw new SqoopOptions.InvalidOptionsException("Error: Required argument --connect is missing.\nTry --help for usage instructions.");
        }
    }

    protected void validateCodeGenOptions(SqoopOptions options) throws SqoopOptions.InvalidOptionsException {
        if (options.getClassName() != null && options.getPackageName() != null) {
            throw new SqoopOptions.InvalidOptionsException("--class-name overrides --package-name. You cannot use both.\nTry --help for usage instructions.");
        }
    }

    protected void validateOutputFormatOptions(SqoopOptions options) throws SqoopOptions.InvalidOptionsException {
        if (options.doHiveImport()) {
            if (!options.explicitOutputDelims()) {
                LOG.info((Object)"Using Hive-specific delimiters for output. You can override");
                LOG.info((Object)"delimiters with --fields-terminated-by, etc.");
                options.setOutputDelimiters(DelimiterSet.HIVE_DELIMITERS);
            }
            if (options.getOutputEscapedBy() != '\u0000') {
                LOG.warn((Object)"Hive does not support escape characters in fields;");
                LOG.warn((Object)"parse errors in Hive may result from using --escaped-by.");
            }
            if (options.getOutputEnclosedBy() != '\u0000') {
                LOG.warn((Object)"Hive does not support quoted strings; parse errors");
                LOG.warn((Object)"in Hive may result from using --enclosed-by.");
            }
        }
    }

    protected void validateHiveOptions(SqoopOptions options) throws SqoopOptions.InvalidOptionsException {
        if (options.getHiveDelimsReplacement() != null && options.doHiveDropDelims()) {
            throw new SqoopOptions.InvalidOptionsException("The hive-drop-import-delims option conflicts with the hive-delims-replacement option.\nTry --help for usage instructions.");
        }
        String hCatTable = options.getHCatTableName();
        if (hCatTable != null && options.doHiveImport()) {
            throw new SqoopOptions.InvalidOptionsException("The hcatalog-table option conflicts with the hive-import option.\nTry --help for usage instructions.");
        }
        if (options.doHiveImport() && options.getFileLayout() == SqoopOptions.FileLayout.AvroDataFile) {
            throw new SqoopOptions.InvalidOptionsException("Hive import is not compatible with importing into AVRO format.");
        }
        if (options.doHiveImport() && options.getFileLayout() == SqoopOptions.FileLayout.SequenceFile) {
            throw new SqoopOptions.InvalidOptionsException("Hive import is not compatible with importing into SequenceFile format.");
        }
        if (options.doHiveImport() && options.isAppendMode() && !options.getIncrementalMode().equals((Object)SqoopOptions.IncrementalMode.AppendRows)) {
            throw new SqoopOptions.InvalidOptionsException("Append mode for hive imports is not  yet supported. Please remove the parameter --append-mode");
        }
        String defaultHiveWarehouse = "/user/hive/warehouse";
        if (options.doHiveImport() && (options.getWarehouseDir() != null && options.getWarehouseDir().startsWith(defaultHiveWarehouse) || options.getTargetDir() != null && options.getTargetDir().startsWith(defaultHiveWarehouse))) {
            LOG.warn((Object)"It seems that you're doing hive import directly into default");
            LOG.warn((Object)"hive warehouse directory which is not supported. Sqoop is");
            LOG.warn((Object)"firstly importing data into separate directory and then");
            LOG.warn((Object)"inserting data into hive. Please consider removing");
            LOG.warn((Object)"--target-dir or --warehouse-dir into /user/hive/warehouse in");
            LOG.warn((Object)"case that you will detect any issues.");
        }
        if (!options.doHiveImport() && (options.getHiveHome() != null && !options.getHiveHome().equals(SqoopOptions.getHiveHomeDefault()) && hCatTable == null || options.doOverwriteHiveTable() || options.doFailIfHiveTableExists() || options.getHiveTableName() != null && !options.getHiveTableName().equals(options.getTableName()) || options.getHivePartitionKey() != null && hCatTable == null || options.getHivePartitionValue() != null && hCatTable == null || options.getMapColumnHive().size() > 0 && hCatTable == null)) {
            LOG.warn((Object)"It seems that you've specified at least one of following:");
            LOG.warn((Object)"\t--hive-home");
            LOG.warn((Object)"\t--hive-overwrite");
            LOG.warn((Object)"\t--create-hive-table");
            LOG.warn((Object)"\t--hive-table");
            LOG.warn((Object)"\t--hive-partition-key");
            LOG.warn((Object)"\t--hive-partition-value");
            LOG.warn((Object)"\t--map-column-hive");
            LOG.warn((Object)"Without specifying parameter --hive-import. Please note that");
            LOG.warn((Object)"those arguments will not be used in this session. Either");
            LOG.warn((Object)"specify --hive-import to apply them correctly or remove them");
            LOG.warn((Object)"from command line to remove this warning.");
            LOG.info((Object)"Please note that --hive-home, --hive-partition-key, ");
            LOG.info((Object)"\t hive-partition-value and --map-column-hive options are ");
            LOG.info((Object)"\t are also valid for HCatalog imports and exports");
        }
    }

    protected void validateAccumuloOptions(SqoopOptions options) throws SqoopOptions.InvalidOptionsException {
        if (options.getAccumuloColFamily() != null && options.getAccumuloTable() == null || options.getAccumuloColFamily() == null && options.getAccumuloTable() != null) {
            throw new SqoopOptions.InvalidOptionsException("Both --accumulo-table and --accumulo-column-family must be set.\nTry --help for usage instructions.");
        }
        if (options.getAccumuloTable() != null && options.getHBaseTable() != null) {
            throw new SqoopOptions.InvalidOptionsException("HBase import is incompatible with Accumulo import.");
        }
        if (options.getAccumuloTable() != null && options.getFileLayout() != SqoopOptions.FileLayout.TextFile) {
            throw new SqoopOptions.InvalidOptionsException("Accumulo import is not compatible with importing into file format.");
        }
        if (options.getAccumuloTable() != null && options.getHBaseColFamily() != null) {
            throw new SqoopOptions.InvalidOptionsException("Use --accumulo-column-family with Accumulo import.");
        }
        if (options.getAccumuloTable() != null && options.getAccumuloUser() == null) {
            throw new SqoopOptions.InvalidOptionsException("Must specify Accumulo user.");
        }
        if (options.getAccumuloTable() != null && options.getAccumuloInstance() == null) {
            throw new SqoopOptions.InvalidOptionsException("Must specify Accumulo instance.");
        }
        if (options.getAccumuloTable() != null && options.getAccumuloZookeepers() == null) {
            throw new SqoopOptions.InvalidOptionsException("Must specify Zookeeper server(s).");
        }
    }

    protected void validateHCatalogOptions(SqoopOptions options) throws SqoopOptions.InvalidOptionsException {
        String hCatTable = options.getHCatTableName();
        if (hCatTable == null) {
            if (options.getHCatHome() != null && !options.getHCatHome().equals(SqoopOptions.getHCatHomeDefault())) {
                LOG.warn((Object)"--hcatalog-home option will be ignored in non-HCatalog jobs");
            }
            if (options.getHCatDatabaseName() != null) {
                LOG.warn((Object)"--hcatalog-database option will be ignored  without --hcatalog-table");
            }
            if (options.getHCatStorageStanza() != null) {
                LOG.warn((Object)"--hcatalog-storage-stanza option will be ignored without --hatalog-table");
            }
            return;
        }
        if (options.explicitInputDelims()) {
            LOG.warn((Object)"Input field/record delimiter options are not used in HCatalog jobs unless the format is text.   It is better to use --hive-import in those cases.  For text formats");
        }
        if (options.explicitOutputDelims() || options.getHiveDelimsReplacement() != null || options.doHiveDropDelims()) {
            LOG.warn((Object)"Output field/record delimiter options are not useful in HCatalog jobs for most of the output types except text based  formats is text. It is better to use --hive-import in those cases.  For non text formats, ");
        }
        if (options.doHiveImport()) {
            throw new SqoopOptions.InvalidOptionsException("The hcatalog-table option conflicts with the hive-import option.\nTry --help for usage instructions.");
        }
        if (options.getTargetDir() != null) {
            throw new SqoopOptions.InvalidOptionsException("The target-dir option conflicts with the hcatalog-table option.\nTry --help for usage instructions.");
        }
        if (options.getWarehouseDir() != null) {
            throw new SqoopOptions.InvalidOptionsException("The warehouse-dir option conflicts with the hcatalog-table option.\nTry --help for usage instructions.");
        }
        if (options.isAppendMode()) {
            throw new SqoopOptions.InvalidOptionsException("Append mode for imports is not  compatible with HCatalog. Please remove the parameter--append-mode");
        }
        if (options.getExportDir() != null) {
            throw new SqoopOptions.InvalidOptionsException("The export-dir option conflicts with the hcatalog-table option.\nTry --help for usage instructions.");
        }
        if (options.getFileLayout() == SqoopOptions.FileLayout.AvroDataFile) {
            throw new SqoopOptions.InvalidOptionsException("HCatalog job is not compatible with  AVRO format option as-avrodatafile option.\nTry --help for usage instructions.");
        }
        if (options.getFileLayout() == SqoopOptions.FileLayout.SequenceFile) {
            throw new SqoopOptions.InvalidOptionsException("HCatalog job  is not compatible with SequenceFile format option as-sequencefile option.\nTry --help for usage instructions.");
        }
        if (options.getHCatalogPartitionKeys() != null && options.getHCatalogPartitionValues() == null) {
            throw new SqoopOptions.InvalidOptionsException("Either both --hcatalog-partition-keys and --hcatalog-partition-values should be provided or both of these options should be omitted.");
        }
        if (options.getHCatalogPartitionKeys() != null) {
            int i;
            String[] vals;
            String[] keys;
            if (options.getHivePartitionKey() != null) {
                LOG.warn((Object)"Both --hcatalog-partition-keys and --hive-partition-keyoptions are provided.  --hive-partition-key option will beignored");
            }
            if ((keys = options.getHCatalogPartitionKeys().split(",")).length != (vals = options.getHCatalogPartitionValues().split(",")).length) {
                throw new SqoopOptions.InvalidOptionsException("Number of static partition keys provided dpes match the number of partition values");
            }
            for (i = 0; i < keys.length; ++i) {
                String k = keys[i].trim();
                if (!k.isEmpty()) continue;
                throw new SqoopOptions.InvalidOptionsException("Invalid HCatalog static partition key at position " + i);
            }
            for (i = 0; i < vals.length; ++i) {
                String v = vals[i].trim();
                if (!v.isEmpty()) continue;
                throw new SqoopOptions.InvalidOptionsException("Invalid HCatalog static partition key at position " + v);
            }
        } else if (options.getHivePartitionKey() != null && options.getHivePartitionValue() == null) {
            throw new SqoopOptions.InvalidOptionsException("Either both --hive-partition-key and --hive-partition-value options should be provided or both of these options should be omitted");
        }
        if (options.doCreateHCatalogTable() && options.doDropAndCreateHCatalogTable()) {
            throw new SqoopOptions.InvalidOptionsException("Options --create-hcatalog-table and --drop-and-create-hcatalog-table are mutually exclusive. Use any one of them");
        }
    }

    protected void validateHBaseOptions(SqoopOptions options) throws SqoopOptions.InvalidOptionsException {
        if (options.getHBaseColFamily() != null && options.getHBaseTable() == null || options.getHBaseColFamily() == null && options.getHBaseTable() != null) {
            throw new SqoopOptions.InvalidOptionsException("Both --hbase-table and --column-family must be set together.\nTry --help for usage instructions.");
        }
        if (options.isBulkLoadEnabled() && options.getHBaseTable() == null) {
            String validationMessage = String.format("Can't run import with %s without %s", HBASE_BULK_LOAD_ENABLED_ARG, HBASE_TABLE_ARG);
            throw new SqoopOptions.InvalidOptionsException(validationMessage);
        }
    }

    protected int getDashPosition(String[] extra) {
        int dashPos = extra.length;
        for (int i = 0; i < extra.length; ++i) {
            if (!extra[i].equals("--")) continue;
            dashPos = i;
            break;
        }
        return dashPos;
    }
}

