/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom;

import java.lang.reflect.Array;
import java.util.Vector;
import org.eigenbase.xom.NodeDef;
import org.eigenbase.xom.XOMException;

public class DefWalker {
    private NodeDef[] defs;
    private int pos;

    public DefWalker(NodeDef[] defs) {
        this.defs = defs;
        this.pos = 0;
    }

    public NodeDef expect(Class elemType) throws XOMException {
        if (this.pos >= this.defs.length) {
            throw new XOMException("Expecting a Node of type " + elemType.getName() + " but no " + "Nodes remain.");
        }
        if (!elemType.isAssignableFrom(this.defs[this.pos].getClass())) {
            throw new XOMException("Expecting a Node of type " + elemType.getName() + " but " + "found a Node of type " + this.defs[this.pos].getClass().getName());
        }
        return this.defs[this.pos++];
    }

    public NodeDef[] expectArray(Class elemType) {
        Vector<NodeDef> found = new Vector<NodeDef>();
        while (this.pos < this.defs.length && elemType.isAssignableFrom(this.defs[this.pos].getClass())) {
            found.addElement(this.defs[this.pos++]);
        }
        NodeDef[] ret = new NodeDef[found.size()];
        for (int i = 0; i < found.size(); ++i) {
            ret[i] = (NodeDef)found.elementAt(i);
        }
        return ret;
    }

    public Object expectTypeArray(Class elemType) {
        Vector<NodeDef> found = new Vector<NodeDef>();
        while (this.pos < this.defs.length && elemType.isAssignableFrom(this.defs[this.pos].getClass())) {
            found.addElement(this.defs[this.pos++]);
        }
        Object ret = Array.newInstance(elemType, found.size());
        for (int i = 0; i < found.size(); ++i) {
            Array.set(ret, i, found.elementAt(i));
        }
        return ret;
    }
}

