/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom.wrappers;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.Location;
import org.eigenbase.xom.Locator;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.wrappers.Annotator;
import org.eigenbase.xom.wrappers.W3CDOMWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

abstract class GenericDOMParser
implements ErrorHandler,
Parser,
Locator {
    StringWriter errorBuffer = null;
    PrintWriter errorOut = null;
    protected Document document;
    static final String LOAD_EXTERNAL_DTD_FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    private boolean keepPositions;
    private Annotator annotator;

    GenericDOMParser() {
    }

    public DOMWrapper create(String tagName) {
        Element element = this.document.createElement(tagName);
        return new W3CDOMWrapper(element, this);
    }

    public DOMWrapper parse(InputStream is) throws XOMException {
        TeeInputStream tis = new TeeInputStream(is);
        InputSource source = new InputSource(tis);
        Document document = this.parseInputSource(source);
        W3CDOMWrapper wrapper = new W3CDOMWrapper(document.getDocumentElement(), this);
        if (this.keepPositions) {
            String xmlString = new String(tis.getBytes());
            this.annotator = new Annotator(xmlString, wrapper);
        }
        return wrapper;
    }

    public void setKeepPositions(boolean keepPositions) {
        this.keepPositions = keepPositions;
    }

    public boolean isKeepPositions() {
        return this.keepPositions;
    }

    public DOMWrapper parse(String xmlString) throws XOMException {
        DOMWrapper wrapper = this.parse(new StringReader(xmlString));
        if (this.keepPositions) {
            this.annotator = new Annotator(xmlString, wrapper);
        }
        return wrapper;
    }

    public DOMWrapper parse(Reader reader) throws XOMException {
        Document document = this.parseInputSource(new InputSource(reader));
        return new W3CDOMWrapper(document.getDocumentElement(), this);
    }

    protected abstract Document parseInputSource(InputSource var1) throws XOMException;

    public void warning(SAXParseException ex) {
        this.errorOut.println("[Warning] " + this.getLocationString(ex) + ": " + ex.getMessage());
    }

    public void error(SAXParseException ex) {
        this.errorOut.println("[Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        this.errorOut.println("[Fatal Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
        throw ex;
    }

    private String getLocationString(SAXParseException ex) {
        StringBuffer str = new StringBuffer();
        String systemId = ex.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            str.append(systemId);
        }
        str.append(':');
        str.append(ex.getLineNumber());
        str.append(':');
        str.append(ex.getColumnNumber());
        return str.toString();
    }

    public DOMWrapper parse(URL url) throws XOMException {
        try {
            return this.parse(new BufferedInputStream(url.openStream()));
        }
        catch (IOException ex) {
            throw new XOMException(ex, "Document parse failed");
        }
    }

    protected void prepareParse() {
        this.errorBuffer = new StringWriter();
        this.errorOut = new PrintWriter(this.errorBuffer);
    }

    protected void handleErrors() throws XOMException {
        this.errorOut.flush();
        String errorStr = this.errorBuffer.toString();
        if (errorStr.length() > 0) {
            throw new XOMException("Document parse failed: " + errorStr);
        }
    }

    public Location getLocation(DOMWrapper wrapper) {
        return this.annotator.getLocation(wrapper);
    }

    private static class TeeInputStream
    extends FilterInputStream {
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        TeeInputStream(InputStream in) {
            super(in);
        }

        public int read() throws IOException {
            int x = super.read();
            this.baos.write(x);
            return x;
        }

        public byte[] getBytes() {
            return this.baos.toByteArray();
        }
    }
}

