/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.ColumnResult;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SqlResultSetMapping;
import org.apache.hadoop.io.Writable;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.rest.JsonCoordinatorAction;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.WritableUtils;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.jdbc.Index;

@SqlResultSetMapping(name="CoordActionJobIdLmt", columns={@ColumnResult(name="job_id"), @ColumnResult(name="min_lmt")})
@Entity
@NamedQueries(value={@NamedQuery(name="UPDATE_COORD_ACTION", query="update CoordinatorActionBean w set w.actionNumber = :actionNumber, w.actionXml = :actionXml, w.consoleUrl = :consoleUrl, w.createdConf = :createdConf, w.errorCode = :errorCode, w.errorMessage = :errorMessage, w.externalStatus = :externalStatus, w.missingDependencies = :missingDependencies, w.runConf = :runConf, w.timeOut = :timeOut, w.trackerUri = :trackerUri, w.type = :type, w.createdTimestamp = :createdTime, w.externalId = :externalId, w.jobId = :jobId, w.lastModifiedTimestamp = :lastModifiedTime, w.nominalTimestamp = :nominalTime, w.slaXml = :slaXml, w.status = :status where w.id = :id"), @NamedQuery(name="UPDATE_COORD_ACTION_MIN", query="update CoordinatorActionBean w set w.actionXml = :actionXml, w.missingDependencies = :missingDependencies, w.lastModifiedTimestamp = :lastModifiedTime, w.status = :status where w.id = :id"), @NamedQuery(name="DELETE_COMPLETED_ACTIONS_FOR_COORDINATOR", query="delete from CoordinatorActionBean a where a.jobId = :jobId and (a.status = 'SUCCEEDED' OR a.status = 'FAILED' OR a.status= 'KILLED')"), @NamedQuery(name="GET_COORD_ACTIONS", query="select OBJECT(w) from CoordinatorActionBean w"), @NamedQuery(name="GET_COMPLETED_ACTIONS_OLDER_THAN", query="select OBJECT(a) from CoordinatorActionBean a where a.createdTimestamp < :createdTime and (a.status = 'SUCCEEDED' OR a.status = 'FAILED' OR a.status = 'KILLED')"), @NamedQuery(name="GET_COORD_ACTION", query="select OBJECT(a) from CoordinatorActionBean a where a.id = :id"), @NamedQuery(name="GET_COORD_ACTION_FOR_EXTERNALID", query="select OBJECT(a) from CoordinatorActionBean a where a.externalId = :externalId"), @NamedQuery(name="GET_COORD_ACTIONS_FOR_JOB_FIFO", query="select OBJECT(a) from CoordinatorActionBean a where a.jobId = :jobId AND a.status = 'READY' order by a.nominalTimestamp"), @NamedQuery(name="GET_COORD_ACTIONS_FOR_JOB_LIFO", query="select OBJECT(a) from CoordinatorActionBean a where a.jobId = :jobId AND a.status = 'READY' order by a.nominalTimestamp desc"), @NamedQuery(name="GET_COORD_RUNNING_ACTIONS_COUNT", query="select count(a) from CoordinatorActionBean a where a.jobId = :jobId AND (a.status = 'RUNNING' OR a.status='SUBMITTED')"), @NamedQuery(name="GET_COORD_ACTIONS_COUNT_BY_JOBID", query="select count(a) from CoordinatorActionBean a where a.jobId = :jobId"), @NamedQuery(name="GET_COORD_ACTIVE_ACTIONS_COUNT_BY_JOBID", query="select count(a) from CoordinatorActionBean a where a.jobId = :jobId AND a.status = 'WAITING'"), @NamedQuery(name="GET_COORD_ACTIONS_PENDING_FALSE_COUNT", query="select count(a) from CoordinatorActionBean a where a.jobId = :jobId AND a.pending = 0 AND (a.status = 'SUSPENDED' OR a.status = 'TIMEDOUT' OR a.status = 'SUCCEEDED' OR a.status = 'KILLED' OR a.status = 'FAILED')"), @NamedQuery(name="GET_COORD_ACTIONS_PENDING_FALSE_STATUS_COUNT", query="select count(a) from CoordinatorActionBean a where a.jobId = :jobId AND a.pending = 0 AND a.status = :status"), @NamedQuery(name="GET_ACTIONS_FOR_COORD_JOB", query="select OBJECT(a) from CoordinatorActionBean a where a.jobId = :jobId"), @NamedQuery(name="GET_COORD_ACTION_FOR_COORD_JOB_BY_ACTION_NUMBER", query="select OBJECT(a) from CoordinatorActionBean a where a.jobId = :jobId AND a.actionNumber = :actionNumber"), @NamedQuery(name="GET_COORD_ACTIONS_BY_LAST_MODIFIED_TIME", query="select OBJECT(w) from CoordinatorActionBean w where w.lastModifiedTimestamp >= :lastModifiedTime"), @NamedQuery(name="GET_RUNNING_ACTIONS_FOR_COORD_JOB", query="select OBJECT(a) from CoordinatorActionBean a where a.jobId = :jobId AND a.status = 'RUNNING'"), @NamedQuery(name="GET_RUNNING_ACTIONS_OLDER_THAN", query="select OBJECT(a) from CoordinatorActionBean a where a.status = 'RUNNING' AND a.lastModifiedTimestamp <= :lastModifiedTime"), @NamedQuery(name="GET_COORD_ACTIONS_WAITING_SUBMITTED_OLDER_THAN", query="select OBJECT(a) from CoordinatorActionBean a where (a.status = 'WAITING' OR a.status = 'SUBMITTED') AND a.lastModifiedTimestamp <= :lastModifiedTime"), @NamedQuery(name="GET_COORD_ACTIONS_FOR_RECOVERY_OLDER_THAN", query="select OBJECT(a) from CoordinatorActionBean a where a.pending > 0 AND (a.status = 'SUSPENDED' OR a.status = 'KILLED' OR a.status = 'RUNNING') AND a.lastModifiedTimestamp <= :lastModifiedTime"), @NamedQuery(name="GET_ACTIONS_FOR_DATES", query="select OBJECT(a) from CoordinatorActionBean a where a.jobId = :jobId AND (a.status = 'TIMEDOUT' OR a.status = 'SUCCEEDED' OR a.status = 'KILLED' OR a.status = 'FAILED') AND a.nominalTimestamp >= :startTime AND a.nominalTimestamp <= :endTime"), @NamedQuery(name="GET_ACTION_FOR_NOMINALTIME", query="select OBJECT(a) from CoordinatorActionBean a where a.jobId = :jobId AND a.nominalTimestamp = :nominalTime"), @NamedQuery(name="GET_COORD_ACTIONS_COUNT", query="select count(w) from CoordinatorActionBean w")})
@NamedNativeQueries(value={@NamedNativeQuery(name="GET_READY_ACTIONS_GROUP_BY_JOBID", query="select a.job_id as job_id, MIN(a.last_modified_time) as min_lmt from COORD_ACTIONS a where a.status = 'READY' GROUP BY a.job_id HAVING MIN(a.last_modified_time) < ?", resultSetMapping="CoordActionJobIdLmt")})
public class CoordinatorActionBean
extends JsonCoordinatorAction
implements Writable,
PersistenceCapable {
    @Basic
    @Index
    @Column(name="job_id")
    private String jobId;
    @Basic
    @Index
    @Column(name="status")
    private String status = null;
    @Basic
    @Column(name="nominal_time")
    private Timestamp nominalTimestamp = null;
    @Basic
    @Index
    @Column(name="last_modified_time")
    private Timestamp lastModifiedTimestamp = null;
    @Basic
    @Index
    @Column(name="created_time")
    private Timestamp createdTimestamp = null;
    @Basic
    @Index
    @Column(name="rerun_time")
    private Timestamp rerunTimestamp = null;
    @Basic
    @Index
    @Column(name="external_id")
    private String externalId;
    @Column(name="sla_xml")
    @Lob
    private String slaXml = null;
    @Basic
    @Column(name="pending")
    private int pending = 0;
    private static int pcInheritedFieldCount = JsonCoordinatorAction.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$oozie$client$rest$JsonCoordinatorAction;
    static /* synthetic */ Class class$Ljava$sql$Timestamp;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$oozie$CoordinatorActionBean;

    public void write(DataOutput dataOutput) throws IOException {
        WritableUtils.writeStr(dataOutput, this.getJobId());
        WritableUtils.writeStr(dataOutput, this.getType());
        WritableUtils.writeStr(dataOutput, this.getId());
        WritableUtils.writeStr(dataOutput, this.getCreatedConf());
        WritableUtils.writeStr(dataOutput, this.getStatus().toString());
        dataOutput.writeInt(this.getActionNumber());
        WritableUtils.writeStr(dataOutput, this.getRunConf());
        WritableUtils.writeStr(dataOutput, this.getExternalStatus());
        WritableUtils.writeStr(dataOutput, this.getTrackerUri());
        WritableUtils.writeStr(dataOutput, this.getConsoleUrl());
        WritableUtils.writeStr(dataOutput, this.getErrorCode());
        WritableUtils.writeStr(dataOutput, this.getErrorMessage());
        dataOutput.writeLong(this.getCreatedTime() != null ? this.getCreatedTime().getTime() : -1L);
        dataOutput.writeLong(this.getLastModifiedTime() != null ? this.getLastModifiedTime().getTime() : -1L);
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.setJobId(WritableUtils.readStr(dataInput));
        this.setType(WritableUtils.readStr(dataInput));
        this.setId(WritableUtils.readStr(dataInput));
        this.setCreatedConf(WritableUtils.readStr(dataInput));
        this.setStatus(CoordinatorAction.Status.valueOf((String)WritableUtils.readStr(dataInput)));
        this.setActionNumber(dataInput.readInt());
        this.setRunConf(WritableUtils.readStr(dataInput));
        this.setExternalStatus(WritableUtils.readStr(dataInput));
        this.setTrackerUri(WritableUtils.readStr(dataInput));
        this.setConsoleUrl(WritableUtils.readStr(dataInput));
        this.setErrorCode(WritableUtils.readStr(dataInput));
        this.setErrorMessage(WritableUtils.readStr(dataInput));
        long d = dataInput.readLong();
        if (d != -1L) {
            this.setCreatedTime(new Date(d));
        }
        if ((d = dataInput.readLong()) != -1L) {
            this.setLastModifiedTime(new Date(d));
        }
    }

    @Override
    public String getJobId() {
        return CoordinatorActionBean.pcGetjobId(this);
    }

    @Override
    public void setJobId(String id) {
        super.setJobId(id);
        CoordinatorActionBean.pcSetjobId(this, id);
    }

    @Override
    public CoordinatorAction.Status getStatus() {
        return CoordinatorAction.Status.valueOf((String)CoordinatorActionBean.pcGetstatus(this));
    }

    @Override
    public void setStatus(CoordinatorAction.Status status) {
        super.setStatus(status);
        CoordinatorActionBean.pcSetstatus(this, status.toString());
    }

    @Override
    public void setCreatedTime(Date createdTime) {
        CoordinatorActionBean.pcSetcreatedTimestamp(this, DateUtils.convertDateToTimestamp(createdTime));
        super.setCreatedTime(createdTime);
    }

    public void setRerunTime(Date rerunTime) {
        CoordinatorActionBean.pcSetrerunTimestamp(this, DateUtils.convertDateToTimestamp(rerunTime));
    }

    @Override
    public void setNominalTime(Date nominalTime) {
        CoordinatorActionBean.pcSetnominalTimestamp(this, DateUtils.convertDateToTimestamp(nominalTime));
        super.setNominalTime(nominalTime);
    }

    @Override
    public void setLastModifiedTime(Date lastModifiedTime) {
        CoordinatorActionBean.pcSetlastModifiedTimestamp(this, DateUtils.convertDateToTimestamp(lastModifiedTime));
        super.setLastModifiedTime(lastModifiedTime);
    }

    @Override
    public Date getCreatedTime() {
        return DateUtils.toDate(CoordinatorActionBean.pcGetcreatedTimestamp(this));
    }

    public Timestamp getCreatedTimestamp() {
        return CoordinatorActionBean.pcGetcreatedTimestamp(this);
    }

    public Date getRerunTime() {
        return DateUtils.toDate(CoordinatorActionBean.pcGetrerunTimestamp(this));
    }

    public Timestamp getRerunTimestamp() {
        return CoordinatorActionBean.pcGetrerunTimestamp(this);
    }

    @Override
    public Date getLastModifiedTime() {
        return DateUtils.toDate(CoordinatorActionBean.pcGetlastModifiedTimestamp(this));
    }

    public Timestamp getLastModifiedTimestamp() {
        return CoordinatorActionBean.pcGetlastModifiedTimestamp(this);
    }

    @Override
    public Date getNominalTime() {
        return DateUtils.toDate(CoordinatorActionBean.pcGetnominalTimestamp(this));
    }

    public Timestamp getNominalTimestamp() {
        return CoordinatorActionBean.pcGetnominalTimestamp(this);
    }

    @Override
    public String getExternalId() {
        return CoordinatorActionBean.pcGetexternalId(this);
    }

    @Override
    public void setExternalId(String externalId) {
        super.setExternalId(externalId);
        CoordinatorActionBean.pcSetexternalId(this, externalId);
    }

    public String getSlaXml() {
        return CoordinatorActionBean.pcGetslaXml(this);
    }

    public void setSlaXml(String slaXml) {
        CoordinatorActionBean.pcSetslaXml(this, slaXml);
    }

    public boolean isTerminalStatus() {
        boolean isTerminal = true;
        switch (this.getStatus()) {
            case WAITING: 
            case READY: 
            case SUBMITTED: 
            case RUNNING: 
            case SUSPENDED: {
                isTerminal = false;
                break;
            }
            default: {
                isTerminal = true;
            }
        }
        return isTerminal;
    }

    public void setPending(int pending) {
        CoordinatorActionBean.pcSetpending(this, pending);
    }

    public int incrementAndGetPending() {
        CoordinatorActionBean coordinatorActionBean = this;
        CoordinatorActionBean.pcSetpending(coordinatorActionBean, CoordinatorActionBean.pcGetpending(coordinatorActionBean) + 1);
        return CoordinatorActionBean.pcGetpending(this);
    }

    public int decrementAndGetPending() {
        CoordinatorActionBean.pcSetpending(this, Math.max(CoordinatorActionBean.pcGetpending(this) - 1, 0));
        return CoordinatorActionBean.pcGetpending(this);
    }

    public int getPending() {
        return CoordinatorActionBean.pcGetpending(this);
    }

    public boolean isPending() {
        return CoordinatorActionBean.pcGetpending(this) > 0;
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 1055128;
    }

    static {
        Class clazz = class$Lorg$apache$oozie$client$rest$JsonCoordinatorAction != null ? class$Lorg$apache$oozie$client$rest$JsonCoordinatorAction : (class$Lorg$apache$oozie$client$rest$JsonCoordinatorAction = CoordinatorActionBean.class$("org.apache.oozie.client.rest.JsonCoordinatorAction"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"createdTimestamp", "externalId", "jobId", "lastModifiedTimestamp", "nominalTimestamp", "pending", "rerunTimestamp", "slaXml", "status"};
        Class[] classArray = new Class[9];
        Class clazz2 = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = CoordinatorActionBean.class$("java.sql.Timestamp"));
        classArray[0] = clazz2;
        Class clazz3 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorActionBean.class$("java.lang.String"));
        classArray[1] = clazz3;
        classArray[2] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorActionBean.class$("java.lang.String"));
        classArray[3] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = CoordinatorActionBean.class$("java.sql.Timestamp"));
        classArray[4] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = CoordinatorActionBean.class$("java.sql.Timestamp"));
        classArray[5] = Integer.TYPE;
        classArray[6] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = CoordinatorActionBean.class$("java.sql.Timestamp"));
        classArray[7] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorActionBean.class$("java.lang.String"));
        classArray[8] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorActionBean.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz4 = class$Lorg$apache$oozie$CoordinatorActionBean != null ? class$Lorg$apache$oozie$CoordinatorActionBean : (class$Lorg$apache$oozie$CoordinatorActionBean = CoordinatorActionBean.class$("org.apache.oozie.CoordinatorActionBean"));
        PCRegistry.register((Class)clazz4, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"CoordinatorActionBean", (PersistenceCapable)new CoordinatorActionBean());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.createdTimestamp = null;
        this.externalId = null;
        this.jobId = null;
        this.lastModifiedTimestamp = null;
        this.nominalTimestamp = null;
        this.pending = 0;
        this.rerunTimestamp = null;
        this.slaXml = null;
        this.status = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        CoordinatorActionBean coordinatorActionBean = new CoordinatorActionBean();
        if (bl) {
            coordinatorActionBean.pcClearFields();
        }
        coordinatorActionBean.pcStateManager = stateManager;
        coordinatorActionBean.pcCopyKeyFieldsFromObjectId(object);
        return coordinatorActionBean;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        CoordinatorActionBean coordinatorActionBean = new CoordinatorActionBean();
        if (bl) {
            coordinatorActionBean.pcClearFields();
        }
        coordinatorActionBean.pcStateManager = stateManager;
        return coordinatorActionBean;
    }

    protected static int pcGetManagedFieldCount() {
        return 9 + JsonCoordinatorAction.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.createdTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.externalId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.jobId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.lastModifiedTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.nominalTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.pending = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.rerunTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.slaXml = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.status = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.createdTimestamp);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.externalId);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.jobId);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.lastModifiedTimestamp);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.nominalTimestamp);
                return;
            }
            case 5: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.pending);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.rerunTimestamp);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.slaXml);
                return;
            }
            case 8: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.status);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(CoordinatorActionBean coordinatorActionBean, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(coordinatorActionBean, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.createdTimestamp = coordinatorActionBean.createdTimestamp;
                return;
            }
            case 1: {
                this.externalId = coordinatorActionBean.externalId;
                return;
            }
            case 2: {
                this.jobId = coordinatorActionBean.jobId;
                return;
            }
            case 3: {
                this.lastModifiedTimestamp = coordinatorActionBean.lastModifiedTimestamp;
                return;
            }
            case 4: {
                this.nominalTimestamp = coordinatorActionBean.nominalTimestamp;
                return;
            }
            case 5: {
                this.pending = coordinatorActionBean.pending;
                return;
            }
            case 6: {
                this.rerunTimestamp = coordinatorActionBean.rerunTimestamp;
                return;
            }
            case 7: {
                this.slaXml = coordinatorActionBean.slaXml;
                return;
            }
            case 8: {
                this.status = coordinatorActionBean.status;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        CoordinatorActionBean coordinatorActionBean = (CoordinatorActionBean)object;
        if (coordinatorActionBean.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(coordinatorActionBean, nArray[n]);
            ++n;
        }
    }

    private static final Timestamp pcGetcreatedTimestamp(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.createdTimestamp;
        }
        int n = pcInheritedFieldCount + 0;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.createdTimestamp;
    }

    private static final void pcSetcreatedTimestamp(CoordinatorActionBean coordinatorActionBean, Timestamp timestamp) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.createdTimestamp = timestamp;
            return;
        }
        coordinatorActionBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 0, (Object)coordinatorActionBean.createdTimestamp, (Object)timestamp, 0);
    }

    private static final String pcGetexternalId(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.externalId;
        }
        int n = pcInheritedFieldCount + 1;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.externalId;
    }

    private static final void pcSetexternalId(CoordinatorActionBean coordinatorActionBean, String string) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.externalId = string;
            return;
        }
        coordinatorActionBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 1, coordinatorActionBean.externalId, string, 0);
    }

    private static final String pcGetjobId(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.jobId;
        }
        int n = pcInheritedFieldCount + 2;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.jobId;
    }

    private static final void pcSetjobId(CoordinatorActionBean coordinatorActionBean, String string) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.jobId = string;
            return;
        }
        coordinatorActionBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 2, coordinatorActionBean.jobId, string, 0);
    }

    private static final Timestamp pcGetlastModifiedTimestamp(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.lastModifiedTimestamp;
        }
        int n = pcInheritedFieldCount + 3;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.lastModifiedTimestamp;
    }

    private static final void pcSetlastModifiedTimestamp(CoordinatorActionBean coordinatorActionBean, Timestamp timestamp) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.lastModifiedTimestamp = timestamp;
            return;
        }
        coordinatorActionBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 3, (Object)coordinatorActionBean.lastModifiedTimestamp, (Object)timestamp, 0);
    }

    private static final Timestamp pcGetnominalTimestamp(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.nominalTimestamp;
        }
        int n = pcInheritedFieldCount + 4;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.nominalTimestamp;
    }

    private static final void pcSetnominalTimestamp(CoordinatorActionBean coordinatorActionBean, Timestamp timestamp) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.nominalTimestamp = timestamp;
            return;
        }
        coordinatorActionBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 4, (Object)coordinatorActionBean.nominalTimestamp, (Object)timestamp, 0);
    }

    private static final int pcGetpending(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.pending;
        }
        int n = pcInheritedFieldCount + 5;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.pending;
    }

    private static final void pcSetpending(CoordinatorActionBean coordinatorActionBean, int n) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.pending = n;
            return;
        }
        coordinatorActionBean.pcStateManager.settingIntField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 5, coordinatorActionBean.pending, n, 0);
    }

    private static final Timestamp pcGetrerunTimestamp(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.rerunTimestamp;
        }
        int n = pcInheritedFieldCount + 6;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.rerunTimestamp;
    }

    private static final void pcSetrerunTimestamp(CoordinatorActionBean coordinatorActionBean, Timestamp timestamp) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.rerunTimestamp = timestamp;
            return;
        }
        coordinatorActionBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 6, (Object)coordinatorActionBean.rerunTimestamp, (Object)timestamp, 0);
    }

    private static final String pcGetslaXml(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.slaXml;
        }
        int n = pcInheritedFieldCount + 7;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.slaXml;
    }

    private static final void pcSetslaXml(CoordinatorActionBean coordinatorActionBean, String string) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.slaXml = string;
            return;
        }
        coordinatorActionBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 7, coordinatorActionBean.slaXml, string, 0);
    }

    private static final String pcGetstatus(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.status;
        }
        int n = pcInheritedFieldCount + 8;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.status;
    }

    private static final void pcSetstatus(CoordinatorActionBean coordinatorActionBean, String string) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.status = string;
            return;
        }
        coordinatorActionBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 8, coordinatorActionBean.status, string, 0);
    }
}

