/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import org.apache.hadoop.io.Writable;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.rest.JsonCoordinatorJob;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.WritableUtils;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.jdbc.Index;

@Entity
@NamedQueries(value={@NamedQuery(name="UPDATE_COORD_JOB", query="update CoordinatorJobBean w set w.appName = :appName, w.appPath = :appPath, w.concurrency = :concurrency, w.conf = :conf, w.externalId = :externalId, w.frequency = :frequency, w.lastActionNumber = :lastActionNumber, w.timeOut = :timeOut, w.timeZone = :timeZone, w.authToken = :authToken, w.createdTimestamp = :createdTime, w.endTimestamp = :endTime, w.execution = :execution, w.jobXml = :jobXml, w.lastActionTimestamp = :lastAction, w.lastModifiedTimestamp = :lastModifiedTime, w.nextMaterializedTimestamp = :nextMaterializedTime, w.origJobXml = :origJobXml, w.slaXml=:slaXml, w.startTimestamp = :startTime, w.status = :status, w.timeUnitStr = :timeUnit where w.id = :id"), @NamedQuery(name="UPDATE_COORD_JOB_STATUS", query="update CoordinatorJobBean w set w.status = :status, w.lastModifiedTimestamp = :lastModifiedTime where w.id = :id"), @NamedQuery(name="DELETE_COORD_JOB", query="delete from CoordinatorJobBean w where w.id = :id"), @NamedQuery(name="GET_COORD_JOBS", query="select OBJECT(w) from CoordinatorJobBean w"), @NamedQuery(name="GET_COORD_JOB", query="select OBJECT(w) from CoordinatorJobBean w where w.id = :id"), @NamedQuery(name="GET_COORD_JOBS_PENDING", query="select OBJECT(w) from CoordinatorJobBean w where w.pending = 1 order by w.lastModifiedTimestamp"), @NamedQuery(name="GET_COORD_JOBS_COUNT", query="select count(w) from CoordinatorJobBean w"), @NamedQuery(name="GET_COORD_JOBS_COLUMNS", query="select w.id, w.appName, w.status, w.user, w.group, w.startTimestamp, w.endTimestamp, w.appPath, w.concurrency, w.frequency, w.lastActionTimestamp, w.nextMaterializedTimestamp, w.createdTimestamp, w.timeUnitStr, w.timeZone, w.timeOut from CoordinatorJobBean w order by w.createdTimestamp desc"), @NamedQuery(name="GET_COORD_JOBS_OLDER_THAN", query="select OBJECT(w) from CoordinatorJobBean w where w.startTimestamp <= :matTime AND (w.status = 'PREP' OR w.status = 'RUNNING') AND (w.nextMaterializedTimestamp < :matTime OR w.nextMaterializedTimestamp IS NULL) AND (w.nextMaterializedTimestamp IS NULL OR (w.endTimestamp > w.nextMaterializedTimestamp AND (w.pauseTimestamp IS NULL OR w.pauseTimestamp > w.nextMaterializedTimestamp))) order by w.lastModifiedTimestamp"), @NamedQuery(name="GET_COORD_JOBS_OLDER_THAN_STATUS", query="select OBJECT(w) from CoordinatorJobBean w where w.status = :status AND w.lastModifiedTimestamp <= :lastModTime order by w.lastModifiedTimestamp"), @NamedQuery(name="GET_COMPLETED_COORD_JOBS_OLDER_THAN_STATUS", query="select OBJECT(w) from CoordinatorJobBean w where ( w.status = 'SUCCEEDED' OR w.status = 'FAILED' or w.status = 'KILLED') AND w.lastModifiedTimestamp <= :lastModTime order by w.lastModifiedTimestamp"), @NamedQuery(name="GET_COORD_JOBS_UNPAUSED", query="select OBJECT(w) from CoordinatorJobBean w where w.status = 'RUNNING' OR w.status = 'RUNNINGWITHERROR' OR w.status = 'PREP' order by w.lastModifiedTimestamp"), @NamedQuery(name="GET_COORD_JOBS_PAUSED", query="select OBJECT(w) from CoordinatorJobBean w where w.status = 'PAUSED' OR w.status = 'PAUSEDWITHERROR' OR w.status = 'PREPPAUSED' order by w.lastModifiedTimestamp"), @NamedQuery(name="GET_COORD_JOBS_FOR_BUNDLE", query="select OBJECT(w) from CoordinatorJobBean w where w.bundleId = :bundleId order by w.lastModifiedTimestamp")})
public class CoordinatorJobBean
extends JsonCoordinatorJob
implements Writable,
PersistenceCapable {
    @Basic
    @Index
    @Column(name="status")
    private String status = Job.Status.PREP.toString();
    @Basic
    @Column(name="auth_token")
    @Lob
    private String authToken = null;
    @Basic
    @Column(name="start_time")
    private Timestamp startTimestamp = null;
    @Basic
    @Column(name="end_time")
    private Timestamp endTimestamp = null;
    @Basic
    @Column(name="pause_time")
    private Timestamp pauseTimestamp = null;
    @Basic
    @Index
    @Column(name="created_time")
    private Timestamp createdTimestamp = null;
    @Basic
    @Column(name="time_unit")
    private String timeUnitStr = CoordinatorJob.Timeunit.NONE.toString();
    @Basic
    @Column(name="execution")
    private String execution = CoordinatorJob.Execution.FIFO.toString();
    @Basic
    @Column(name="last_action")
    private Timestamp lastActionTimestamp = null;
    @Basic
    @Index
    @Column(name="next_matd_time")
    private Timestamp nextMaterializedTimestamp = null;
    @Basic
    @Index
    @Column(name="last_modified_time")
    private Timestamp lastModifiedTimestamp = null;
    @Basic
    @Index
    @Column(name="suspended_time")
    private Timestamp suspendedTimestamp = null;
    @Column(name="job_xml")
    @Lob
    private String jobXml = null;
    @Column(name="orig_job_xml")
    @Lob
    private String origJobXml = null;
    @Column(name="sla_xml")
    @Lob
    private String slaXml = null;
    @Basic
    @Column(name="pending")
    private int pending = 0;
    @Basic
    @Column(name="done_materialization")
    private int doneMaterialization = 0;
    @Basic
    @Column(name="app_namespace")
    private String appNamespace = null;
    private static int pcInheritedFieldCount = JsonCoordinatorJob.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$oozie$client$rest$JsonCoordinatorJob;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$sql$Timestamp;
    static /* synthetic */ Class class$Lorg$apache$oozie$CoordinatorJobBean;

    public Timestamp getStartTimestamp() {
        return CoordinatorJobBean.pcGetstartTimestamp(this);
    }

    public void setStartTimestamp(Timestamp startTimestamp) {
        super.setStartTime(DateUtils.toDate(startTimestamp));
        CoordinatorJobBean.pcSetstartTimestamp(this, startTimestamp);
    }

    public Timestamp getEndTimestamp() {
        return CoordinatorJobBean.pcGetendTimestamp(this);
    }

    public void setEndTimestamp(Timestamp endTimestamp) {
        super.setEndTime(DateUtils.toDate(endTimestamp));
        CoordinatorJobBean.pcSetendTimestamp(this, endTimestamp);
    }

    public Timestamp getNextMaterializedTimestamp() {
        return CoordinatorJobBean.pcGetnextMaterializedTimestamp(this);
    }

    public void setNextMaterializedTimestamp(Timestamp nextMaterializedTimestamp) {
        super.setNextMaterializedTime(DateUtils.toDate(nextMaterializedTimestamp));
        CoordinatorJobBean.pcSetnextMaterializedTimestamp(this, nextMaterializedTimestamp);
    }

    public Timestamp getLastModifiedTimestamp() {
        return CoordinatorJobBean.pcGetlastModifiedTimestamp(this);
    }

    public void setLastModifiedTimestamp(Timestamp lastModifiedTimestamp) {
        CoordinatorJobBean.pcSetlastModifiedTimestamp(this, lastModifiedTimestamp);
    }

    public Timestamp getSuspendedTimestamp() {
        return CoordinatorJobBean.pcGetsuspendedTimestamp(this);
    }

    public void setSuspendedTimestamp(Timestamp suspendedTimestamp) {
        CoordinatorJobBean.pcSetsuspendedTimestamp(this, suspendedTimestamp);
    }

    public String getJobXml() {
        return CoordinatorJobBean.pcGetjobXml(this);
    }

    public void setJobXml(String jobXml) {
        CoordinatorJobBean.pcSetjobXml(this, jobXml);
    }

    public String getOrigJobXml() {
        return CoordinatorJobBean.pcGetorigJobXml(this);
    }

    public void setOrigJobXml(String origJobXml) {
        CoordinatorJobBean.pcSetorigJobXml(this, origJobXml);
    }

    public String getSlaXml() {
        return CoordinatorJobBean.pcGetslaXml(this);
    }

    public void setSlaXml(String slaXml) {
        CoordinatorJobBean.pcSetslaXml(this, slaXml);
    }

    @Override
    public void setTimeUnit(CoordinatorJob.Timeunit timeUnit) {
        super.setTimeUnit(timeUnit);
        CoordinatorJobBean.pcSettimeUnitStr(this, timeUnit.toString());
    }

    public void setLastActionTimestamp(Timestamp lastActionTimestamp) {
        super.setLastActionTime(DateUtils.toDate(lastActionTimestamp));
        CoordinatorJobBean.pcSetlastActionTimestamp(this, lastActionTimestamp);
    }

    public void setAuthToken(String authToken) {
        CoordinatorJobBean.pcSetauthToken(this, authToken);
    }

    @Override
    public void setPending() {
        super.setPending();
        CoordinatorJobBean.pcSetpending(this, 1);
    }

    @Override
    public void resetPending() {
        super.resetPending();
        CoordinatorJobBean.pcSetpending(this, 0);
    }

    public boolean isPending() {
        return CoordinatorJobBean.pcGetpending(this) == 1;
    }

    public void setDoneMaterialization() {
        CoordinatorJobBean.pcSetdoneMaterialization(this, 1);
    }

    public void resetDoneMaterialization() {
        CoordinatorJobBean.pcSetdoneMaterialization(this, 0);
    }

    public boolean isDoneMaterialization() {
        return CoordinatorJobBean.pcGetdoneMaterialization(this) == 1;
    }

    public String getAppNamespace() {
        return CoordinatorJobBean.pcGetappNamespace(this);
    }

    public void setAppNamespace(String appNamespace) {
        CoordinatorJobBean.pcSetappNamespace(this, appNamespace);
    }

    public void write(DataOutput dataOutput) throws IOException {
        WritableUtils.writeStr(dataOutput, this.getAppPath());
        WritableUtils.writeStr(dataOutput, this.getAppName());
        WritableUtils.writeStr(dataOutput, this.getId());
        WritableUtils.writeStr(dataOutput, this.getConf());
        WritableUtils.writeStr(dataOutput, this.getStatusStr());
        dataOutput.writeInt(this.getFrequency());
        WritableUtils.writeStr(dataOutput, this.getTimeUnit().toString());
        WritableUtils.writeStr(dataOutput, this.getTimeZone());
        dataOutput.writeInt(this.getConcurrency());
        WritableUtils.writeStr(dataOutput, this.getExecutionOrder().toString());
        dataOutput.writeLong(this.getLastActionTime() != null ? this.getLastActionTime().getTime() : -1L);
        dataOutput.writeLong(this.getNextMaterializedTime() != null ? this.getNextMaterializedTime().getTime() : -1L);
        dataOutput.writeLong(this.getStartTime() != null ? this.getStartTime().getTime() : -1L);
        dataOutput.writeLong(this.getEndTime() != null ? this.getEndTime().getTime() : -1L);
        WritableUtils.writeStr(dataOutput, this.getUser());
        WritableUtils.writeStr(dataOutput, this.getGroup());
        WritableUtils.writeStr(dataOutput, this.getExternalId());
        dataOutput.writeInt(this.getTimeout());
        dataOutput.writeInt(this.getMatThrottling());
        if (this.isPending()) {
            dataOutput.writeInt(1);
        } else {
            dataOutput.writeInt(0);
        }
        if (this.isDoneMaterialization()) {
            dataOutput.writeInt(1);
        } else {
            dataOutput.writeInt(0);
        }
        WritableUtils.writeStr(dataOutput, this.getAppNamespace());
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.setAppPath(WritableUtils.readStr(dataInput));
        this.setAppName(WritableUtils.readStr(dataInput));
        this.setId(WritableUtils.readStr(dataInput));
        this.setConf(WritableUtils.readStr(dataInput));
        this.setStatus(Job.Status.valueOf((String)WritableUtils.readStr(dataInput)));
        this.setFrequency(dataInput.readInt());
        this.setTimeUnit(CoordinatorJob.Timeunit.valueOf((String)WritableUtils.readStr(dataInput)));
        this.setTimeZone(WritableUtils.readStr(dataInput));
        this.setConcurrency(dataInput.readInt());
        this.setExecutionOrder(CoordinatorJob.Execution.valueOf((String)WritableUtils.readStr(dataInput)));
        long d = dataInput.readLong();
        if (d != -1L) {
            this.setLastActionTime(new Date(d));
        }
        if ((d = dataInput.readLong()) != -1L) {
            this.setNextMaterializedTime(new Date(d));
        }
        if ((d = dataInput.readLong()) != -1L) {
            this.setStartTime(new Date(d));
        }
        if ((d = dataInput.readLong()) != -1L) {
            this.setEndTime(new Date(d));
        }
        this.setUser(WritableUtils.readStr(dataInput));
        this.setGroup(WritableUtils.readStr(dataInput));
        this.setExternalId(WritableUtils.readStr(dataInput));
        this.setTimeout(dataInput.readInt());
        this.setMatThrottling(dataInput.readInt());
        d = dataInput.readInt();
        if (d == 1L) {
            this.setPending();
        }
        if ((d = (long)dataInput.readInt()) == 1L) {
            this.setDoneMaterialization();
        }
        this.setAppNamespace(WritableUtils.readStr(dataInput));
    }

    @Override
    public Job.Status getStatus() {
        return Job.Status.valueOf((String)CoordinatorJobBean.pcGetstatus(this));
    }

    public String getStatusStr() {
        return CoordinatorJobBean.pcGetstatus(this);
    }

    @Override
    public void setStatus(Job.Status val) {
        super.setStatus(val);
        CoordinatorJobBean.pcSetstatus(this, val.toString());
    }

    public String getTimeUnitStr() {
        return CoordinatorJobBean.pcGettimeUnitStr(this);
    }

    @Override
    public CoordinatorJob.Timeunit getTimeUnit() {
        return CoordinatorJob.Timeunit.valueOf((String)CoordinatorJobBean.pcGettimeUnitStr(this));
    }

    public void setExecution(CoordinatorJob.Execution order) {
        CoordinatorJobBean.pcSetexecution(this, order.toString());
        super.setExecutionOrder(order);
    }

    @Override
    public CoordinatorJob.Execution getExecutionOrder() {
        return CoordinatorJob.Execution.valueOf((String)CoordinatorJobBean.pcGetexecution(this));
    }

    public String getExecution() {
        return CoordinatorJobBean.pcGetexecution(this);
    }

    @Override
    public void setLastActionTime(Date lastAction) {
        CoordinatorJobBean.pcSetlastActionTimestamp(this, DateUtils.convertDateToTimestamp(lastAction));
        super.setLastActionTime(lastAction);
    }

    @Override
    public Date getLastActionTime() {
        return DateUtils.toDate(CoordinatorJobBean.pcGetlastActionTimestamp(this));
    }

    public Timestamp getLastActionTimestamp() {
        return CoordinatorJobBean.pcGetlastActionTimestamp(this);
    }

    @Override
    public void setNextMaterializedTime(Date nextMaterializedTime) {
        super.setNextMaterializedTime(nextMaterializedTime);
        CoordinatorJobBean.pcSetnextMaterializedTimestamp(this, DateUtils.convertDateToTimestamp(nextMaterializedTime));
    }

    @Override
    public Date getNextMaterializedTime() {
        return DateUtils.toDate(CoordinatorJobBean.pcGetnextMaterializedTimestamp(this));
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        CoordinatorJobBean.pcSetlastModifiedTimestamp(this, DateUtils.convertDateToTimestamp(lastModifiedTime));
    }

    public Date getLastModifiedTime() {
        return DateUtils.toDate(CoordinatorJobBean.pcGetlastModifiedTimestamp(this));
    }

    public void setSuspendedTime(Date suspendedTime) {
        CoordinatorJobBean.pcSetsuspendedTimestamp(this, DateUtils.convertDateToTimestamp(suspendedTime));
    }

    public Date getSuspendedTime() {
        return DateUtils.toDate(CoordinatorJobBean.pcGetsuspendedTimestamp(this));
    }

    @Override
    public void setStartTime(Date startTime) {
        super.setStartTime(startTime);
        CoordinatorJobBean.pcSetstartTimestamp(this, DateUtils.convertDateToTimestamp(startTime));
    }

    @Override
    public Date getStartTime() {
        return DateUtils.toDate(CoordinatorJobBean.pcGetstartTimestamp(this));
    }

    @Override
    public void setEndTime(Date endTime) {
        super.setEndTime(endTime);
        CoordinatorJobBean.pcSetendTimestamp(this, DateUtils.convertDateToTimestamp(endTime));
    }

    @Override
    public void setPauseTime(Date pauseTime) {
        super.setPauseTime(pauseTime);
        CoordinatorJobBean.pcSetpauseTimestamp(this, DateUtils.convertDateToTimestamp(pauseTime));
    }

    @Override
    public Date getEndTime() {
        return DateUtils.toDate(CoordinatorJobBean.pcGetendTimestamp(this));
    }

    @Override
    public Date getPauseTime() {
        return DateUtils.toDate(CoordinatorJobBean.pcGetpauseTimestamp(this));
    }

    public void setCreatedTime(Date createTime) {
        CoordinatorJobBean.pcSetcreatedTimestamp(this, DateUtils.convertDateToTimestamp(createTime));
    }

    public Date getCreatedTime() {
        return DateUtils.toDate(CoordinatorJobBean.pcGetcreatedTimestamp(this));
    }

    public Timestamp getCreatedTimestamp() {
        return CoordinatorJobBean.pcGetcreatedTimestamp(this);
    }

    public String getAuthToken() {
        return CoordinatorJobBean.pcGetauthToken(this);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 1055128;
    }

    static {
        Class clazz = class$Lorg$apache$oozie$client$rest$JsonCoordinatorJob != null ? class$Lorg$apache$oozie$client$rest$JsonCoordinatorJob : (class$Lorg$apache$oozie$client$rest$JsonCoordinatorJob = CoordinatorJobBean.class$("org.apache.oozie.client.rest.JsonCoordinatorJob"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"appNamespace", "authToken", "createdTimestamp", "doneMaterialization", "endTimestamp", "execution", "jobXml", "lastActionTimestamp", "lastModifiedTimestamp", "nextMaterializedTimestamp", "origJobXml", "pauseTimestamp", "pending", "slaXml", "startTimestamp", "status", "suspendedTimestamp", "timeUnitStr"};
        Class[] classArray = new Class[18];
        Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorJobBean.class$("java.lang.String"));
        classArray[0] = clazz2;
        classArray[1] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorJobBean.class$("java.lang.String"));
        Class clazz3 = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = CoordinatorJobBean.class$("java.sql.Timestamp"));
        classArray[2] = clazz3;
        classArray[3] = Integer.TYPE;
        classArray[4] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = CoordinatorJobBean.class$("java.sql.Timestamp"));
        classArray[5] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorJobBean.class$("java.lang.String"));
        classArray[6] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorJobBean.class$("java.lang.String"));
        classArray[7] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = CoordinatorJobBean.class$("java.sql.Timestamp"));
        classArray[8] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = CoordinatorJobBean.class$("java.sql.Timestamp"));
        classArray[9] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = CoordinatorJobBean.class$("java.sql.Timestamp"));
        classArray[10] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorJobBean.class$("java.lang.String"));
        classArray[11] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = CoordinatorJobBean.class$("java.sql.Timestamp"));
        classArray[12] = Integer.TYPE;
        classArray[13] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorJobBean.class$("java.lang.String"));
        classArray[14] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = CoordinatorJobBean.class$("java.sql.Timestamp"));
        classArray[15] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorJobBean.class$("java.lang.String"));
        classArray[16] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = CoordinatorJobBean.class$("java.sql.Timestamp"));
        classArray[17] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorJobBean.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz4 = class$Lorg$apache$oozie$CoordinatorJobBean != null ? class$Lorg$apache$oozie$CoordinatorJobBean : (class$Lorg$apache$oozie$CoordinatorJobBean = CoordinatorJobBean.class$("org.apache.oozie.CoordinatorJobBean"));
        PCRegistry.register((Class)clazz4, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"CoordinatorJobBean", (PersistenceCapable)new CoordinatorJobBean());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.appNamespace = null;
        this.authToken = null;
        this.createdTimestamp = null;
        this.doneMaterialization = 0;
        this.endTimestamp = null;
        this.execution = null;
        this.jobXml = null;
        this.lastActionTimestamp = null;
        this.lastModifiedTimestamp = null;
        this.nextMaterializedTimestamp = null;
        this.origJobXml = null;
        this.pauseTimestamp = null;
        this.pending = 0;
        this.slaXml = null;
        this.startTimestamp = null;
        this.status = null;
        this.suspendedTimestamp = null;
        this.timeUnitStr = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        CoordinatorJobBean coordinatorJobBean = new CoordinatorJobBean();
        if (bl) {
            coordinatorJobBean.pcClearFields();
        }
        coordinatorJobBean.pcStateManager = stateManager;
        coordinatorJobBean.pcCopyKeyFieldsFromObjectId(object);
        return coordinatorJobBean;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        CoordinatorJobBean coordinatorJobBean = new CoordinatorJobBean();
        if (bl) {
            coordinatorJobBean.pcClearFields();
        }
        coordinatorJobBean.pcStateManager = stateManager;
        return coordinatorJobBean;
    }

    protected static int pcGetManagedFieldCount() {
        return 18 + JsonCoordinatorJob.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.appNamespace = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.authToken = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.createdTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.doneMaterialization = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.endTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.execution = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.jobXml = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.lastActionTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.lastModifiedTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.nextMaterializedTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.origJobXml = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.pauseTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.pending = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.slaXml = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.startTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.status = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 16: {
                this.suspendedTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 17: {
                this.timeUnitStr = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.appNamespace);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.authToken);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.createdTimestamp);
                return;
            }
            case 3: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.doneMaterialization);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.endTimestamp);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.execution);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.jobXml);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.lastActionTimestamp);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.lastModifiedTimestamp);
                return;
            }
            case 9: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.nextMaterializedTimestamp);
                return;
            }
            case 10: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.origJobXml);
                return;
            }
            case 11: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.pauseTimestamp);
                return;
            }
            case 12: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.pending);
                return;
            }
            case 13: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.slaXml);
                return;
            }
            case 14: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.startTimestamp);
                return;
            }
            case 15: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.status);
                return;
            }
            case 16: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.suspendedTimestamp);
                return;
            }
            case 17: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.timeUnitStr);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(CoordinatorJobBean coordinatorJobBean, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(coordinatorJobBean, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.appNamespace = coordinatorJobBean.appNamespace;
                return;
            }
            case 1: {
                this.authToken = coordinatorJobBean.authToken;
                return;
            }
            case 2: {
                this.createdTimestamp = coordinatorJobBean.createdTimestamp;
                return;
            }
            case 3: {
                this.doneMaterialization = coordinatorJobBean.doneMaterialization;
                return;
            }
            case 4: {
                this.endTimestamp = coordinatorJobBean.endTimestamp;
                return;
            }
            case 5: {
                this.execution = coordinatorJobBean.execution;
                return;
            }
            case 6: {
                this.jobXml = coordinatorJobBean.jobXml;
                return;
            }
            case 7: {
                this.lastActionTimestamp = coordinatorJobBean.lastActionTimestamp;
                return;
            }
            case 8: {
                this.lastModifiedTimestamp = coordinatorJobBean.lastModifiedTimestamp;
                return;
            }
            case 9: {
                this.nextMaterializedTimestamp = coordinatorJobBean.nextMaterializedTimestamp;
                return;
            }
            case 10: {
                this.origJobXml = coordinatorJobBean.origJobXml;
                return;
            }
            case 11: {
                this.pauseTimestamp = coordinatorJobBean.pauseTimestamp;
                return;
            }
            case 12: {
                this.pending = coordinatorJobBean.pending;
                return;
            }
            case 13: {
                this.slaXml = coordinatorJobBean.slaXml;
                return;
            }
            case 14: {
                this.startTimestamp = coordinatorJobBean.startTimestamp;
                return;
            }
            case 15: {
                this.status = coordinatorJobBean.status;
                return;
            }
            case 16: {
                this.suspendedTimestamp = coordinatorJobBean.suspendedTimestamp;
                return;
            }
            case 17: {
                this.timeUnitStr = coordinatorJobBean.timeUnitStr;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        CoordinatorJobBean coordinatorJobBean = (CoordinatorJobBean)object;
        if (coordinatorJobBean.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(coordinatorJobBean, nArray[n]);
            ++n;
        }
    }

    private static final String pcGetappNamespace(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.appNamespace;
        }
        int n = pcInheritedFieldCount + 0;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.appNamespace;
    }

    private static final void pcSetappNamespace(CoordinatorJobBean coordinatorJobBean, String string) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.appNamespace = string;
            return;
        }
        coordinatorJobBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 0, coordinatorJobBean.appNamespace, string, 0);
    }

    private static final String pcGetauthToken(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.authToken;
        }
        int n = pcInheritedFieldCount + 1;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.authToken;
    }

    private static final void pcSetauthToken(CoordinatorJobBean coordinatorJobBean, String string) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.authToken = string;
            return;
        }
        coordinatorJobBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 1, coordinatorJobBean.authToken, string, 0);
    }

    private static final Timestamp pcGetcreatedTimestamp(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.createdTimestamp;
        }
        int n = pcInheritedFieldCount + 2;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.createdTimestamp;
    }

    private static final void pcSetcreatedTimestamp(CoordinatorJobBean coordinatorJobBean, Timestamp timestamp) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.createdTimestamp = timestamp;
            return;
        }
        coordinatorJobBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 2, (Object)coordinatorJobBean.createdTimestamp, (Object)timestamp, 0);
    }

    private static final int pcGetdoneMaterialization(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.doneMaterialization;
        }
        int n = pcInheritedFieldCount + 3;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.doneMaterialization;
    }

    private static final void pcSetdoneMaterialization(CoordinatorJobBean coordinatorJobBean, int n) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.doneMaterialization = n;
            return;
        }
        coordinatorJobBean.pcStateManager.settingIntField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 3, coordinatorJobBean.doneMaterialization, n, 0);
    }

    private static final Timestamp pcGetendTimestamp(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.endTimestamp;
        }
        int n = pcInheritedFieldCount + 4;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.endTimestamp;
    }

    private static final void pcSetendTimestamp(CoordinatorJobBean coordinatorJobBean, Timestamp timestamp) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.endTimestamp = timestamp;
            return;
        }
        coordinatorJobBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 4, (Object)coordinatorJobBean.endTimestamp, (Object)timestamp, 0);
    }

    private static final String pcGetexecution(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.execution;
        }
        int n = pcInheritedFieldCount + 5;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.execution;
    }

    private static final void pcSetexecution(CoordinatorJobBean coordinatorJobBean, String string) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.execution = string;
            return;
        }
        coordinatorJobBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 5, coordinatorJobBean.execution, string, 0);
    }

    private static final String pcGetjobXml(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.jobXml;
        }
        int n = pcInheritedFieldCount + 6;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.jobXml;
    }

    private static final void pcSetjobXml(CoordinatorJobBean coordinatorJobBean, String string) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.jobXml = string;
            return;
        }
        coordinatorJobBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 6, coordinatorJobBean.jobXml, string, 0);
    }

    private static final Timestamp pcGetlastActionTimestamp(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.lastActionTimestamp;
        }
        int n = pcInheritedFieldCount + 7;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.lastActionTimestamp;
    }

    private static final void pcSetlastActionTimestamp(CoordinatorJobBean coordinatorJobBean, Timestamp timestamp) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.lastActionTimestamp = timestamp;
            return;
        }
        coordinatorJobBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 7, (Object)coordinatorJobBean.lastActionTimestamp, (Object)timestamp, 0);
    }

    private static final Timestamp pcGetlastModifiedTimestamp(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.lastModifiedTimestamp;
        }
        int n = pcInheritedFieldCount + 8;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.lastModifiedTimestamp;
    }

    private static final void pcSetlastModifiedTimestamp(CoordinatorJobBean coordinatorJobBean, Timestamp timestamp) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.lastModifiedTimestamp = timestamp;
            return;
        }
        coordinatorJobBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 8, (Object)coordinatorJobBean.lastModifiedTimestamp, (Object)timestamp, 0);
    }

    private static final Timestamp pcGetnextMaterializedTimestamp(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.nextMaterializedTimestamp;
        }
        int n = pcInheritedFieldCount + 9;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.nextMaterializedTimestamp;
    }

    private static final void pcSetnextMaterializedTimestamp(CoordinatorJobBean coordinatorJobBean, Timestamp timestamp) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.nextMaterializedTimestamp = timestamp;
            return;
        }
        coordinatorJobBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 9, (Object)coordinatorJobBean.nextMaterializedTimestamp, (Object)timestamp, 0);
    }

    private static final String pcGetorigJobXml(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.origJobXml;
        }
        int n = pcInheritedFieldCount + 10;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.origJobXml;
    }

    private static final void pcSetorigJobXml(CoordinatorJobBean coordinatorJobBean, String string) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.origJobXml = string;
            return;
        }
        coordinatorJobBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 10, coordinatorJobBean.origJobXml, string, 0);
    }

    private static final Timestamp pcGetpauseTimestamp(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.pauseTimestamp;
        }
        int n = pcInheritedFieldCount + 11;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.pauseTimestamp;
    }

    private static final void pcSetpauseTimestamp(CoordinatorJobBean coordinatorJobBean, Timestamp timestamp) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.pauseTimestamp = timestamp;
            return;
        }
        coordinatorJobBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 11, (Object)coordinatorJobBean.pauseTimestamp, (Object)timestamp, 0);
    }

    private static final int pcGetpending(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.pending;
        }
        int n = pcInheritedFieldCount + 12;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.pending;
    }

    private static final void pcSetpending(CoordinatorJobBean coordinatorJobBean, int n) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.pending = n;
            return;
        }
        coordinatorJobBean.pcStateManager.settingIntField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 12, coordinatorJobBean.pending, n, 0);
    }

    private static final String pcGetslaXml(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.slaXml;
        }
        int n = pcInheritedFieldCount + 13;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.slaXml;
    }

    private static final void pcSetslaXml(CoordinatorJobBean coordinatorJobBean, String string) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.slaXml = string;
            return;
        }
        coordinatorJobBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 13, coordinatorJobBean.slaXml, string, 0);
    }

    private static final Timestamp pcGetstartTimestamp(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.startTimestamp;
        }
        int n = pcInheritedFieldCount + 14;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.startTimestamp;
    }

    private static final void pcSetstartTimestamp(CoordinatorJobBean coordinatorJobBean, Timestamp timestamp) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.startTimestamp = timestamp;
            return;
        }
        coordinatorJobBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 14, (Object)coordinatorJobBean.startTimestamp, (Object)timestamp, 0);
    }

    private static final String pcGetstatus(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.status;
        }
        int n = pcInheritedFieldCount + 15;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.status;
    }

    private static final void pcSetstatus(CoordinatorJobBean coordinatorJobBean, String string) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.status = string;
            return;
        }
        coordinatorJobBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 15, coordinatorJobBean.status, string, 0);
    }

    private static final Timestamp pcGetsuspendedTimestamp(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.suspendedTimestamp;
        }
        int n = pcInheritedFieldCount + 16;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.suspendedTimestamp;
    }

    private static final void pcSetsuspendedTimestamp(CoordinatorJobBean coordinatorJobBean, Timestamp timestamp) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.suspendedTimestamp = timestamp;
            return;
        }
        coordinatorJobBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 16, (Object)coordinatorJobBean.suspendedTimestamp, (Object)timestamp, 0);
    }

    private static final String pcGettimeUnitStr(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.timeUnitStr;
        }
        int n = pcInheritedFieldCount + 17;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.timeUnitStr;
    }

    private static final void pcSettimeUnitStr(CoordinatorJobBean coordinatorJobBean, String string) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.timeUnitStr = string;
            return;
        }
        coordinatorJobBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 17, coordinatorJobBean.timeUnitStr, string, 0);
    }
}

