/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AccessControlException;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DiskChecker;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.action.hadoop.AuthHelper;
import org.apache.oozie.action.hadoop.Credentials;
import org.apache.oozie.action.hadoop.CredentialsProperties;
import org.apache.oozie.action.hadoop.CredentialsProvider;
import org.apache.oozie.action.hadoop.FsActionExecutor;
import org.apache.oozie.action.hadoop.LauncherException;
import org.apache.oozie.action.hadoop.LauncherMainException;
import org.apache.oozie.action.hadoop.LauncherMapper;
import org.apache.oozie.action.hadoop.LauncherSecurityManager;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.PropertiesUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

public class JavaActionExecutor
extends ActionExecutor {
    private static final String HADOOP_USER = "user.name";
    private static final String HADOOP_UGI = "hadoop.job.ugi";
    private static final String HADOOP_JOB_TRACKER = "mapred.job.tracker";
    private static final String HADOOP_NAME_NODE = "fs.default.name";
    private static final Set<String> DISALLOWED_PROPERTIES = new HashSet<String>();
    private static int maxActionOutputLen;
    private static final String SUCCEEDED = "SUCCEEDED";
    private static final String KILLED = "KILLED";
    private static final String FAILED = "FAILED";
    private static final String FAILED_KILLED = "FAILED/KILLED";
    private static final String RUNNING = "RUNNING";
    private XLog log = XLog.getLog(this.getClass());
    private static final String QUEUE_NAME = "mapred.job.queue.name";
    private static final String OOZIE_LAUNCHER_QUEUE_NAME = "oozie.launcher.mapred.job.queue.name";
    private static final Set<String> SPECIAL_PROPERTIES;
    private static Set<String> FINAL_STATUS;

    public JavaActionExecutor() {
        this("java");
    }

    protected JavaActionExecutor(String type) {
        super(type);
    }

    protected String getLauncherJarName() {
        return this.getType() + "-launcher.jar";
    }

    protected List<Class> getLauncherClasses() {
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(LauncherMapper.class);
        classes.add(LauncherSecurityManager.class);
        classes.add(LauncherException.class);
        classes.add(LauncherMainException.class);
        return classes;
    }

    @Override
    public void initActionType() {
        super.initActionType();
        maxActionOutputLen = this.getOozieConf().getInt("oozie.servlet.CallbackServlet.max.data.len", 2048);
        try {
            List<Class> classes = this.getLauncherClasses();
            Class[] launcherClasses = classes.toArray(new Class[classes.size()]);
            IOUtils.createJar(new File(this.getOozieRuntimeDir()), this.getLauncherJarName(), launcherClasses);
            this.registerError(UnknownHostException.class.getName(), ActionExecutorException.ErrorType.TRANSIENT, "JA001");
            this.registerError(AccessControlException.class.getName(), ActionExecutorException.ErrorType.NON_TRANSIENT, "JA002");
            this.registerError(DiskChecker.DiskOutOfSpaceException.class.getName(), ActionExecutorException.ErrorType.NON_TRANSIENT, "JA003");
            this.registerError(QuotaExceededException.class.getName(), ActionExecutorException.ErrorType.NON_TRANSIENT, "JA004");
            this.registerError(SafeModeException.class.getName(), ActionExecutorException.ErrorType.NON_TRANSIENT, "JA005");
            this.registerError(ConnectException.class.getName(), ActionExecutorException.ErrorType.TRANSIENT, "JA006");
            this.registerError(JDOMException.class.getName(), ActionExecutorException.ErrorType.ERROR, "JA007");
            this.registerError(FileNotFoundException.class.getName(), ActionExecutorException.ErrorType.ERROR, "JA008");
            this.registerError(IOException.class.getName(), ActionExecutorException.ErrorType.TRANSIENT, "JA009");
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    void checkForDisallowedProps(Configuration conf, String confName) throws ActionExecutorException {
        for (String prop : DISALLOWED_PROPERTIES) {
            if (conf.get(prop) == null) continue;
            throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "JA010", "Property [{0}] not allowed in action [{1}] configuration", prop, confName);
        }
    }

    public Configuration createBaseHadoopConf(ActionExecutor.Context context, Element actionXml) {
        XConfiguration conf = new XConfiguration();
        conf.set(HADOOP_USER, context.getProtoActionConf().get(HADOOP_USER));
        conf.set(HADOOP_UGI, context.getProtoActionConf().get(HADOOP_UGI));
        if (context.getProtoActionConf().get("mapreduce.jobtracker.kerberos.principal") != null) {
            conf.set("mapreduce.jobtracker.kerberos.principal", context.getProtoActionConf().get("mapreduce.jobtracker.kerberos.principal"));
        }
        if (context.getProtoActionConf().get("dfs.namenode.kerberos.principal") != null) {
            conf.set("dfs.namenode.kerberos.principal", context.getProtoActionConf().get("dfs.namenode.kerberos.principal"));
        }
        conf.set("group.name", context.getProtoActionConf().get("group.name"));
        Namespace ns = actionXml.getNamespace();
        String jobTracker = actionXml.getChild("job-tracker", ns).getTextTrim();
        String nameNode = actionXml.getChild("name-node", ns).getTextTrim();
        conf.set(HADOOP_JOB_TRACKER, jobTracker);
        conf.set(HADOOP_NAME_NODE, nameNode);
        conf.set("mapreduce.fileoutputcommitter.marksuccessfuljobs", "true");
        return conf;
    }

    Configuration setupLauncherConf(Configuration conf, Element actionXml, Path appPath, ActionExecutor.Context context) throws ActionExecutorException {
        try {
            Namespace ns = actionXml.getNamespace();
            Element e = actionXml.getChild("configuration", ns);
            if (e != null) {
                String strConf = XmlUtils.prettyPrint(e).toString();
                XConfiguration inlineConf = new XConfiguration(new StringReader(strConf));
                XConfiguration launcherConf = new XConfiguration();
                Iterator i$ = inlineConf.iterator();
                while (i$.hasNext()) {
                    Map.Entry entry = (Map.Entry)i$.next();
                    if (!((String)entry.getKey()).startsWith("oozie.launcher.")) continue;
                    String name = ((String)entry.getKey()).substring("oozie.launcher.".length());
                    String value = (String)entry.getValue();
                    launcherConf.set((String)entry.getKey(), value);
                    launcherConf.set(name, value);
                }
                this.checkForDisallowedProps(launcherConf, "inline launcher configuration");
                XConfiguration.copy(launcherConf, conf);
            }
            return conf;
        }
        catch (IOException ex) {
            throw this.convertException(ex);
        }
    }

    protected FileSystem getActionFileSystem(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        try {
            Element actionXml = XmlUtils.parseXml(action.getConf());
            return this.getActionFileSystem(context, actionXml);
        }
        catch (JDOMException ex) {
            throw this.convertException((Exception)((Object)ex));
        }
    }

    protected FileSystem getActionFileSystem(ActionExecutor.Context context, Element actionXml) throws ActionExecutorException {
        try {
            return context.getAppFileSystem();
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    Configuration setupActionConf(Configuration actionConf, ActionExecutor.Context context, Element actionXml, Path appPath) throws ActionExecutorException {
        try {
            Namespace ns = actionXml.getNamespace();
            Element e = actionXml.getChild("job-xml", ns);
            if (e != null) {
                String jobXml = e.getTextTrim();
                Path path = new Path(appPath, jobXml);
                FileSystem fs = this.getActionFileSystem(context, actionXml);
                XConfiguration jobXmlConf = new XConfiguration((InputStream)fs.open(path));
                this.checkForDisallowedProps(jobXmlConf, "job-xml");
                XConfiguration.copy(jobXmlConf, actionConf);
            }
            if ((e = actionXml.getChild("configuration", ns)) != null) {
                String strConf = XmlUtils.prettyPrint(e).toString();
                XConfiguration inlineConf = new XConfiguration(new StringReader(strConf));
                this.checkForDisallowedProps(inlineConf, "inline configuration");
                XConfiguration.copy(inlineConf, actionConf);
            }
            return actionConf;
        }
        catch (IOException ex) {
            throw this.convertException(ex);
        }
    }

    Configuration addToCache(Configuration conf, Path appPath, String filePath, boolean archive) throws ActionExecutorException {
        Path path = null;
        try {
            path = filePath.startsWith("/") ? new Path(filePath) : new Path(appPath, filePath);
            URI uri = new URI(path.toUri().getPath());
            if (archive) {
                DistributedCache.addCacheArchive((URI)uri, (Configuration)conf);
            } else {
                String fileName = filePath.substring(filePath.lastIndexOf("/") + 1);
                if (fileName.endsWith(".so") || fileName.contains(".so.")) {
                    uri = new Path(path.toString() + "#" + fileName).toUri();
                    uri = new URI(uri.getPath());
                    DistributedCache.addCacheFile((URI)uri, (Configuration)conf);
                } else if (fileName.endsWith(".jar")) {
                    if (!fileName.contains("#")) {
                        path = new Path(uri.toString());
                        String user = conf.get(HADOOP_USER);
                        String group = conf.get("group.name");
                        Services.get().get(HadoopAccessorService.class).addFileToClassPath(user, group, path, conf);
                    } else {
                        DistributedCache.addCacheFile((URI)uri, (Configuration)conf);
                    }
                } else {
                    if (!fileName.contains("#")) {
                        uri = new Path(path.toString() + "#" + fileName).toUri();
                        uri = new URI(uri.getPath());
                    }
                    DistributedCache.addCacheFile((URI)uri, (Configuration)conf);
                }
            }
            DistributedCache.createSymlink((Configuration)conf);
            return conf;
        }
        catch (Exception ex) {
            XLog.getLog(this.getClass()).debug("Errors when add to DistributedCache. Path=" + path + ", archive=" + archive + ", conf=" + XmlUtils.prettyPrint(conf).toString());
            throw this.convertException(ex);
        }
    }

    String getOozieLauncherJar(ActionExecutor.Context context) throws ActionExecutorException {
        try {
            return new Path(context.getActionDir(), this.getLauncherJarName()).toString();
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    public void prepareActionDir(FileSystem actionFs, ActionExecutor.Context context) throws ActionExecutorException {
        block4: {
            try {
                Path actionDir = context.getActionDir();
                Path tempActionDir = new Path(actionDir.getParent(), actionDir.getName() + ".tmp");
                if (actionFs.exists(actionDir)) break block4;
                try {
                    actionFs.copyFromLocalFile(new Path(this.getOozieRuntimeDir(), this.getLauncherJarName()), new Path(tempActionDir, this.getLauncherJarName()));
                    actionFs.rename(tempActionDir, actionDir);
                }
                catch (IOException ex) {
                    actionFs.delete(tempActionDir, true);
                    actionFs.delete(actionDir, true);
                    throw ex;
                }
            }
            catch (Exception ex) {
                throw this.convertException(ex);
            }
        }
    }

    void cleanUpActionDir(FileSystem actionFs, ActionExecutor.Context context) throws ActionExecutorException {
        try {
            Path actionDir = context.getActionDir();
            if (!context.getProtoActionConf().getBoolean("oozie.action.keep.action.dir", false) && actionFs.exists(actionDir)) {
                actionFs.delete(actionDir, true);
            }
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    void setLibFilesArchives(ActionExecutor.Context context, Element actionXml, Path appPath, Configuration conf) throws ActionExecutorException {
        Configuration proto = context.getProtoActionConf();
        this.addToCache(conf, appPath, this.getOozieLauncherJar(context), false);
        String[] paths = proto.getStrings("oozie.wf.application.lib");
        if (paths != null) {
            for (String path : paths) {
                this.addToCache(conf, appPath, path, false);
            }
        }
        for (Element eProp : actionXml.getChildren()) {
            if (eProp.getName().equals("file")) {
                String path = eProp.getTextTrim();
                this.addToCache(conf, appPath, path, false);
                continue;
            }
            if (!eProp.getName().equals("archive")) continue;
            String path = eProp.getTextTrim();
            this.addToCache(conf, appPath, path, true);
        }
    }

    protected String getLauncherMain(Configuration launcherConf, Element actionXml) {
        Namespace ns = actionXml.getNamespace();
        Element e = actionXml.getChild("main-class", ns);
        return e.getTextTrim();
    }

    JobConf createLauncherConf(FileSystem actionFs, ActionExecutor.Context context, WorkflowAction action, Element actionXml, Configuration actionConf) throws ActionExecutorException {
        try {
            Path appPathRoot = new Path(context.getWorkflow().getAppPath());
            if (actionFs.isFile(appPathRoot)) {
                appPathRoot = appPathRoot.getParent();
            }
            Configuration launcherConf = this.createBaseHadoopConf(context, actionXml);
            this.setupLauncherConf(launcherConf, actionXml, appPathRoot, context);
            JobConf launcherJobConf = new JobConf();
            XConfiguration.copy(launcherConf, (Configuration)launcherJobConf);
            this.setLibFilesArchives(context, actionXml, appPathRoot, (Configuration)launcherJobConf);
            String jobName = XLog.format("oozie:launcher:T={0}:W={1}:A={2}:ID={3}", this.getType(), context.getWorkflow().getAppName(), action.getName(), context.getWorkflow().getId());
            launcherJobConf.setJobName(jobName);
            String jobId = context.getWorkflow().getId();
            String actionId = action.getId();
            Path actionDir = context.getActionDir();
            String recoveryId = context.getRecoveryId();
            LauncherMapper.setupLauncherInfo(launcherJobConf, jobId, actionId, actionDir, recoveryId, actionConf);
            LauncherMapper.setupMainClass((Configuration)launcherJobConf, this.getLauncherMain(launcherConf, actionXml));
            LauncherMapper.setupMaxOutputData((Configuration)launcherJobConf, maxActionOutputLen);
            Namespace ns = actionXml.getNamespace();
            List list = actionXml.getChildren("arg", ns);
            String[] args = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                args[i] = ((Element)list.get(i)).getTextTrim();
            }
            LauncherMapper.setupMainArguments((Configuration)launcherJobConf, args);
            Element opt = actionXml.getChild("java-opts", ns);
            if (opt != null) {
                String opts = launcherConf.get("mapred.child.java.opts", "");
                opts = opts + " " + opt.getTextTrim();
                opts = opts.trim();
                launcherJobConf.set("mapred.child.java.opts", opts);
            }
            for (String name : SPECIAL_PROPERTIES) {
                String value = actionConf.get(name);
                if (value == null || name.equals(QUEUE_NAME) && (!name.equals(QUEUE_NAME) || launcherJobConf.get(OOZIE_LAUNCHER_QUEUE_NAME) != null)) continue;
                launcherJobConf.set(name, value);
            }
            launcherJobConf.setBoolean("mapreduce.job.complete.cancel.delegation.tokens", false);
            launcherJobConf.set("mapreduce.job.acl-modify-job", context.getWorkflow().getGroup());
            return launcherJobConf;
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    private void injectCallback(ActionExecutor.Context context, Configuration conf) {
        String callback = context.getCallbackUrl("$jobStatus");
        if (conf.get("job.end.notification.url") != null) {
            XLog.getLog(this.getClass()).warn("Overriding the action job end notification URI");
        }
        conf.set("job.end.notification.url", callback);
    }

    void injectActionCallback(ActionExecutor.Context context, Configuration actionConf) {
        this.injectCallback(context, actionConf);
    }

    void injectLauncherCallback(ActionExecutor.Context context, Configuration launcherConf) {
        this.injectCallback(context, launcherConf);
    }

    public void submitLauncher(FileSystem actionFs, ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        JobClient jobClient = null;
        boolean exception = false;
        try {
            RunningJob runningJob;
            Path appPathRoot = new Path(context.getWorkflow().getAppPath());
            if (actionFs.isFile(appPathRoot)) {
                appPathRoot = appPathRoot.getParent();
            }
            Element actionXml = XmlUtils.parseXml(action.getConf());
            Configuration actionConf = this.createBaseHadoopConf(context, actionXml);
            this.setupActionConf(actionConf, context, actionXml, appPathRoot);
            XLog.getLog(this.getClass()).debug("Setting LibFilesArchives ");
            this.setLibFilesArchives(context, actionXml, appPathRoot, actionConf);
            String jobName = XLog.format("oozie:action:T={0}:W={1}:A={2}:ID={3}", this.getType(), context.getWorkflow().getAppName(), action.getName(), context.getWorkflow().getId());
            actionConf.set("mapred.job.name", jobName);
            this.injectActionCallback(context, actionConf);
            actionConf.set("mapreduce.job.acl-modify-job", context.getWorkflow().getGroup());
            HashMap<String, CredentialsProperties> credentialsProperties = this.setCredentialPropertyToActionConf(context, action, actionConf);
            JobConf credentialsConf = new JobConf(false);
            XConfiguration.copy(actionConf, (Configuration)credentialsConf);
            this.setCredentialTokens(credentialsConf, context, action, credentialsProperties);
            for (Map.Entry entry : credentialsConf) {
                if (actionConf.get((String)entry.getKey()) != null) continue;
                actionConf.set((String)entry.getKey(), (String)entry.getValue());
            }
            JobConf launcherJobConf = this.createLauncherConf(actionFs, context, action, actionXml, actionConf);
            this.injectLauncherCallback(context, (Configuration)launcherJobConf);
            XLog.getLog(this.getClass()).debug("Creating Job Client for action " + action.getId());
            jobClient = this.createJobClient(context, launcherJobConf);
            String launcherId = LauncherMapper.getRecoveryId((Configuration)launcherJobConf, context.getActionDir(), context.getRecoveryId());
            boolean alreadyRunning = launcherId != null;
            boolean isUserRetry = ((WorkflowActionBean)action).isUserRetry();
            if (alreadyRunning && !isUserRetry) {
                runningJob = jobClient.getJob(JobID.forName((String)launcherId));
                if (runningJob == null) {
                    String jobTracker = launcherJobConf.get(HADOOP_JOB_TRACKER);
                    throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "JA017", "unknown job [{0}@{1}], cannot recover", launcherId, jobTracker);
                }
            } else {
                this.prepare(context, actionXml);
                XLog.getLog(this.getClass()).debug("Submitting the job through Job Client for action " + action.getId());
                AuthHelper.get().set(jobClient, launcherJobConf);
                this.log.debug("mapreduce.jobtracker.kerberos.principal = " + launcherJobConf.get("mapreduce.jobtracker.kerberos.principal"));
                this.log.debug("dfs.namenode.kerberos.principal = " + launcherJobConf.get("dfs.namenode.kerberos.principal"));
                if (this.needInjectCredentials()) {
                    for (Token tk : credentialsConf.getCredentials().getAllTokens()) {
                        this.log.debug("ADDING TOKEN: " + tk.getKind().toString());
                        launcherJobConf.getCredentials().addToken(tk.getKind(), tk);
                    }
                } else {
                    this.log.info("No need to inject credentials.");
                }
                runningJob = jobClient.submitJob(launcherJobConf);
                if (runningJob == null) {
                    throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "JA017", "Error submitting launcher for action [{0}]", action.getId());
                }
                launcherId = runningJob.getID().toString();
                XLog.getLog(this.getClass()).debug("After submission get the launcherId " + launcherId);
            }
            String jobTracker = launcherJobConf.get(HADOOP_JOB_TRACKER);
            String consoleUrl = runningJob.getTrackingURL();
            context.setStartData(launcherId, jobTracker, consoleUrl);
        }
        catch (Exception ex) {
            exception = true;
            throw this.convertException(ex);
        }
        finally {
            if (jobClient != null) {
                try {
                    jobClient.close();
                }
                catch (Exception e) {
                    if (exception) {
                        this.log.error((Object)"JobClient error: ", e);
                    }
                    throw this.convertException(e);
                }
            }
        }
    }

    private boolean needInjectCredentials() {
        boolean methodExists = true;
        try {
            Class<?> klass = Class.forName("org.apache.hadoop.mapred.JobConf");
            klass.getMethod("getCredentials", new Class[0]);
        }
        catch (ClassNotFoundException ex) {
            methodExists = false;
        }
        catch (NoSuchMethodException ex) {
            methodExists = false;
        }
        return methodExists;
    }

    protected HashMap<String, CredentialsProperties> setCredentialPropertyToActionConf(ActionExecutor.Context context, WorkflowAction action, Configuration actionConf) throws Exception {
        HashMap<String, CredentialsProperties> credPropertiesMap = null;
        if (context != null && action != null) {
            credPropertiesMap = this.getActionCredentialsProperties(context, action);
            if (credPropertiesMap != null) {
                for (String key : credPropertiesMap.keySet()) {
                    CredentialsProperties prop = credPropertiesMap.get(key);
                    if (prop == null) continue;
                    this.log.debug("Credential Properties set for action : " + action.getId());
                    for (String property : prop.getProperties().keySet()) {
                        actionConf.set(property, prop.getProperties().get(property));
                        this.log.debug("property : '" + property + "', value : '" + prop.getProperties().get(property) + "'");
                    }
                }
            } else {
                this.log.warn("No credential properties found for action : " + action.getId() + ", cred : " + action.getCred());
            }
        } else {
            this.log.warn("context or action is null");
        }
        return credPropertiesMap;
    }

    protected void setCredentialTokens(JobConf jobconf, ActionExecutor.Context context, WorkflowAction action, HashMap<String, CredentialsProperties> credPropertiesMap) throws Exception {
        if (context != null && action != null && credPropertiesMap != null) {
            for (Map.Entry<String, CredentialsProperties> entry : credPropertiesMap.entrySet()) {
                String credName = entry.getKey();
                CredentialsProperties credProps = entry.getValue();
                if (credProps != null) {
                    CredentialsProvider credProvider = new CredentialsProvider(credProps.getType());
                    Credentials credentialObject = credProvider.createCredentialObject();
                    if (credentialObject != null) {
                        credentialObject.addtoJobConf(jobconf, credProps, context);
                        this.log.debug("Retrieved Credential '" + credName + "' for action " + action.getId());
                        continue;
                    }
                    this.log.debug("Credentials object is null for name= " + credName + ", type=" + credProps.getType());
                    continue;
                }
                this.log.warn("Could not find credentials properties for: " + credName);
            }
        }
    }

    protected HashMap<String, CredentialsProperties> getActionCredentialsProperties(ActionExecutor.Context context, WorkflowAction action) throws Exception {
        HashMap<String, CredentialsProperties> props = new HashMap<String, CredentialsProperties>();
        if (context != null && action != null) {
            String[] credNames;
            String credsInAction = action.getCred();
            this.log.debug("Get credential '" + credsInAction + "' properties for action : " + action.getId());
            for (String credName : credNames = credsInAction.split(",")) {
                CredentialsProperties credProps = this.getCredProperties(context, credName);
                props.put(credName, credProps);
            }
        } else {
            this.log.warn("context or action is null");
        }
        return props;
    }

    protected CredentialsProperties getCredProperties(ActionExecutor.Context context, String credName) throws Exception {
        CredentialsProperties credProp = null;
        String workflowXml = ((WorkflowJobBean)context.getWorkflow()).getWorkflowInstance().getApp().getDefinition();
        Element elementJob = XmlUtils.parseXml(workflowXml);
        Element credentials = elementJob.getChild("credentials", elementJob.getNamespace());
        if (credentials != null) {
            for (Element credential : credentials.getChildren("credential", credentials.getNamespace())) {
                String name = credential.getAttributeValue("name");
                String type = credential.getAttributeValue("type");
                this.log.debug("getCredProperties: Name: " + name + ", Type: " + type);
                if (!name.equalsIgnoreCase(credName)) continue;
                credProp = new CredentialsProperties(name, type);
                for (Element property : credential.getChildren("property", credential.getNamespace())) {
                    credProp.getProperties().put(property.getChildText("name", property.getNamespace()), property.getChildText("value", property.getNamespace()));
                    this.log.debug("getCredProperties: Properties name :'" + property.getChildText("name", property.getNamespace()) + "', Value : '" + property.getChildText("value", property.getNamespace()) + "'");
                }
            }
        } else {
            this.log.warn("credentials is null for the action");
        }
        return credProp;
    }

    void prepare(ActionExecutor.Context context, Element actionXml) throws ActionExecutorException {
        Namespace ns = actionXml.getNamespace();
        Element prepare = actionXml.getChild("prepare", ns);
        if (prepare != null) {
            XLog.getLog(this.getClass()).debug("Preparing the action with FileSystem operation");
            FsActionExecutor fsAe = new FsActionExecutor();
            fsAe.doOperations(context, prepare);
            XLog.getLog(this.getClass()).debug("FS Operation is completed");
        }
    }

    @Override
    public void start(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        try {
            XLog.getLog(this.getClass()).debug("Starting action " + action.getId() + " getting Action File System");
            FileSystem actionFs = this.getActionFileSystem(context, action);
            XLog.getLog(this.getClass()).debug("Preparing action Dir through copying " + context.getActionDir());
            this.prepareActionDir(actionFs, context);
            XLog.getLog(this.getClass()).debug("Action Dir is ready. Submitting the action ");
            this.submitLauncher(actionFs, context, action);
            XLog.getLog(this.getClass()).debug("Action submit completed. Performing check ");
            this.check(context, action);
            XLog.getLog(this.getClass()).debug("Action check is done after submission");
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public void end(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        try {
            String externalStatus = action.getExternalStatus();
            WorkflowAction.Status status = externalStatus.equals(SUCCEEDED) ? WorkflowAction.Status.OK : WorkflowAction.Status.ERROR;
            context.setEndData(status, this.getActionSignal(status));
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
        finally {
            try {
                FileSystem actionFs = this.getActionFileSystem(context, action);
                this.cleanUpActionDir(actionFs, context);
            }
            catch (Exception ex) {
                throw this.convertException(ex);
            }
        }
    }

    protected JobClient createJobClient(ActionExecutor.Context context, JobConf jobConf) throws HadoopAccessorException {
        String user = context.getWorkflow().getUser();
        String group = context.getWorkflow().getGroup();
        return Services.get().get(HadoopAccessorService.class).createJobClient(user, group, jobConf);
    }

    @Override
    public void check(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        JobClient jobClient = null;
        boolean exception = false;
        try {
            Element actionXml = XmlUtils.parseXml(action.getConf());
            FileSystem actionFs = this.getActionFileSystem(context, actionXml);
            Configuration conf = this.createBaseHadoopConf(context, actionXml);
            JobConf jobConf = new JobConf();
            XConfiguration.copy(conf, (Configuration)jobConf);
            jobClient = this.createJobClient(context, jobConf);
            RunningJob runningJob = jobClient.getJob(JobID.forName((String)action.getExternalId()));
            if (runningJob == null) {
                context.setExternalStatus(FAILED);
                context.setExecutionData(FAILED, null);
                throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "JA017", "Unknown hadoop job [{0}] associated with action [{1}].  Failing this action!", action.getExternalId(), action.getId());
            }
            if (runningJob.isComplete()) {
                BufferedReader reader;
                FSDataInputStream is;
                String group;
                Path actionDir = context.getActionDir();
                String user = context.getWorkflow().getUser();
                if (LauncherMapper.hasIdSwap(runningJob, user, group = context.getWorkflow().getGroup(), actionDir)) {
                    String launcherId = action.getExternalId();
                    Path idSwapPath = LauncherMapper.getIdSwapPath(context.getActionDir());
                    is = actionFs.open(idSwapPath);
                    reader = new BufferedReader(new InputStreamReader((InputStream)is));
                    Properties props = PropertiesUtils.readProperties(reader, maxActionOutputLen);
                    reader.close();
                    String newId = props.getProperty("id");
                    runningJob = jobClient.getJob(JobID.forName((String)newId));
                    if (runningJob == null) {
                        context.setExternalStatus(FAILED);
                        throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "JA017", "Unknown hadoop job [{0}] associated with action [{1}].  Failing this action!", newId, action.getId());
                    }
                    context.setStartData(newId, action.getTrackerUri(), runningJob.getTrackingURL());
                    XLog.getLog(this.getClass()).info(1, "External ID swap, old ID [{0}] new ID [{1}]", launcherId, newId);
                }
                if (runningJob.isComplete()) {
                    XLog.getLog(this.getClass()).info(1, "action completed, external ID [{0}]", action.getExternalId());
                    if (runningJob.isSuccessful() && LauncherMapper.isMainSuccessful(runningJob)) {
                        Properties props = null;
                        if (this.getCaptureOutput(action)) {
                            props = new Properties();
                            if (LauncherMapper.hasOutputData(runningJob)) {
                                Path actionOutput = LauncherMapper.getOutputDataPath(context.getActionDir());
                                is = actionFs.open(actionOutput);
                                reader = new BufferedReader(new InputStreamReader((InputStream)is));
                                props = PropertiesUtils.readProperties(reader, maxActionOutputLen);
                                reader.close();
                            }
                        }
                        context.setExecutionData(SUCCEEDED, props);
                        XLog.getLog(this.getClass()).info(1, "action produced output", new Object[0]);
                    } else {
                        String errorReason;
                        XLog log = XLog.getLog(this.getClass());
                        Path actionError = LauncherMapper.getErrorPath(context.getActionDir());
                        if (actionFs.exists(actionError)) {
                            FSDataInputStream is2 = actionFs.open(actionError);
                            BufferedReader reader2 = new BufferedReader(new InputStreamReader((InputStream)is2));
                            Properties props = PropertiesUtils.readProperties(reader2, -1);
                            reader2.close();
                            String errorCode = props.getProperty("error.code");
                            if (errorCode.equals("0")) {
                                errorCode = "JA018";
                            }
                            if (errorCode.equals("-1")) {
                                errorCode = "JA019";
                            }
                            errorReason = props.getProperty("error.reason");
                            log.warn("Launcher ERROR, reason: {0}", errorReason);
                            String exMsg = props.getProperty("exception.message");
                            String errorInfo = exMsg != null ? exMsg : errorReason;
                            context.setErrorInfo(errorCode, errorInfo);
                            String exStackTrace = props.getProperty("exception.stacktrace");
                            if (exMsg != null) {
                                log.warn("Launcher exception: {0}{E}{1}", exMsg, exStackTrace);
                            }
                        } else {
                            errorReason = XLog.format("LauncherMapper died, check Hadoop log for job [{0}:{1}]", action.getTrackerUri(), action.getExternalId());
                            log.warn(errorReason);
                        }
                        context.setExecutionData(FAILED_KILLED, null);
                    }
                } else {
                    context.setExternalStatus(RUNNING);
                    XLog.getLog(this.getClass()).info(1, "checking action, external ID [{0}] status [{1}]", action.getExternalId(), action.getExternalStatus());
                }
            } else {
                context.setExternalStatus(RUNNING);
                XLog.getLog(this.getClass()).info(1, "checking action, external ID [{0}] status [{1}]", action.getExternalId(), action.getExternalStatus());
            }
        }
        catch (Exception ex) {
            XLog.getLog(this.getClass()).warn("Exception in check(). Message[{0}]", ex.getMessage(), ex);
            exception = true;
            throw this.convertException(ex);
        }
        finally {
            if (jobClient != null) {
                try {
                    jobClient.close();
                }
                catch (Exception e) {
                    if (exception) {
                        this.log.error((Object)"JobClient error: ", e);
                    }
                    throw this.convertException(e);
                }
            }
        }
    }

    protected boolean getCaptureOutput(WorkflowAction action) throws JDOMException {
        Namespace ns;
        Element eConf = XmlUtils.parseXml(action.getConf());
        Element captureOutput = eConf.getChild("capture-output", ns = eConf.getNamespace());
        return captureOutput != null;
    }

    @Override
    public void kill(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        JobClient jobClient = null;
        boolean exception = false;
        try {
            Element actionXml = XmlUtils.parseXml(action.getConf());
            Configuration conf = this.createBaseHadoopConf(context, actionXml);
            JobConf jobConf = new JobConf();
            XConfiguration.copy(conf, (Configuration)jobConf);
            jobClient = this.createJobClient(context, jobConf);
            RunningJob runningJob = jobClient.getJob(JobID.forName((String)action.getExternalId()));
            if (runningJob != null) {
                runningJob.killJob();
            }
            context.setExternalStatus(KILLED);
            context.setExecutionData(KILLED, null);
        }
        catch (Exception ex) {
            exception = true;
            throw this.convertException(ex);
        }
        finally {
            try {
                FileSystem actionFs = this.getActionFileSystem(context, action);
                this.cleanUpActionDir(actionFs, context);
                if (jobClient != null) {
                    jobClient.close();
                }
            }
            catch (Exception ex) {
                if (exception) {
                    this.log.error((Object)"Error: ", ex);
                }
                throw this.convertException(ex);
            }
        }
    }

    @Override
    public boolean isCompleted(String externalStatus) {
        return FINAL_STATUS.contains(externalStatus);
    }

    static {
        DISALLOWED_PROPERTIES.add(HADOOP_USER);
        DISALLOWED_PROPERTIES.add(HADOOP_UGI);
        DISALLOWED_PROPERTIES.add(HADOOP_JOB_TRACKER);
        DISALLOWED_PROPERTIES.add(HADOOP_NAME_NODE);
        DISALLOWED_PROPERTIES.add("mapreduce.jobtracker.kerberos.principal");
        DISALLOWED_PROPERTIES.add("dfs.namenode.kerberos.principal");
        SPECIAL_PROPERTIES = new HashSet<String>();
        SPECIAL_PROPERTIES.add(QUEUE_NAME);
        SPECIAL_PROPERTIES.add("mapreduce.jobtracker.kerberos.principal");
        SPECIAL_PROPERTIES.add("dfs.namenode.kerberos.principal");
        FINAL_STATUS = new HashSet<String>();
        FINAL_STATUS.add(SUCCEEDED);
        FINAL_STATUS.add(KILLED);
        FINAL_STATUS.add(FAILED);
        FINAL_STATUS.add(FAILED_KILLED);
    }
}

