/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command;

import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.TransitionXCommand;

public abstract class RerunTransitionXCommand<T>
extends TransitionXCommand<T> {
    protected String jobId;
    protected T ret;
    protected Job.Status prevStatus;

    public RerunTransitionXCommand(String name, String type, int priority) {
        super(name, type, priority);
    }

    public RerunTransitionXCommand(String name, String type, int priority, boolean dryrun) {
        super(name, type, priority, dryrun);
    }

    @Override
    public void transitToNext() {
        if (this.job == null) {
            this.job = this.getJob();
        }
        this.prevStatus = this.job.getStatus();
        this.job.setStatus(Job.Status.RUNNING);
        this.job.setPending();
    }

    public abstract void rerunChildren() throws CommandException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected T execute() throws CommandException {
        this.getLog().info("STARTED " + this.getClass().getSimpleName() + " for jobId=" + this.jobId);
        try {
            this.transitToNext();
            this.rerunChildren();
            this.updateJob();
        }
        finally {
            this.notifyParent();
        }
        this.getLog().info("ENDED " + this.getClass().getSimpleName() + " for jobId=" + this.jobId);
        return this.ret;
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        this.eagerVerifyPrecondition();
    }

    @Override
    protected void eagerLoadState() throws CommandException {
        this.loadState();
    }

    @Override
    protected void eagerVerifyPrecondition() throws CommandException, PreconditionException {
        if (this.getJob().getStatus() == Job.Status.KILLED || this.getJob().getStatus() == Job.Status.FAILED || this.getJob().getStatus() == Job.Status.PREP || this.getJob().getStatus() == Job.Status.PREPPAUSED || this.getJob().getStatus() == Job.Status.PREPSUSPENDED) {
            this.getLog().warn("RerunCommand is not able to run because job status=" + this.getJob().getStatus() + ", jobid=" + this.getJob().getId());
            throw new PreconditionException(ErrorCode.E1100, "Not able to rerun the job Id= " + this.getJob().getId() + ". job is in wrong state= " + this.getJob().getStatus());
        }
    }

    public Job.Status getPrevStatus() {
        if (this.prevStatus != null) {
            return this.prevStatus;
        }
        return this.job.getStatus();
    }
}

