/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.bundle;

import org.apache.oozie.BundleJobBean;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.UnpauseTransitionXCommand;
import org.apache.oozie.executor.jpa.BundleJobUpdateJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.LogUtils;

public class BundleUnpauseXCommand
extends UnpauseTransitionXCommand {
    private BundleJobBean bundleJob;
    private JPAService jpaService = Services.get().get(JPAService.class);

    public BundleUnpauseXCommand(BundleJobBean bundleJob) {
        super("bundle_unpause", "bundle_unpause", 1);
        this.bundleJob = bundleJob;
    }

    @Override
    protected String getEntityKey() {
        return this.bundleJob.getId();
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    public void loadState() throws CommandException {
        LogUtils.setLogInfo(this.bundleJob, this.logInfo);
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }

    @Override
    public void notifyParent() {
    }

    @Override
    public Job getJob() {
        return this.bundleJob;
    }

    @Override
    public void updateJob() throws CommandException {
        try {
            this.jpaService.execute(new BundleJobUpdateJPAExecutor(this.bundleJob));
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
    }

    @Override
    public void unpauseChildren() throws CommandException {
    }
}

