/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.sql.Timestamp;
import java.util.Date;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.XException;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.coord.CoordinatorXCommand;
import org.apache.oozie.executor.jpa.CoordActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionUpdateJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobGetJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.InstrumentUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.db.SLADbOperations;

public class CoordActionCheckXCommand
extends CoordinatorXCommand<Void> {
    private String actionId;
    private int actionCheckDelay;
    private CoordinatorActionBean coordAction = null;
    private JPAService jpaService = null;

    public CoordActionCheckXCommand(String actionId, int actionCheckDelay) {
        super("coord_action_check", "coord_action_check", 0);
        this.actionId = ParamChecker.notEmpty(actionId, "actionId");
        this.actionCheckDelay = actionCheckDelay;
    }

    @Override
    protected Void execute() throws CommandException {
        try {
            InstrumentUtils.incrJobCounter(this.getName(), 1, this.getInstrumentation());
            WorkflowJobBean wf = this.jpaService.execute(new WorkflowJobGetJPAExecutor(this.coordAction.getExternalId()));
            SLAEvent.Status slaStatus = null;
            if (wf.getStatus() == WorkflowJob.Status.SUCCEEDED) {
                this.coordAction.setStatus(CoordinatorAction.Status.SUCCEEDED);
                slaStatus = SLAEvent.Status.SUCCEEDED;
            } else if (wf.getStatus() == WorkflowJob.Status.FAILED) {
                this.coordAction.setStatus(CoordinatorAction.Status.FAILED);
                slaStatus = SLAEvent.Status.FAILED;
            } else if (wf.getStatus() == WorkflowJob.Status.KILLED) {
                this.coordAction.setStatus(CoordinatorAction.Status.KILLED);
                slaStatus = SLAEvent.Status.KILLED;
            } else {
                this.LOG.warn("Unexpected workflow " + wf.getId() + " STATUS " + wf.getStatus());
                this.coordAction.setLastModifiedTime(new Date());
                this.jpaService.execute(new CoordActionUpdateJPAExecutor(this.coordAction));
                return null;
            }
            this.LOG.debug("Updating Coordintaor actionId :" + this.coordAction.getId() + "status to =" + this.coordAction.getStatus());
            this.coordAction.setLastModifiedTime(new Date());
            this.jpaService.execute(new CoordActionUpdateJPAExecutor(this.coordAction));
            if (slaStatus != null) {
                SLADbOperations.writeStausEvent(this.coordAction.getSlaXml(), this.coordAction.getId(), slaStatus, SLAEvent.SlaAppType.COORDINATOR_ACTION, this.LOG);
            }
        }
        catch (XException ex) {
            this.LOG.warn((Object)"CoordActionCheckCommand Failed ", ex);
            throw new CommandException(ex);
        }
        return null;
    }

    @Override
    protected String getEntityKey() {
        return this.actionId;
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            this.jpaService = Services.get().get(JPAService.class);
            if (this.jpaService == null) {
                throw new CommandException(ErrorCode.E0610, new Object[0]);
            }
            this.coordAction = this.jpaService.execute(new CoordActionGetJPAExecutor(this.actionId));
            LogUtils.setLogInfo(this.coordAction, this.logInfo);
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        Timestamp actionCheckTs = new Timestamp(System.currentTimeMillis() - (long)(this.actionCheckDelay * 1000));
        Timestamp cactionLmt = this.coordAction.getLastModifiedTimestamp();
        if (cactionLmt.after(actionCheckTs)) {
            throw new PreconditionException(ErrorCode.E1100, "The coord action :" + this.actionId + " has been udated. Ignore CoordActionCheckCommand!");
        }
        if (this.coordAction.getStatus().equals((Object)CoordinatorAction.Status.SUCCEEDED) || this.coordAction.getStatus().equals((Object)CoordinatorAction.Status.FAILED) || this.coordAction.getStatus().equals((Object)CoordinatorAction.Status.KILLED)) {
            throw new PreconditionException(ErrorCode.E1100, new Object[0]);
        }
    }
}

