/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.List;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordActionStartCommand;
import org.apache.oozie.command.coord.CoordinatorCommand;
import org.apache.oozie.store.CoordinatorStore;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.util.XLog;

public class CoordActionReadyCommand
extends CoordinatorCommand<Void> {
    private String jobId;
    private final XLog log = XLog.getLog(this.getClass());

    public CoordActionReadyCommand(String id) {
        super("coord_action_ready", "coord_action_ready", 1, 1);
        this.jobId = id;
    }

    @Override
    protected Void call(CoordinatorStore store) throws StoreException, CommandException {
        int numActionsToStart = -1;
        CoordinatorJobBean coordJob = (CoordinatorJobBean)store.getEntityManager().find(CoordinatorJobBean.class, (Object)this.jobId);
        this.setLogInfo(coordJob);
        String jobExecution = coordJob.getExecution();
        int jobConcurrency = coordJob.getConcurrency();
        if (jobConcurrency >= 0) {
            int numRunningJobs = store.getCoordinatorRunningActionsCount(this.jobId);
            numActionsToStart = jobConcurrency - numRunningJobs;
            if (numActionsToStart < 0) {
                numActionsToStart = 0;
            }
            this.log.debug("concurrency=" + jobConcurrency + ", execution=" + jobExecution + ", numRunningJobs=" + numRunningJobs + ", numLeftover=" + numActionsToStart);
            if (numActionsToStart == 0) {
                this.log.warn("No actions to start! for jobId=" + this.jobId);
                return null;
            }
        }
        List<CoordinatorActionBean> actions = store.getCoordinatorActionsForJob(this.jobId, numActionsToStart, jobExecution);
        this.log.debug("Number of READY actions = " + actions.size());
        String user = coordJob.getUser();
        String authToken = coordJob.getAuthToken();
        int counter = 0;
        for (CoordinatorActionBean action : actions) {
            if (numActionsToStart >= 0 && counter >= numActionsToStart) break;
            this.log.debug("Set status to SUBMITTED for id: " + action.getId());
            action.setStatus(CoordinatorAction.Status.SUBMITTED);
            this.queueCallable(new CoordActionStartCommand(action.getId(), user, authToken), 100L);
            store.updateCoordinatorAction(action);
            ++counter;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void execute(CoordinatorStore store) throws StoreException, CommandException {
        this.log.info("STARTED CoordActionReadyCommand for jobId=" + this.jobId);
        try {
            if (this.lock(this.jobId)) {
                this.call(store);
            } else {
                this.queueCallable(new CoordActionReadyCommand(this.jobId), 30000L);
                this.log.warn("CoordActionReadyCommand lock was not acquired - failed jobId=" + this.jobId + ". Requeing the same.");
            }
        }
        catch (InterruptedException e) {
            this.queueCallable(new CoordActionReadyCommand(this.jobId), 30000L);
            this.log.warn("CoordActionReadyCommand lock acquiring failed with exception " + e.getMessage() + " for jobId=" + this.jobId + " Requeing the same.");
        }
        finally {
            this.log.info("ENDED CoordActionReadyCommand for jobId=" + this.jobId);
        }
        return null;
    }
}

