/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.List;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.coord.CoordActionStartXCommand;
import org.apache.oozie.command.coord.CoordinatorXCommand;
import org.apache.oozie.executor.jpa.CoordActionUpdateJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetReadyActionsJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetRunningActionsCountJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.XLog;

public class CoordActionReadyXCommand
extends CoordinatorXCommand<Void> {
    private final String jobId;
    private final XLog log = this.getLog();
    private CoordinatorJobBean coordJob = null;
    private JPAService jpaService = null;

    public CoordActionReadyXCommand(String id) {
        super("coord_action_ready", "coord_action_ready", 1);
        this.jobId = id;
    }

    @Override
    protected Void execute() throws CommandException {
        List<CoordinatorActionBean> actions;
        int numActionsToStart = -1;
        String jobExecution = this.coordJob.getExecution();
        int jobConcurrency = this.coordJob.getConcurrency();
        if (jobConcurrency >= 0) {
            int numRunningJobs;
            try {
                numRunningJobs = this.jpaService.execute(new CoordJobGetRunningActionsCountJPAExecutor(this.jobId));
            }
            catch (JPAExecutorException je) {
                throw new CommandException(je);
            }
            numActionsToStart = jobConcurrency - numRunningJobs;
            if (numActionsToStart < 0) {
                numActionsToStart = 0;
            }
            this.log.debug("concurrency=" + jobConcurrency + ", execution=" + jobExecution + ", numRunningJobs=" + numRunningJobs + ", numLeftover=" + numActionsToStart);
            if (numActionsToStart == 0) {
                this.log.warn("No actions to start! for jobId=" + this.jobId);
                return null;
            }
        }
        try {
            actions = this.jpaService.execute(new CoordJobGetReadyActionsJPAExecutor(this.jobId, numActionsToStart, jobExecution));
        }
        catch (JPAExecutorException je) {
            throw new CommandException(je);
        }
        this.log.debug("Number of READY actions = " + actions.size());
        String user = this.coordJob.getUser();
        String authToken = this.coordJob.getAuthToken();
        int counter = 0;
        for (CoordinatorActionBean action : actions) {
            if (numActionsToStart >= 0 && counter >= numActionsToStart) break;
            this.log.debug("Set status to SUBMITTED for id: " + action.getId());
            action.setStatus(CoordinatorAction.Status.SUBMITTED);
            this.queue(new CoordActionStartXCommand(action.getId(), user, authToken), 100L);
            try {
                this.jpaService.execute(new CoordActionUpdateJPAExecutor(action));
            }
            catch (JPAExecutorException je) {
                throw new CommandException(je);
            }
            ++counter;
        }
        return null;
    }

    @Override
    protected String getEntityKey() {
        return this.jobId;
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected void loadState() throws CommandException {
        this.jpaService = Services.get().get(JPAService.class);
        if (this.jpaService == null) {
            throw new CommandException(ErrorCode.E0610, new Object[0]);
        }
        try {
            this.coordJob = this.jpaService.execute(new CoordJobGetJPAExecutor(this.jobId));
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
        LogUtils.setLogInfo(this.coordJob, this.logInfo);
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (this.coordJob.getStatus() != Job.Status.RUNNING && this.coordJob.getStatus() != Job.Status.SUCCEEDED && this.coordJob.getStatus() != Job.Status.PAUSED && this.coordJob.getStatus() != Job.Status.PAUSEDWITHERROR) {
            throw new PreconditionException(ErrorCode.E1100, "[" + this.jobId + "]::CoordActionReady:: Ignoring job. Coordinator job is not in RUNNING state, but state=" + this.coordJob.getStatus());
        }
    }
}

