/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordActionNotification;
import org.apache.oozie.command.coord.CoordinatorCommand;
import org.apache.oozie.store.CoordinatorStore;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.util.XLog;

public class CoordActionTimeOut
extends CoordinatorCommand<Void> {
    private CoordinatorActionBean actionBean;
    private final XLog log = XLog.getLog(this.getClass());

    public CoordActionTimeOut(CoordinatorActionBean actionBean) {
        super("coord_action_timeout", "coord_action_timeout", 1, 1);
        this.actionBean = actionBean;
    }

    @Override
    protected Void call(CoordinatorStore store) throws StoreException, CommandException {
        this.actionBean = (CoordinatorActionBean)store.getEntityManager().find(CoordinatorActionBean.class, (Object)this.actionBean.getId());
        if (this.actionBean.getStatus() == CoordinatorAction.Status.WAITING) {
            this.actionBean.setStatus(CoordinatorAction.Status.TIMEDOUT);
            this.queueCallable(new CoordActionNotification(this.actionBean), 100L);
            store.updateCoordinatorAction(this.actionBean);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void execute(CoordinatorStore store) throws StoreException, CommandException {
        String jobId = this.actionBean.getJobId();
        this.setLogInfo(this.actionBean);
        this.log.info("STARTED CoordinatorActionTimeOut for Action Id " + this.actionBean.getId() + " of job Id :" + this.actionBean.getJobId() + ". Timeout value is " + this.actionBean.getTimeOut() + " mins");
        try {
            if (this.lock(jobId)) {
                this.call(store);
            } else {
                this.queueCallable(new CoordActionTimeOut(this.actionBean), 30000L);
                this.log.warn("CoordinatorActionTimeOut lock was not acquired -  failed " + jobId + ". Requeing the same.");
            }
        }
        catch (InterruptedException e) {
            this.queueCallable(new CoordActionTimeOut(this.actionBean), 30000L);
            this.log.warn("CoordinatorActionTimeOut lock acquiring failed  with exception " + e.getMessage() + " for job id " + jobId + ". Requeing the same.");
        }
        finally {
            this.log.info("ENDED CoordinatorActionTimeOut for Action Id " + this.actionBean.getId());
        }
        return null;
    }
}

