/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.XException;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordActionReadyCommand;
import org.apache.oozie.command.coord.CoordinatorCommand;
import org.apache.oozie.store.CoordinatorStore;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.db.SLADbOperations;

public class CoordActionUpdateCommand
extends CoordinatorCommand<Void> {
    private final XLog log = XLog.getLog(this.getClass());
    private WorkflowJobBean workflow;
    private CoordinatorActionBean caction = null;

    public CoordActionUpdateCommand(WorkflowJobBean workflow) {
        super("coord-action-update", "coord-action-update", 1, 4);
        this.workflow = workflow;
    }

    @Override
    protected Void call(CoordinatorStore cstore) throws StoreException, CommandException {
        try {
            if (this.workflow.getStatus() == WorkflowJob.Status.RUNNING || this.workflow.getStatus() == WorkflowJob.Status.SUSPENDED) {
                cstore.updateCoordinatorAction(this.caction);
                return null;
            }
            SLAEvent.Status slaStatus = null;
            if (this.caction != null) {
                if (this.workflow.getStatus() == WorkflowJob.Status.SUCCEEDED) {
                    this.caction.setStatus(CoordinatorAction.Status.SUCCEEDED);
                    slaStatus = SLAEvent.Status.SUCCEEDED;
                } else if (this.workflow.getStatus() == WorkflowJob.Status.FAILED) {
                    this.caction.setStatus(CoordinatorAction.Status.FAILED);
                    slaStatus = SLAEvent.Status.FAILED;
                } else if (this.workflow.getStatus() == WorkflowJob.Status.KILLED) {
                    this.caction.setStatus(CoordinatorAction.Status.KILLED);
                    slaStatus = SLAEvent.Status.KILLED;
                } else {
                    this.log.warn("Unexpected workflow " + this.workflow.getId() + " STATUS " + this.workflow.getStatus());
                    cstore.updateCoordinatorAction(this.caction);
                    return null;
                }
                this.log.info("Updating Coordintaor id :" + this.caction.getId() + "status to =" + this.caction.getStatus());
                cstore.updateCoordinatorAction(this.caction);
                if (slaStatus != null) {
                    SLADbOperations.writeStausEvent(this.caction.getSlaXml(), this.caction.getId(), cstore, slaStatus, SLAEvent.SlaAppType.COORDINATOR_ACTION);
                }
                this.queueCallable(new CoordActionReadyCommand(this.caction.getJobId()));
            }
        }
        catch (XException ex) {
            this.log.warn("CoordActionUpdate Failed ", ex.getMessage());
            throw new CommandException(ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void execute(CoordinatorStore store) throws StoreException, CommandException {
        this.log.info("STARTED CoordActionUpdateCommand for wfId=" + this.workflow.getId());
        this.caction = store.getCoordinatorActionForExternalId(this.workflow.getId());
        if (this.caction == null) {
            this.log.info("ENDED CoordActionUpdateCommand for wfId=" + this.workflow.getId() + ", coord action is null");
            return null;
        }
        this.setLogInfo(this.caction);
        String jobId = this.caction.getJobId();
        try {
            if (this.lock(jobId)) {
                this.call(store);
            } else {
                this.queueCallable(new CoordActionUpdateCommand(this.workflow), 30000L);
                this.log.warn("CoordActionUpdateCommand lock was not acquired - failed JobId=" + jobId + ", wfId=" + this.workflow.getId() + ". Requeing the same.");
            }
        }
        catch (InterruptedException e) {
            this.queueCallable(new CoordActionUpdateCommand(this.workflow), 30000L);
            this.log.warn("CoordActionUpdateCommand lock acquiring failed with exception " + e.getMessage() + " for jobId=" + jobId + ", wfId=" + this.workflow.getId() + ". Requeing the same.");
        }
        finally {
            this.log.info("ENDED CoordActionUpdateCommand for wfId=" + this.workflow.getId() + ", jobId=" + jobId);
        }
        return null;
    }
}

