/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.sql.Timestamp;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordActionMaterializeCommand;
import org.apache.oozie.command.coord.CoordinatorCommand;
import org.apache.oozie.store.CoordinatorStore;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.XLog;

public class CoordJobMatLookupCommand
extends CoordinatorCommand<Void> {
    private static final int LOOKAHEAD_WINDOW = 300;
    private final XLog log = XLog.getLog(this.getClass());
    private int materializationWindow;
    private String jobId;

    public CoordJobMatLookupCommand(String id, int materializationWindow) {
        super("materialization_lookup", "materialization_lookup", 1, 1);
        this.jobId = id;
        this.materializationWindow = materializationWindow;
    }

    @Override
    protected Void call(CoordinatorStore store) throws StoreException, CommandException {
        Timestamp jobEndTime;
        CoordinatorJobBean coordJob = (CoordinatorJobBean)store.getEntityManager().find(CoordinatorJobBean.class, (Object)this.jobId);
        this.setLogInfo(coordJob);
        if (coordJob.getStatus() != Job.Status.PREP && coordJob.getStatus() != Job.Status.RUNNING) {
            this.log.debug("CoordJobMatLookupCommand for jobId=" + this.jobId + " job is not in PREP or RUNNING but in " + coordJob.getStatus());
            return null;
        }
        if (coordJob.getNextMaterializedTimestamp() != null && coordJob.getNextMaterializedTimestamp().compareTo(coordJob.getEndTimestamp()) >= 0) {
            this.log.debug("CoordJobMatLookupCommand for jobId=" + this.jobId + " job is already materialized");
            return null;
        }
        if (coordJob.getNextMaterializedTimestamp() != null && coordJob.getNextMaterializedTimestamp().compareTo(new Timestamp(System.currentTimeMillis())) >= 0) {
            this.log.debug("CoordJobMatLookupCommand for jobId=" + this.jobId + " job is already materialized");
            return null;
        }
        Timestamp startTime = coordJob.getNextMaterializedTimestamp();
        if (startTime == null && (startTime = coordJob.getStartTimestamp()).after(new Timestamp(System.currentTimeMillis() + 300000L))) {
            this.log.debug("CoordJobMatLookupCommand for jobId=" + this.jobId + " job's start time is not reached yet - nothing to materialize");
            return null;
        }
        long startTimeMilli = startTime.getTime();
        long endTimeMilli = startTimeMilli + (long)(this.materializationWindow * 1000);
        Timestamp endTime = new Timestamp(endTimeMilli);
        if (endTime.compareTo(jobEndTime = coordJob.getEndTimestamp()) > 0) {
            endTime = jobEndTime;
        }
        coordJob.setStatus(Job.Status.PREMATER);
        store.updateCoordinatorJobStatus(coordJob);
        this.log.debug("Materializing coord job id=" + this.jobId + ", start=" + DateUtils.toDate(startTime) + ", end=" + DateUtils.toDate(endTime) + ", window=" + this.materializationWindow + ", status=PREMATER");
        this.queueCallable(new CoordActionMaterializeCommand(this.jobId, DateUtils.toDate(startTime), DateUtils.toDate(endTime)), 100L);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void execute(CoordinatorStore store) throws StoreException, CommandException {
        this.log.info("STARTED CoordJobMatLookupCommand jobId=" + this.jobId + ", materializationWindow=" + this.materializationWindow);
        try {
            if (this.lock(this.jobId)) {
                this.call(store);
            } else {
                this.queueCallable(new CoordJobMatLookupCommand(this.jobId, this.materializationWindow), 30000L);
                this.log.warn("CoordJobMatLookupCommand lock was not acquired - failed jobId=" + this.jobId + ". Requeing the same.");
            }
        }
        catch (InterruptedException e) {
            this.queueCallable(new CoordJobMatLookupCommand(this.jobId, this.materializationWindow), 30000L);
            this.log.warn("CoordJobMatLookupCommand lock acquiring failed with exception " + e.getMessage() + " for jobId=" + this.jobId + " Requeing the same.");
        }
        finally {
            this.log.info("ENDED CoordJobMatLookupCommand jobId=" + this.jobId + ", materializationWindow=" + this.materializationWindow);
        }
        return null;
    }
}

