/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.util.Date;
import javax.servlet.jsp.el.ELException;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.FaultInjection;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.XException;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordActionUpdateCommand;
import org.apache.oozie.command.wf.ActionCommand;
import org.apache.oozie.command.wf.ActionEndCommand;
import org.apache.oozie.command.wf.NotificationCommand;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.store.WorkflowStore;
import org.apache.oozie.util.ELEvaluationException;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.util.db.SLADbOperations;
import org.jdom.JDOMException;

public class ActionStartCommand
extends ActionCommand<Void> {
    public static final String EL_ERROR = "EL_ERROR";
    public static final String EL_EVAL_ERROR = "EL_EVAL_ERROR";
    public static final String COULD_NOT_START = "COULD_NOT_START";
    public static final String START_DATA_MISSING = "START_DATA_MISSING";
    public static final String EXEC_DATA_MISSING = "EXEC_DATA_MISSING";
    private String id;
    private String jobId;

    public ActionStartCommand(String id, String type) {
        super("action.start", type, 0);
        this.id = id;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Void call(WorkflowStore store) throws StoreException, CommandException {
        WorkflowJobBean workflow = store.getWorkflow(this.jobId, false);
        this.setLogInfo(workflow);
        WorkflowActionBean action = store.getAction(this.id, false);
        XLog.getLog(this.getClass()).warn(1, "[***" + action.getId() + "***]" + "In call()....status=" + action.getStatusStr(), new Object[0]);
        this.setLogInfo(action);
        if (!action.isPending() || action.getStatus() != WorkflowAction.Status.PREP && action.getStatus() != WorkflowAction.Status.START_RETRY && action.getStatus() != WorkflowAction.Status.START_MANUAL) return null;
        if (workflow.getStatus() == WorkflowJob.Status.RUNNING) {
            ActionExecutor executor = Services.get().get(ActionService.class).getExecutor(action.getType());
            Configuration conf = workflow.getWorkflowInstance().getConf();
            int maxRetries = conf.getInt("oozie.wf.action.max.retries", executor.getMaxRetries());
            long retryInterval = conf.getLong("oozie.wf.action.retry.interval", executor.getRetryInterval());
            executor.setMaxRetries(maxRetries);
            executor.setRetryInterval(retryInterval);
            if (executor == null) throw new CommandException(ErrorCode.E0802, action.getType());
            ActionCommand.ActionExecutorContext context = null;
            try {
                boolean isRetry = false;
                if (action.getStatus() == WorkflowAction.Status.START_RETRY || action.getStatus() == WorkflowAction.Status.START_MANUAL) {
                    isRetry = true;
                }
                context = new ActionCommand.ActionExecutorContext(workflow, action, isRetry);
                try {
                    String tmpActionConf = XmlUtils.removeComments(action.getConf());
                    String actionConf = context.getELEvaluator().evaluate(tmpActionConf, String.class);
                    action.setConf(actionConf);
                    XLog.getLog(this.getClass()).debug("Start, name [{0}] type [{1}] configuration{E}{E}{2}{E}", action.getName(), action.getType(), actionConf);
                }
                catch (ELEvaluationException ex) {
                    throw new ActionExecutorException(ActionExecutorException.ErrorType.TRANSIENT, EL_EVAL_ERROR, ex.getMessage(), ex);
                }
                catch (ELException ex) {
                    context.setErrorInfo(EL_ERROR, ex.getMessage());
                    XLog.getLog(this.getClass()).warn("ELException in ActionStartCommand ", new Object[]{ex.getMessage(), ex});
                    this.handleError(context, store, workflow, action);
                    return null;
                }
                catch (JDOMException je) {
                    context.setErrorInfo("ParsingError", je.getMessage());
                    XLog.getLog(this.getClass()).warn("JDOMException in ActionStartCommand ", new Object[]{je.getMessage(), je});
                    this.handleError(context, store, workflow, action);
                    return null;
                }
                catch (Exception ex) {
                    context.setErrorInfo(EL_ERROR, ex.getMessage());
                    XLog.getLog(this.getClass()).warn("Exception in ActionStartCommand ", ex.getMessage(), ex);
                    this.handleError(context, store, workflow, action);
                    return null;
                }
                action.setErrorInfo(null, null);
                this.incrActionCounter(action.getType(), 1);
                Instrumentation.Cron cron = new Instrumentation.Cron();
                cron.start();
                executor.start(context, action);
                cron.stop();
                FaultInjection.activate("org.apache.oozie.command.SkipCommitFaultInjection");
                this.addActionCron(action.getType(), cron);
                action.setRetries(0);
                if (action.isExecutionComplete()) {
                    if (!context.isExecuted()) {
                        XLog.getLog(this.getClass()).warn(4, "Action Completed, ActionExecutor [{0}] must call setExecutionData()", executor.getType());
                        action.setErrorInfo(EXEC_DATA_MISSING, "Execution Complete, but Execution Data Missing from Action");
                        this.failJob(context);
                        store.updateAction(action);
                        store.updateWorkflow(workflow);
                        return null;
                    }
                    action.setPending();
                    this.queueCallable(new ActionEndCommand(action.getId(), action.getType()));
                } else {
                    if (!context.isStarted()) {
                        XLog.getLog(this.getClass()).warn(4, "Action Started, ActionExecutor [{0}] must call setStartData()", executor.getType());
                        action.setErrorInfo(START_DATA_MISSING, "Execution Started, but Start Data Missing from Action");
                        this.failJob(context);
                        store.updateAction(action);
                        store.updateWorkflow(workflow);
                        return null;
                    }
                    this.queueCallable(new NotificationCommand(workflow, action));
                }
                XLog.getLog(this.getClass()).warn(1, "[***" + action.getId() + "***]" + "Action status=" + action.getStatusStr(), new Object[0]);
                store.updateAction(action);
                store.updateWorkflow(workflow);
                SLADbOperations.writeStausEvent(action.getSlaXml(), action.getId(), store, SLAEvent.Status.STARTED, SLAEvent.SlaAppType.WORKFLOW_ACTION);
                XLog.getLog(this.getClass()).warn(1, "[***" + action.getId() + "***]" + "Action updated in DB!", new Object[0]);
                return null;
            }
            catch (ActionExecutorException ex) {
                XLog.getLog(this.getClass()).warn("Error starting action [{0}]. ErrorType [{1}], ErrorCode [{2}], Message [{3}]", new Object[]{action.getName(), ex.getErrorType(), ex.getErrorCode(), ex.getMessage(), ex});
                action.setErrorInfo(ex.getErrorCode(), ex.getMessage());
                switch (ex.getErrorType()) {
                    case TRANSIENT: {
                        if (this.handleTransient(context, executor, WorkflowAction.Status.START_RETRY)) break;
                        this.handleNonTransient(store, context, executor, WorkflowAction.Status.START_MANUAL);
                        action.setPendingAge(new Date());
                        action.setRetries(0);
                        action.setStartTime(null);
                        break;
                    }
                    case NON_TRANSIENT: {
                        this.handleNonTransient(store, context, executor, WorkflowAction.Status.START_MANUAL);
                        break;
                    }
                    case ERROR: {
                        this.handleError(context, executor, WorkflowAction.Status.ERROR.toString(), true, WorkflowAction.Status.DONE);
                        break;
                    }
                    case FAILED: {
                        try {
                            this.failJob(context);
                            this.queueCallable(new CoordActionUpdateCommand(workflow));
                            SLADbOperations.writeStausEvent(action.getSlaXml(), action.getId(), store, SLAEvent.Status.FAILED, SLAEvent.SlaAppType.WORKFLOW_ACTION);
                            SLADbOperations.writeStausEvent(workflow.getSlaXml(), workflow.getId(), store, SLAEvent.Status.FAILED, SLAEvent.SlaAppType.WORKFLOW_JOB);
                            break;
                        }
                        catch (XException x) {
                            XLog.getLog(this.getClass()).warn("ActionStartCommand - case:FAILED ", x.getMessage());
                        }
                    }
                }
                store.updateAction(action);
                store.updateWorkflow(workflow);
            }
            return null;
        }
        XLog.getLog(this.getClass()).warn("Job state is not {0}. Skipping Action Execution", WorkflowJob.Status.RUNNING.toString());
        return null;
    }

    private void handleError(ActionCommand.ActionExecutorContext context, WorkflowStore store, WorkflowJobBean workflow, WorkflowActionBean action) throws CommandException, StoreException {
        this.failJob(context);
        store.updateAction(action);
        store.updateWorkflow(workflow);
        SLADbOperations.writeStausEvent(action.getSlaXml(), action.getId(), store, SLAEvent.Status.FAILED, SLAEvent.SlaAppType.WORKFLOW_ACTION);
        SLADbOperations.writeStausEvent(workflow.getSlaXml(), workflow.getId(), store, SLAEvent.Status.FAILED, SLAEvent.SlaAppType.WORKFLOW_JOB);
        this.queueCallable(new CoordActionUpdateCommand(workflow));
    }

    @Override
    protected Void execute(WorkflowStore store) throws CommandException, StoreException {
        try {
            XLog.getLog(this.getClass()).debug("STARTED ActionStartCommand for wf actionId=" + this.id);
            this.jobId = Services.get().get(UUIDService.class).getId(this.id);
            if (this.lock(this.jobId)) {
                this.call(store);
            } else {
                this.queueCallable(new ActionStartCommand(this.id, this.getType()), 30000L);
                XLog.getLog(this.getClass()).warn("ActionStartCommand lock was not acquired - failed {0}", this.id);
            }
        }
        catch (InterruptedException e) {
            this.queueCallable(new ActionStartCommand(this.id, this.getType()), 30000L);
            XLog.getLog(this.getClass()).warn("ActionStartCommand lock was not acquired - interrupted exception failed {0}", this.id);
        }
        XLog.getLog(this.getClass()).debug("ENDED ActionStartCommand for wf actionId=" + this.id + ", jobId=" + this.jobId);
        return null;
    }
}

