/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.wf.WorkflowXCommand;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowInfoWithActionsSubsetGetJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ParamChecker;

public class JobXCommand
extends WorkflowXCommand<WorkflowJobBean> {
    private final String id;
    private final int start = 1;
    private final int len = Integer.MAX_VALUE;
    private WorkflowJobBean workflow;

    public JobXCommand(String id) {
        this(id, 1, Integer.MAX_VALUE);
    }

    public JobXCommand(String id, int start, int length) {
        super("job.info", "job.info", 1, true);
        this.id = ParamChecker.notEmpty(id, "id");
    }

    @Override
    protected WorkflowJobBean execute() throws CommandException {
        try {
            JPAService jpaService = Services.get().get(JPAService.class);
            if (jpaService == null) {
                throw new CommandException(ErrorCode.E0610, this.id);
            }
            this.workflow = jpaService.execute(new WorkflowInfoWithActionsSubsetGetJPAExecutor(this.id, this.start, this.len));
            this.workflow.setConsoleUrl(JobXCommand.getJobConsoleUrl(this.id));
        }
        catch (JPAExecutorException ex) {
            throw new CommandException(ex);
        }
        catch (Exception ex) {
            throw new CommandException(ErrorCode.E0603, ex);
        }
        return this.workflow;
    }

    static String getJobConsoleUrl(String jobId) {
        String consoleUrl = Services.get().getConf().get("oozie.JobCommand.job.console.url", null);
        return consoleUrl != null ? consoleUrl + jobId : null;
    }

    @Override
    protected String getEntityKey() {
        return this.id;
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    protected void loadState() throws CommandException {
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }
}

