/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.io.StringReader;
import java.util.Date;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordActionUpdateCommand;
import org.apache.oozie.command.wf.ActionKillCommand;
import org.apache.oozie.command.wf.ActionStartCommand;
import org.apache.oozie.command.wf.NotificationCommand;
import org.apache.oozie.command.wf.SubmitCommand;
import org.apache.oozie.command.wf.WorkflowCommand;
import org.apache.oozie.service.ELService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.service.WorkflowStoreService;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.store.WorkflowStore;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.util.db.SLADbOperations;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.WorkflowInstance;
import org.jdom.Element;
import org.jdom.Namespace;

public class SignalCommand
extends WorkflowCommand<Void> {
    protected static final String INSTR_SUCCEEDED_JOBS_COUNTER_NAME = "succeeded";
    private String jobId;
    private String actionId;

    protected SignalCommand(String name, int priority, String jobId) {
        super(name, name, priority, 1);
        this.jobId = ParamChecker.notEmpty(jobId, "jobId");
    }

    public SignalCommand(String jobId, String actionId) {
        super("signal", "signal", 1, 1);
        this.jobId = ParamChecker.notEmpty(jobId, "jobId");
        this.actionId = ParamChecker.notEmpty(actionId, "actionId");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Void call(WorkflowStore store) throws CommandException, StoreException {
        WorkflowJobBean workflow = store.getWorkflow(this.jobId, false);
        this.setLogInfo(workflow);
        WorkflowActionBean action = null;
        boolean skipAction = false;
        if (this.actionId != null) {
            action = store.getAction(this.actionId, false);
            this.setLogInfo(action);
        }
        if (action == null || action.isComplete() && action.isPending()) {
            try {
                if (workflow.getStatus() == WorkflowJob.Status.RUNNING || workflow.getStatus() == WorkflowJob.Status.PREP) {
                    boolean completed;
                    WorkflowInstance workflowInstance = workflow.getWorkflowInstance();
                    workflowInstance.setTransientVar("oozie.workflow.workflow.bean", workflow);
                    if (action == null) {
                        if (workflow.getStatus() != WorkflowJob.Status.PREP) throw new CommandException(ErrorCode.E0801, workflow.getId());
                        completed = workflowInstance.start();
                        workflow.setStatus(WorkflowJob.Status.RUNNING);
                        workflow.setStartTime(new Date());
                        workflow.setWorkflowInstance(workflowInstance);
                        SLADbOperations.writeStausEvent(workflow.getSlaXml(), this.jobId, store, SLAEvent.Status.STARTED, SLAEvent.SlaAppType.WORKFLOW_JOB);
                        this.writeSLARegistrationForAllActions(workflowInstance.getApp().getDefinition(), workflow.getUser(), workflow.getGroup(), workflow.getConf(), store);
                        this.queueCallable(new NotificationCommand(workflow));
                    } else {
                        String skipVar = workflowInstance.getVar(action.getName() + "#" + "TO_SKIP");
                        if (skipVar != null) {
                            skipAction = skipVar.equals("true");
                        }
                        completed = workflowInstance.signal(action.getExecutionPath(), action.getSignalValue());
                        workflow.setWorkflowInstance(workflowInstance);
                        action.resetPending();
                        if (!skipAction) {
                            action.setTransition(workflowInstance.getTransition(action.getName()));
                        }
                        store.updateAction(action);
                    }
                    if (completed) {
                        for (String actionToKillId : WorkflowStoreService.getActionsToKill(workflowInstance)) {
                            WorkflowActionBean actionToKill = store.getAction(actionToKillId, false);
                            actionToKill.setPending();
                            actionToKill.setStatus(WorkflowAction.Status.KILLED);
                            store.updateAction(actionToKill);
                            this.queueCallable(new ActionKillCommand(actionToKill.getId(), actionToKill.getType()));
                        }
                        for (String actionToFailId : WorkflowStoreService.getActionsToFail(workflowInstance)) {
                            WorkflowActionBean actionToFail = store.getAction(actionToFailId, false);
                            actionToFail.resetPending();
                            actionToFail.setStatus(WorkflowAction.Status.FAILED);
                            SLADbOperations.writeStausEvent(action.getSlaXml(), action.getId(), store, SLAEvent.Status.FAILED, SLAEvent.SlaAppType.WORKFLOW_ACTION);
                            store.updateAction(actionToFail);
                        }
                        workflow.setStatus(WorkflowJob.Status.valueOf((String)workflowInstance.getStatus().toString()));
                        workflow.setEndTime(new Date());
                        workflow.setWorkflowInstance(workflowInstance);
                        SLAEvent.Status slaStatus = SLAEvent.Status.SUCCEEDED;
                        switch (workflow.getStatus()) {
                            case SUCCEEDED: {
                                slaStatus = SLAEvent.Status.SUCCEEDED;
                                break;
                            }
                            case KILLED: {
                                slaStatus = SLAEvent.Status.KILLED;
                                break;
                            }
                            case FAILED: {
                                slaStatus = SLAEvent.Status.FAILED;
                                break;
                            }
                        }
                        SLADbOperations.writeStausEvent(workflow.getSlaXml(), this.jobId, store, slaStatus, SLAEvent.SlaAppType.WORKFLOW_JOB);
                        this.queueCallable(new NotificationCommand(workflow));
                        if (workflow.getStatus() == WorkflowJob.Status.SUCCEEDED) {
                            this.incrJobCounter(INSTR_SUCCEEDED_JOBS_COUNTER_NAME, 1);
                        }
                    } else {
                        for (WorkflowActionBean newAction : WorkflowStoreService.getStartedActions(workflowInstance)) {
                            String skipVar = workflowInstance.getVar(newAction.getName() + "#" + "TO_SKIP");
                            boolean skipNewAction = false;
                            if (skipVar != null) {
                                skipNewAction = skipVar.equals("true");
                            }
                            if (skipNewAction) {
                                WorkflowActionBean oldAction = store.getAction(newAction.getId(), false);
                                oldAction.setPending();
                                store.updateAction(oldAction);
                                this.queueCallable(new SignalCommand(this.jobId, oldAction.getId()));
                                continue;
                            }
                            newAction.setPending();
                            String actionSlaXml = this.getActionSLAXml(newAction.getName(), workflowInstance.getApp().getDefinition(), workflow.getConf());
                            newAction.setSlaXml(actionSlaXml);
                            XLog.getLog(this.getClass()).debug("SignalCOmmand: Name: " + newAction.getName() + "Id: " + newAction.getId() + " Authcode:" + newAction.getCred());
                            store.insertAction(newAction);
                            this.queueCallable(new ActionStartCommand(newAction.getId(), newAction.getType()));
                        }
                    }
                    store.updateWorkflow(workflow);
                    XLog.getLog(this.getClass()).debug("Updated the workflow status to " + workflow.getId() + "  status =" + workflow.getStatusStr());
                    if (workflow.getStatus() == WorkflowJob.Status.RUNNING || workflow.getStatus() == WorkflowJob.Status.SUSPENDED) return null;
                    this.queueCallable(new CoordActionUpdateCommand(workflow));
                    return null;
                }
                XLog.getLog(this.getClass()).warn("Workflow not RUNNING, current status [{0}]", workflow.getStatus());
                return null;
            }
            catch (WorkflowException ex) {
                throw new CommandException(ex);
            }
        } else {
            XLog.getLog(this.getClass()).warn("SignalCommand for action id :" + this.actionId + " is already processed. status=" + action.getStatus() + ", Pending=" + action.isPending());
        }
        return null;
    }

    public static ELEvaluator createELEvaluatorForGroup(Configuration conf, String group) {
        ELEvaluator eval = Services.get().get(ELService.class).createEvaluator(group);
        for (Map.Entry entry : conf) {
            eval.setVariable((String)entry.getKey(), entry.getValue());
        }
        return eval;
    }

    private String getActionSLAXml(String actionName, String wfXml, String wfConf) throws CommandException {
        String slaXml = null;
        try {
            Element eWfJob = XmlUtils.parseXml(wfXml);
            for (Element action : eWfJob.getChildren("action", eWfJob.getNamespace())) {
                Element eSla;
                if (!action.getAttributeValue("name").equals(actionName) || (eSla = action.getChild("info", Namespace.getNamespace((String)"uri:oozie:sla:0.1"))) == null) continue;
                slaXml = XmlUtils.prettyPrint(eSla).toString();
                break;
            }
        }
        catch (Exception e) {
            throw new CommandException(ErrorCode.E1004, e.getMessage(), e);
        }
        return slaXml;
    }

    private String resolveSla(Element eSla, Configuration conf) throws CommandException {
        String slaXml = null;
        try {
            ELEvaluator evalSla = SubmitCommand.createELEvaluatorForGroup(conf, "wf-sla-submit");
            slaXml = SubmitCommand.resolveSla(eSla, evalSla);
        }
        catch (Exception e) {
            throw new CommandException(ErrorCode.E1004, e.getMessage(), e);
        }
        return slaXml;
    }

    private void writeSLARegistrationForAllActions(String wfXml, String user, String group, String strConf, WorkflowStore store) throws CommandException {
        try {
            Element eWfJob = XmlUtils.parseXml(wfXml);
            XConfiguration conf = new XConfiguration(new StringReader(strConf));
            for (Element action : eWfJob.getChildren("action", eWfJob.getNamespace())) {
                Element eSla = action.getChild("info", Namespace.getNamespace((String)"uri:oozie:sla:0.1"));
                if (eSla == null) continue;
                String slaXml = this.resolveSla(eSla, conf);
                eSla = XmlUtils.parseXml(slaXml);
                String actionId = Services.get().get(UUIDService.class).generateChildId(this.jobId, action.getAttributeValue("name") + "");
                SLADbOperations.writeSlaRegistrationEvent(eSla, store, actionId, SLAEvent.SlaAppType.WORKFLOW_ACTION, user, group);
            }
        }
        catch (Exception e) {
            throw new CommandException(ErrorCode.E1007, "workflow:Actions " + this.jobId, e);
        }
    }

    @Override
    protected Void execute(WorkflowStore store) throws CommandException, StoreException {
        XLog.getLog(this.getClass()).debug("STARTED SignalCommand for jobid=" + this.jobId + ", actionId=" + this.actionId);
        try {
            if (this.lock(this.jobId)) {
                this.call(store);
            } else {
                this.queueCallable(new SignalCommand(this.jobId, this.actionId), 30000L);
                XLog.getLog(this.getClass()).warn("SignalCommand lock was not acquired - failed {0}", this.jobId);
            }
        }
        catch (InterruptedException e) {
            this.queueCallable(new SignalCommand(this.jobId, this.actionId), 30000L);
            XLog.getLog(this.getClass()).warn("SignalCommand lock not acquired - interrupted exception failed {0}", this.jobId);
        }
        XLog.getLog(this.getClass()).debug("ENDED SignalCommand for jobid=" + this.jobId + ", actionId=" + this.actionId);
        return null;
    }
}

