/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.wf.WorkflowCommand;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.WorkflowAppService;
import org.apache.oozie.service.WorkflowStoreService;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.store.WorkflowStore;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.PropertiesUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.workflow.WorkflowApp;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.WorkflowLib;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public abstract class SubmitHttpCommand
extends WorkflowCommand<String> {
    public static final String USE_SYSTEM_LIBPATH_FOR_MR_PIG_JOBS = "use.system.libpath.for.mapreduce.and.pig.jobs";
    protected static final Set<String> MANDATORY_OOZIE_CONFS = new HashSet<String>();
    protected static final Set<String> OPTIONAL_OOZIE_CONFS = new HashSet<String>();
    private Configuration conf;
    private String authToken;
    private static final Set<String> DISALLOWED_DEFAULT_PROPERTIES;
    private static final Set<String> DISALLOWED_USER_PROPERTIES;

    public SubmitHttpCommand(String name, String type, Configuration conf, String authToken) {
        super(name, type, 1, 1);
        this.conf = ParamChecker.notNull(conf, "conf");
        this.authToken = ParamChecker.notEmpty(authToken, "authToken");
    }

    protected abstract String getWorkflowXml(Configuration var1);

    @Override
    protected String call(WorkflowStore store) throws StoreException, CommandException {
        this.incrJobCounter(1);
        WorkflowAppService wps = Services.get().get(WorkflowAppService.class);
        try {
            WorkflowInstance wfInstance;
            XLog.Info.get().setParameter("TOKEN", this.conf.get("oozie.wf.log.token"));
            String wfXml = this.getWorkflowXml(this.conf);
            XLog.getLog(this.getClass()).debug("workflow xml created on the server side is :\n");
            XLog.getLog(this.getClass()).debug(wfXml);
            WorkflowApp app = wps.parseDef(wfXml);
            if (this.conf.get("oozie.use.system.libpath") == null && Services.get().getConf().getBoolean(USE_SYSTEM_LIBPATH_FOR_MR_PIG_JOBS, false)) {
                this.conf.setBoolean("oozie.use.system.libpath", true);
            }
            XConfiguration protoActionConf = wps.createProtoActionConf(this.conf, this.authToken, false);
            WorkflowLib workflowLib = Services.get().get(WorkflowStoreService.class).getWorkflowLibWithNoDB();
            PropertiesUtils.checkDisallowedProperties(this.conf, DISALLOWED_USER_PROPERTIES);
            XConfiguration resolvedVarsConf = new XConfiguration();
            for (Map.Entry entry : this.conf) {
                resolvedVarsConf.set((String)entry.getKey(), this.conf.get((String)entry.getKey()));
            }
            this.conf = resolvedVarsConf;
            try {
                wfInstance = workflowLib.createInstance(app, this.conf);
            }
            catch (WorkflowException e) {
                throw new StoreException(e);
            }
            Configuration conf = wfInstance.getConf();
            WorkflowJobBean workflow = new WorkflowJobBean();
            workflow.setId(wfInstance.getId());
            workflow.setAppName(app.getName());
            workflow.setAppPath(conf.get("oozie.wf.application.path"));
            workflow.setConf(XmlUtils.prettyPrint(conf).toString());
            workflow.setProtoActionConf(protoActionConf.toXmlString());
            workflow.setCreatedTime(new Date());
            workflow.setLastModifiedTime(new Date());
            workflow.setLogToken(conf.get("oozie.wf.log.token", ""));
            workflow.setStatus(WorkflowJob.Status.PREP);
            workflow.setRun(0);
            workflow.setUser(conf.get("user.name"));
            workflow.setGroup(conf.get("group.name"));
            workflow.setAuthToken(this.authToken);
            workflow.setWorkflowInstance(wfInstance);
            workflow.setExternalId(conf.get("oozie.wf.external.id"));
            this.setLogInfo(workflow);
            store.insertWorkflow(workflow);
            return workflow.getId();
        }
        catch (WorkflowException ex) {
            throw new CommandException(ex);
        }
        catch (Exception ex) {
            throw new CommandException(ErrorCode.E0803, ex);
        }
    }

    private static void addSection(Element X, Namespace ns, String filesStr, String tagName) {
        if (filesStr != null) {
            String[] files;
            for (String f : files = filesStr.split(",")) {
                Element tagElement = new Element(tagName, ns);
                if (f.contains("#")) {
                    tagElement.addContent(f);
                } else {
                    String filename = f.substring(f.lastIndexOf("/") + 1, f.length());
                    if (filename == null || filename.isEmpty()) {
                        tagElement.addContent(f);
                    } else {
                        tagElement.addContent(f + "#" + filename);
                    }
                }
                X.addContent((Content)tagElement);
            }
        }
    }

    static void addFileSection(Element X, Configuration conf, Namespace ns) {
        String filesStr = conf.get("oozie.files");
        SubmitHttpCommand.addSection(X, ns, filesStr, "file");
    }

    static void addArchiveSection(Element X, Configuration conf, Namespace ns) {
        String archivesStr = conf.get("oozie.archives");
        SubmitHttpCommand.addSection(X, ns, archivesStr, "archive");
    }

    static {
        MANDATORY_OOZIE_CONFS.add("mapred.job.tracker");
        MANDATORY_OOZIE_CONFS.add("fs.default.name");
        OPTIONAL_OOZIE_CONFS.add("oozie.files");
        OPTIONAL_OOZIE_CONFS.add("oozie.archives");
        DISALLOWED_DEFAULT_PROPERTIES = new HashSet<String>();
        DISALLOWED_USER_PROPERTIES = new HashSet<String>();
        String[] badUserProps = new String[]{"DAYS", "HOURS", "MINUTES", "KB", "MB", "GB", "TB", "PB", "RECORDS", "MAP_IN", "MAP_OUT", "REDUCE_IN", "REDUCE_OUT", "GROUPS"};
        PropertiesUtils.createPropertySet(badUserProps, DISALLOWED_USER_PROPERTIES);
        String[] badDefaultProps = new String[]{"user.name", "hadoop.job.ugi", "mapreduce.jobtracker.kerberos.principal", "dfs.namenode.kerberos.principal"};
        PropertiesUtils.createPropertySet(badUserProps, DISALLOWED_DEFAULT_PROPERTIES);
        PropertiesUtils.createPropertySet(badDefaultProps, DISALLOWED_DEFAULT_PROPERTIES);
    }
}

