/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class BundleActionsGetWaitingOlderJPAExecutor
implements JPAExecutor<List<BundleActionBean>> {
    private long checkAgeSecs = 0L;

    public BundleActionsGetWaitingOlderJPAExecutor(long checkAgeSecs) {
        ParamChecker.notNull(checkAgeSecs, "checkAgeSecs");
        this.checkAgeSecs = checkAgeSecs;
    }

    @Override
    public String getName() {
        return "BundleActionsGetWaitingOlderJPAExecutor";
    }

    @Override
    public List<BundleActionBean> execute(EntityManager em) throws JPAExecutorException {
        try {
            Query q = em.createNamedQuery("GET_BUNDLE_WAITING_ACTIONS_OLDER_THAN");
            Timestamp ts = new Timestamp(System.currentTimeMillis() - this.checkAgeSecs * 1000L);
            q.setParameter("lastModifiedTime", (Object)ts);
            List actions = q.getResultList();
            return actions;
        }
        catch (IllegalStateException e) {
            throw new JPAExecutorException(ErrorCode.E0601, e.getMessage(), e);
        }
    }
}

