/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import javax.persistence.EntityManager;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class CoordActionRemoveJPAExecutor
implements JPAExecutor<Void> {
    private String coordActionId = null;

    public CoordActionRemoveJPAExecutor(String coordActionId) {
        ParamChecker.notNull(coordActionId, "coordActionId");
        this.coordActionId = coordActionId;
    }

    @Override
    public Void execute(EntityManager em) throws JPAExecutorException {
        try {
            CoordinatorActionBean action = (CoordinatorActionBean)em.find(CoordinatorActionBean.class, (Object)this.coordActionId);
            if (action == null) {
                throw new CommandException(ErrorCode.E0605, this.coordActionId);
            }
            em.remove((Object)action);
            return null;
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e);
        }
    }

    @Override
    public String getName() {
        return "CoordActionRemoveJPAExecutor";
    }
}

