/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class CoordActionsGetForJobJPAExecutor
implements JPAExecutor<List<CoordinatorActionBean>> {
    private String coordJobId = null;
    private int numResults = 50;
    private String executionOrder = "FIFO";

    public CoordActionsGetForJobJPAExecutor(String coordJobId) {
        ParamChecker.notNull(coordJobId, "coordJobId");
        this.coordJobId = coordJobId;
    }

    public CoordActionsGetForJobJPAExecutor(String coordJobId, int numResults, String executionOrder) {
        this(coordJobId);
        ParamChecker.notNull(executionOrder, "executionOrder");
        this.numResults = numResults;
        this.executionOrder = executionOrder;
    }

    @Override
    public String getName() {
        return "CoordActionsGetForJobJPAExecutor";
    }

    @Override
    public List<CoordinatorActionBean> execute(EntityManager em) throws JPAExecutorException {
        List caBeans;
        try {
            Query q = this.executionOrder.equalsIgnoreCase("FIFO") ? em.createNamedQuery("GET_COORD_ACTIONS_FOR_JOB_FIFO") : em.createNamedQuery("GET_COORD_ACTIONS_FOR_JOB_LIFO");
            q.setParameter("jobId", (Object)this.coordJobId);
            if (this.executionOrder.equalsIgnoreCase("LAST_ONLY")) {
                q.setMaxResults(1);
            } else if (this.numResults > 0) {
                q.setMaxResults(this.numResults);
            }
            caBeans = q.getResultList();
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e);
        }
        return caBeans;
    }
}

