/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class WorkflowActionsDeleteForPurgeJPAExecutor
implements JPAExecutor<Integer> {
    private String wfId = null;

    public WorkflowActionsDeleteForPurgeJPAExecutor(String wfId) {
        ParamChecker.notNull(wfId, "wfId");
        this.wfId = wfId;
    }

    @Override
    public String getName() {
        return "WorkflowActionsDeleteForPurgeJPAExecutor";
    }

    @Override
    public Integer execute(EntityManager em) throws JPAExecutorException {
        int actionsDeleted = 0;
        try {
            Query g = em.createNamedQuery("DELETE_ACTIONS_FOR_WORKFLOW");
            g.setParameter("wfId", (Object)this.wfId);
            actionsDeleted = g.executeUpdate();
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e);
        }
        return actionsDeleted;
    }
}

