/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;

public class KerberosHadoopAccessorService
extends HadoopAccessorService {
    public static final String CONF_PREFIX = "oozie.service.HadoopAccessorService.";
    public static final String KERBEROS_AUTH_ENABLED = "oozie.service.HadoopAccessorService.kerberos.enabled";
    public static final String KERBEROS_KEYTAB = "oozie.service.HadoopAccessorService.keytab.file";
    public static final String KERBEROS_PRINCIPAL = "oozie.service.HadoopAccessorService.kerberos.principal";
    private ConcurrentMap<String, UserGroupInformation> userUgiMap;
    private String localRealm;

    @Override
    public void init(Configuration serviceConf) throws ServiceException {
        boolean kerberosAuthOn = serviceConf.getBoolean(KERBEROS_AUTH_ENABLED, true);
        XLog.getLog(this.getClass()).info("Oozie Kerberos Authentication [{0}]", kerberosAuthOn ? "enabled" : "disabled");
        if (kerberosAuthOn) {
            try {
                String keytabFile = serviceConf.get(KERBEROS_KEYTAB, System.getProperty("user.home") + "/oozie.keytab").trim();
                if (keytabFile.length() == 0) {
                    throw new ServiceException(ErrorCode.E0026, KERBEROS_KEYTAB);
                }
                String principal = serviceConf.get(KERBEROS_PRINCIPAL, "oozie/localhost@LOCALHOST");
                if (principal.length() == 0) {
                    throw new ServiceException(ErrorCode.E0026, KERBEROS_PRINCIPAL);
                }
                Configuration conf = new Configuration();
                conf.set("hadoop.security.authentication", "kerberos");
                UserGroupInformation.setConfiguration((Configuration)conf);
                UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytabFile);
                XLog.getLog(this.getClass()).info("Got Kerberos ticket, keytab [{0}], Oozie principal principal [{1}]", keytabFile, principal);
            }
            catch (ServiceException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ServiceException(ErrorCode.E0100, this.getClass().getName(), ex.getMessage(), ex);
            }
        } else {
            Configuration conf = new Configuration();
            conf.set("hadoop.security.authentication", "simple");
            UserGroupInformation.setConfiguration((Configuration)conf);
        }
        this.localRealm = serviceConf.get("local.realm");
        this.userUgiMap = new ConcurrentHashMap<String, UserGroupInformation>();
    }

    @Override
    public void destroy() {
        this.userUgiMap = null;
        super.destroy();
    }

    private UserGroupInformation getUGI(String user) throws IOException {
        UserGroupInformation ugi = (UserGroupInformation)this.userUgiMap.get(user);
        if (ugi == null) {
            ugi = UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)UserGroupInformation.getLoginUser());
            this.userUgiMap.putIfAbsent(user, ugi);
        }
        return ugi;
    }

    @Override
    public JobClient createJobClient(String user, String group, final JobConf conf) throws HadoopAccessorException {
        ParamChecker.notEmpty(user, "user");
        ParamChecker.notEmpty(group, "group");
        this.validateJobTracker(conf.get("mapred.job.tracker"));
        try {
            UserGroupInformation ugi = this.getUGI(user);
            JobClient jobClient = (JobClient)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<JobClient>(){

                @Override
                public JobClient run() throws Exception {
                    return new JobClient(conf);
                }
            });
            Token mrdt = jobClient.getDelegationToken(new Text("mr token"));
            conf.getCredentials().addToken(new Text("mr token"), mrdt);
            return jobClient;
        }
        catch (InterruptedException ex) {
            throw new HadoopAccessorException(ErrorCode.E0902, ex);
        }
        catch (IOException ex) {
            throw new HadoopAccessorException(ErrorCode.E0902, ex);
        }
    }

    @Override
    public FileSystem createFileSystem(String user, String group, final Configuration conf) throws HadoopAccessorException {
        ParamChecker.notEmpty(user, "user");
        ParamChecker.notEmpty(group, "group");
        try {
            this.validateNameNode(new URI(conf.get("fs.default.name")).getAuthority());
            UserGroupInformation ugi = this.getUGI(user);
            return (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws Exception {
                    Configuration defaultConf = new Configuration();
                    XConfiguration.copy(conf, defaultConf);
                    return FileSystem.get((Configuration)defaultConf);
                }
            });
        }
        catch (InterruptedException ex) {
            throw new HadoopAccessorException(ErrorCode.E0902, ex);
        }
        catch (IOException ex) {
            throw new HadoopAccessorException(ErrorCode.E0902, ex);
        }
        catch (URISyntaxException ex) {
            throw new HadoopAccessorException(ErrorCode.E0902, ex);
        }
    }

    @Override
    public FileSystem createFileSystem(String user, String group, final URI uri, final Configuration conf) throws HadoopAccessorException {
        ParamChecker.notEmpty(user, "user");
        ParamChecker.notEmpty(group, "group");
        this.validateNameNode(uri.getAuthority());
        try {
            UserGroupInformation ugi = this.getUGI(user);
            return (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws Exception {
                    Configuration defaultConf = new Configuration();
                    defaultConf.set("mapreduce.jobtracker.kerberos.principal", "mapred/_HOST@" + KerberosHadoopAccessorService.this.localRealm);
                    defaultConf.set("dfs.namenode.kerberos.principal", "hdfs/_HOST@" + KerberosHadoopAccessorService.this.localRealm);
                    XConfiguration.copy(conf, defaultConf);
                    return FileSystem.get((URI)uri, (Configuration)defaultConf);
                }
            });
        }
        catch (InterruptedException ex) {
            throw new HadoopAccessorException(ErrorCode.E0902, ex);
        }
        catch (IOException ex) {
            throw new HadoopAccessorException(ErrorCode.E0902, ex);
        }
    }

    @Override
    public void addFileToClassPath(String user, String group, final Path file, final Configuration conf) throws IOException {
        ParamChecker.notEmpty(user, "user");
        ParamChecker.notEmpty(group, "group");
        try {
            UserGroupInformation ugi = this.getUGI(user);
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Configuration defaultConf = new Configuration();
                    XConfiguration.copy(conf, defaultConf);
                    DistributedCache.addFileToClassPath((Path)file, (Configuration)defaultConf);
                    DistributedCache.addFileToClassPath((Path)file, (Configuration)conf);
                    return null;
                }
            });
        }
        catch (InterruptedException ex) {
            throw new IOException(ex);
        }
    }
}

