/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import org.apache.oozie.service.Service;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.Instrumentable;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.MemoryLocks;

public class MemoryLocksService
implements Service,
Instrumentable {
    private static final String INSTRUMENTATION_GROUP = "locks";
    private MemoryLocks locks;

    @Override
    public void init(Services services) {
        this.locks = new MemoryLocks();
    }

    @Override
    public void destroy() {
        this.locks = null;
    }

    @Override
    public Class<? extends Service> getInterface() {
        return MemoryLocksService.class;
    }

    @Override
    public void instrument(Instrumentation instr) {
        final MemoryLocks finalLocks = this.locks;
        instr.addVariable(INSTRUMENTATION_GROUP, INSTRUMENTATION_GROUP, new Instrumentation.Variable<Long>(){

            @Override
            public Long getValue() {
                return finalLocks.size();
            }
        });
    }

    public MemoryLocks.LockToken getReadLock(String resource, long wait) throws InterruptedException {
        return this.locks.getReadLock(resource, wait);
    }

    public MemoryLocks.LockToken getWriteLock(String resource, long wait) throws InterruptedException {
        return this.locks.getWriteLock(resource, wait);
    }
}

