/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.bundle.BundleKillXCommand;
import org.apache.oozie.command.bundle.BundleStatusUpdateXCommand;
import org.apache.oozie.executor.jpa.BundleActionsGetByLastModifiedTimeJPAExecutor;
import org.apache.oozie.executor.jpa.BundleActionsGetJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobUpdateJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobsGetPendingJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobsGetRunningJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionsGetByLastModifiedTimeJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetActionsJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobUpdateJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobsGetPendingJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.MemoryLocksService;
import org.apache.oozie.service.SchedulerService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.MemoryLocks;
import org.apache.oozie.util.StatusUtils;
import org.apache.oozie.util.XLog;

public class StatusTransitService
implements Service {
    public static final String CONF_PREFIX = "oozie.service.StatusTransitService.";
    public static final String CONF_STATUSTRANSIT_INTERVAL = "oozie.service.StatusTransitService.statusTransit.interval";
    public static final String CONF_BACKWARD_SUPPORT_FOR_COORD_STATUS = "oozie.service.StatusTransitService.backward.support.for.coord.status";
    private static int limit = -1;
    private static Date lastInstanceStartTime = null;
    private static final XLog LOG = XLog.getLog(StatusTransitRunnable.class);

    @Override
    public void init(Services services) {
        Configuration conf = services.getConf();
        StatusTransitRunnable stateTransitRunnable = new StatusTransitRunnable();
        services.get(SchedulerService.class).schedule(stateTransitRunnable, 10L, (long)conf.getInt(CONF_STATUSTRANSIT_INTERVAL, 60), SchedulerService.Unit.SEC);
    }

    @Override
    public void destroy() {
    }

    @Override
    public Class<? extends Service> getInterface() {
        return StatusTransitService.class;
    }

    static class StatusTransitRunnable
    implements Runnable {
        private JPAService jpaService = Services.get().get(JPAService.class);
        private MemoryLocks.LockToken lock;

        public StatusTransitRunnable() {
            if (this.jpaService == null) {
                LOG.error("Missing JPAService");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: {
                try {
                    Date curDate = new Date();
                    this.lock = Services.get().get(MemoryLocksService.class).getWriteLock(StatusTransitService.class.getName(), Service.lockTimeout);
                    if (this.lock == null) {
                        LOG.info("This StatusTransitService instance will not run since there is already an instance running");
                    } else {
                        LOG.info("Acquired lock for [{0}]", StatusTransitService.class.getName());
                        this.coordTransit();
                        this.bundleTransit();
                        lastInstanceStartTime = curDate;
                    }
                    if (this.lock == null) break block7;
                    this.lock.release();
                }
                catch (Exception ex) {
                    try {
                        LOG.warn((Object)"Exception happened during StatusTransitRunnable ", ex);
                        if (this.lock == null) break block7;
                        this.lock.release();
                    }
                    catch (Throwable throwable) {
                        if (this.lock != null) {
                            this.lock.release();
                            LOG.info("Released lock for [{0}]", StatusTransitService.class.getName());
                        }
                        throw throwable;
                    }
                    LOG.info("Released lock for [{0}]", StatusTransitService.class.getName());
                }
                LOG.info("Released lock for [{0}]", StatusTransitService.class.getName());
            }
        }

        private void bundleTransit() throws JPAExecutorException, CommandException {
            List<BundleJobBean> pendingJobCheckList = null;
            List<BundleJobBean> runningJobCheckList = null;
            ArrayList<List<BundleJobBean>> bundleLists = new ArrayList<List<BundleJobBean>>();
            if (lastInstanceStartTime == null) {
                LOG.info("Running bundle status service first instance");
                pendingJobCheckList = this.jpaService.execute(new BundleJobsGetPendingJPAExecutor(limit));
                runningJobCheckList = this.jpaService.execute(new BundleJobsGetRunningJPAExecutor(limit));
                bundleLists.add(pendingJobCheckList);
                bundleLists.add(runningJobCheckList);
            } else {
                LOG.info("Running bundle status service from last instance time =  " + DateUtils.convertDateToString(lastInstanceStartTime));
                List<BundleActionBean> actionList = this.jpaService.execute(new BundleActionsGetByLastModifiedTimeJPAExecutor(lastInstanceStartTime));
                HashSet<String> bundleIds = new HashSet<String>();
                for (BundleActionBean action : actionList) {
                    bundleIds.add(action.getBundleId());
                }
                pendingJobCheckList = new ArrayList<BundleJobBean>();
                for (String bundleId : bundleIds.toArray(new String[bundleIds.size()])) {
                    BundleJobBean bundle = this.jpaService.execute(new BundleJobGetJPAExecutor(bundleId));
                    if (!bundle.isPending() && !bundle.getStatus().equals((Object)Job.Status.RUNNING)) continue;
                    pendingJobCheckList.add(bundle);
                }
                runningJobCheckList = pendingJobCheckList;
                bundleLists.add(pendingJobCheckList);
            }
            this.aggregateBundleJobsStatus(bundleLists);
        }

        private void aggregateBundleJobsStatus(List<List<BundleJobBean>> bundleLists) throws JPAExecutorException, CommandException {
            if (bundleLists != null) {
                for (List<BundleJobBean> listBundleBean : bundleLists) {
                    for (BundleJobBean bundleJob : listBundleBean) {
                        try {
                            String jobId = bundleJob.getId();
                            Job.Status[] bundleStatus = new Job.Status[]{bundleJob.getStatus()};
                            List<BundleActionBean> bundleActions = this.jpaService.execute(new BundleActionsGetJPAExecutor(jobId));
                            HashMap<Job.Status, Integer> bundleActionStatus = new HashMap<Job.Status, Integer>();
                            boolean foundPending = false;
                            for (BundleActionBean bAction : bundleActions) {
                                if (!bAction.isPending()) {
                                    int counter = 0;
                                    counter = bundleActionStatus.containsKey(bAction.getStatus()) ? bundleActionStatus.get(bAction.getStatus()) + 1 : ++counter;
                                    bundleActionStatus.put(bAction.getStatus(), counter);
                                    if (bAction.getCoordId() != null || bAction.getStatus() != Job.Status.FAILED && bAction.getStatus() != Job.Status.KILLED) continue;
                                    new BundleKillXCommand(jobId).call();
                                    LOG.info("Bundle job [" + jobId + "] has been killed since one of its coordinator job failed submission.");
                                    continue;
                                }
                                foundPending = true;
                                break;
                            }
                            if (foundPending) continue;
                            if (this.checkTerminalStatus(bundleActionStatus, bundleActions, bundleStatus)) {
                                LOG.info("Set bundle job [" + jobId + "] status to '" + bundleStatus[0].toString() + "' from '" + bundleJob.getStatus() + "'");
                                this.updateBundleJob(bundleActionStatus, bundleActions, bundleJob, bundleStatus[0]);
                                continue;
                            }
                            if (this.checkPrepStatus(bundleActionStatus, bundleActions, bundleStatus)) {
                                LOG.info("Set bundle job [" + jobId + "] status to '" + bundleStatus[0].toString() + "' from '" + bundleJob.getStatus() + "'");
                                this.updateBundleJob(bundleActionStatus, bundleActions, bundleJob, bundleStatus[0]);
                                continue;
                            }
                            if (this.checkPausedStatus(bundleActionStatus, bundleActions, bundleStatus)) {
                                LOG.info("Set bundle job [" + jobId + "] status to '" + bundleStatus[0].toString() + "' from '" + bundleJob.getStatus() + "'");
                                this.updateBundleJob(bundleActionStatus, bundleActions, bundleJob, bundleStatus[0]);
                                continue;
                            }
                            if (this.checkSuspendStatus(bundleActionStatus, bundleActions, bundleStatus)) {
                                LOG.info("Set bundle job [" + jobId + "] status to '" + bundleStatus[0].toString() + "' from '" + bundleJob.getStatus() + "'");
                                this.updateBundleJob(bundleActionStatus, bundleActions, bundleJob, bundleStatus[0]);
                                continue;
                            }
                            if (!this.checkRunningStatus(bundleActionStatus, bundleActions, bundleStatus)) continue;
                            LOG.info("Set bundle job [" + jobId + "] status to '" + bundleStatus[0].toString() + "' from '" + bundleJob.getStatus() + "'");
                            this.updateBundleJob(bundleActionStatus, bundleActions, bundleJob, bundleStatus[0]);
                        }
                        catch (Exception ex) {
                            LOG.error((Object)("Exception happened during aggregate bundle job's status, job = " + bundleJob.getId()), ex);
                        }
                    }
                }
            }
        }

        private void aggregateCoordJobsStatus(List<CoordinatorJobBean> CoordList) throws JPAExecutorException, CommandException {
            if (CoordList != null) {
                Configuration conf = Services.get().getConf();
                boolean backwardSupportForCoordStatus = conf.getBoolean(StatusTransitService.CONF_BACKWARD_SUPPORT_FOR_COORD_STATUS, false);
                for (CoordinatorJobBean coordJob : CoordList) {
                    try {
                        if (backwardSupportForCoordStatus && coordJob.getAppNamespace() != null && coordJob.getAppNamespace().equals("uri:oozie:coordinator:0.1")) continue;
                        String jobId = coordJob.getId();
                        Job.Status[] coordStatus = new Job.Status[]{coordJob.getStatus()};
                        List<CoordinatorActionBean> coordActions = this.jpaService.execute(new CoordJobGetActionsJPAExecutor(jobId));
                        HashMap<CoordinatorAction.Status, Integer> coordActionStatus = new HashMap<CoordinatorAction.Status, Integer>();
                        boolean foundPending = false;
                        for (CoordinatorActionBean cAction : coordActions) {
                            if (!cAction.isPending()) {
                                int counter = 0;
                                counter = coordActionStatus.containsKey(cAction.getStatus()) ? coordActionStatus.get(cAction.getStatus()) + 1 : ++counter;
                                coordActionStatus.put(cAction.getStatus(), counter);
                                continue;
                            }
                            foundPending = true;
                            break;
                        }
                        if (foundPending) continue;
                        if (coordJob.isDoneMaterialization() && this.checkCoordTerminalStatus(coordActionStatus, coordActions, coordStatus)) {
                            LOG.info("Set coordinator job [" + jobId + "] status to '" + coordStatus[0].toString() + "' from '" + coordJob.getStatus() + "'");
                            this.updateCoordJob(coordActionStatus, coordActions, coordJob, coordStatus[0]);
                            continue;
                        }
                        if (coordJob.isDoneMaterialization() && this.checkCoordSuspendStatus(coordActionStatus, coordActions, coordStatus)) {
                            LOG.info("Set coordinator job [" + jobId + "] status to " + coordStatus[0].toString() + "' from '" + coordJob.getStatus() + "'");
                            this.updateCoordJob(coordActionStatus, coordActions, coordJob, coordStatus[0]);
                            continue;
                        }
                        if (this.checkCoordRunningStatus(coordActionStatus, coordActions, coordStatus)) {
                            LOG.info("Set coordinator job [" + jobId + "] status to " + coordStatus[0].toString() + "' from '" + coordJob.getStatus() + "'");
                            this.updateCoordJob(coordActionStatus, coordActions, coordJob, coordStatus[0]);
                            continue;
                        }
                        this.checkCoordPending(coordActionStatus, coordActions, coordJob, true);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)("Exception happened during aggregate coordinator job's status, job = " + coordJob.getId()), ex);
                    }
                }
            }
        }

        private boolean checkTerminalStatus(HashMap<Job.Status, Integer> bundleActionStatus, List<BundleActionBean> bundleActions, Job.Status[] bundleStatus) {
            boolean ret = false;
            int totalValuesSucceed = 0;
            if (bundleActionStatus.containsKey(Job.Status.SUCCEEDED)) {
                totalValuesSucceed = bundleActionStatus.get(Job.Status.SUCCEEDED);
            }
            int totalValuesFailed = 0;
            if (bundleActionStatus.containsKey(Job.Status.FAILED)) {
                totalValuesFailed = bundleActionStatus.get(Job.Status.FAILED);
            }
            int totalValuesKilled = 0;
            if (bundleActionStatus.containsKey(Job.Status.KILLED)) {
                totalValuesKilled = bundleActionStatus.get(Job.Status.KILLED);
            }
            int totalValuesDoneWithError = 0;
            if (bundleActionStatus.containsKey(Job.Status.DONEWITHERROR)) {
                totalValuesDoneWithError = bundleActionStatus.get(Job.Status.DONEWITHERROR);
            }
            if (bundleActions.size() == totalValuesSucceed + totalValuesFailed + totalValuesKilled + totalValuesDoneWithError) {
                if (bundleActions.size() == totalValuesSucceed) {
                    bundleStatus[0] = Job.Status.SUCCEEDED;
                    ret = true;
                } else if (bundleActions.size() == totalValuesKilled) {
                    bundleStatus[0] = Job.Status.KILLED;
                    ret = true;
                } else if (bundleActions.size() == totalValuesFailed) {
                    bundleStatus[0] = Job.Status.FAILED;
                    ret = true;
                } else {
                    bundleStatus[0] = Job.Status.DONEWITHERROR;
                    ret = true;
                }
            }
            return ret;
        }

        private boolean checkCoordTerminalStatus(HashMap<CoordinatorAction.Status, Integer> coordActionStatus, List<CoordinatorActionBean> coordActions, Job.Status[] coordStatus) {
            boolean ret = false;
            int totalValuesSucceed = 0;
            if (coordActionStatus.containsKey(CoordinatorAction.Status.SUCCEEDED)) {
                totalValuesSucceed = coordActionStatus.get(CoordinatorAction.Status.SUCCEEDED);
            }
            int totalValuesFailed = 0;
            if (coordActionStatus.containsKey(CoordinatorAction.Status.FAILED)) {
                totalValuesFailed = coordActionStatus.get(CoordinatorAction.Status.FAILED);
            }
            int totalValuesKilled = 0;
            if (coordActionStatus.containsKey(CoordinatorAction.Status.KILLED)) {
                totalValuesKilled = coordActionStatus.get(CoordinatorAction.Status.KILLED);
            }
            int totalValuesTimeOut = 0;
            if (coordActionStatus.containsKey(CoordinatorAction.Status.TIMEDOUT)) {
                totalValuesTimeOut = coordActionStatus.get(CoordinatorAction.Status.TIMEDOUT);
            }
            if (coordActions.size() == totalValuesSucceed + totalValuesFailed + totalValuesKilled + totalValuesTimeOut) {
                if (coordActions.size() == totalValuesSucceed) {
                    coordStatus[0] = Job.Status.SUCCEEDED;
                    ret = true;
                } else if (coordActions.size() == totalValuesKilled) {
                    coordStatus[0] = Job.Status.KILLED;
                    ret = true;
                } else if (coordActions.size() == totalValuesFailed) {
                    coordStatus[0] = Job.Status.FAILED;
                    ret = true;
                } else {
                    coordStatus[0] = Job.Status.DONEWITHERROR;
                    ret = true;
                }
            }
            return ret;
        }

        private boolean checkPrepStatus(HashMap<Job.Status, Integer> bundleActionStatus, List<BundleActionBean> bundleActions, Job.Status[] bundleStatus) {
            boolean ret = false;
            if (bundleActionStatus.containsKey(Job.Status.PREP) && bundleActions.size() > bundleActionStatus.get(Job.Status.PREP)) {
                bundleStatus[0] = Job.Status.RUNNING;
                ret = true;
            }
            return ret;
        }

        private boolean checkPausedStatus(HashMap<Job.Status, Integer> bundleActionStatus, List<BundleActionBean> bundleActions, Job.Status[] bundleStatus) {
            boolean ret = false;
            if (bundleActionStatus.containsKey(Job.Status.PAUSED)) {
                if (bundleActions.size() == bundleActionStatus.get(Job.Status.PAUSED).intValue()) {
                    bundleStatus[0] = Job.Status.PAUSED;
                    ret = true;
                } else if (bundleActionStatus.containsKey(Job.Status.PAUSEDWITHERROR) && bundleActions.size() == bundleActionStatus.get(Job.Status.PAUSED) + bundleActionStatus.get(Job.Status.PAUSEDWITHERROR)) {
                    bundleStatus[0] = Job.Status.PAUSED;
                    ret = true;
                }
            }
            return ret;
        }

        private boolean checkSuspendStatus(HashMap<Job.Status, Integer> bundleActionStatus, List<BundleActionBean> bundleActions, Job.Status[] bundleStatus) {
            boolean ret = false;
            if (bundleActionStatus.containsKey(Job.Status.SUSPENDED)) {
                if (bundleActions.size() == bundleActionStatus.get(Job.Status.SUSPENDED).intValue()) {
                    bundleStatus[0] = Job.Status.SUSPENDED;
                    ret = true;
                } else if (bundleActionStatus.containsKey(Job.Status.SUSPENDEDWITHERROR) && bundleActions.size() == bundleActionStatus.get(Job.Status.SUSPENDED) + bundleActionStatus.get(Job.Status.SUSPENDEDWITHERROR)) {
                    bundleStatus[0] = Job.Status.SUSPENDED;
                    ret = true;
                }
            }
            return ret;
        }

        private boolean checkCoordSuspendStatus(HashMap<CoordinatorAction.Status, Integer> coordActionStatus, List<CoordinatorActionBean> coordActions, Job.Status[] coordStatus) {
            boolean ret = false;
            if (coordActionStatus.containsKey(CoordinatorAction.Status.SUSPENDED) && coordActions.size() == coordActionStatus.get(CoordinatorAction.Status.SUSPENDED).intValue()) {
                coordStatus[0] = Job.Status.SUSPENDED;
                ret = true;
            }
            return ret;
        }

        private boolean checkCoordRunningStatus(HashMap<CoordinatorAction.Status, Integer> coordActionStatus, List<CoordinatorActionBean> coordActions, Job.Status[] coordStatus) {
            boolean ret = false;
            if (coordActionStatus.containsKey(CoordinatorAction.Status.RUNNING)) {
                if (coordActions.size() == coordActionStatus.get(CoordinatorAction.Status.RUNNING).intValue()) {
                    coordStatus[0] = Job.Status.RUNNING;
                    ret = true;
                } else if (coordActionStatus.get(CoordinatorAction.Status.RUNNING) > 0 && (coordActionStatus.containsKey(CoordinatorAction.Status.FAILED) && coordActionStatus.get(CoordinatorAction.Status.FAILED) > 0 || coordActionStatus.containsKey(CoordinatorAction.Status.KILLED) && coordActionStatus.get(CoordinatorAction.Status.KILLED) > 0 || coordActionStatus.containsKey(CoordinatorAction.Status.TIMEDOUT) && coordActionStatus.get(CoordinatorAction.Status.TIMEDOUT) > 0)) {
                    coordStatus[0] = Job.Status.RUNNING;
                    ret = true;
                }
            }
            return ret;
        }

        private boolean checkRunningStatus(HashMap<Job.Status, Integer> bundleActionStatus, List<BundleActionBean> bundleActions, Job.Status[] bundleStatus) {
            boolean ret = false;
            if (bundleActionStatus.containsKey(Job.Status.RUNNING)) {
                if (bundleActions.size() == bundleActionStatus.get(Job.Status.RUNNING).intValue()) {
                    bundleStatus[0] = Job.Status.RUNNING;
                    ret = true;
                } else if (bundleActionStatus.get(Job.Status.RUNNING) > 0 && (bundleActionStatus.containsKey(Job.Status.FAILED) && bundleActionStatus.get(Job.Status.FAILED) > 0 || bundleActionStatus.containsKey(Job.Status.KILLED) && bundleActionStatus.get(Job.Status.KILLED) > 0 || bundleActionStatus.containsKey(Job.Status.DONEWITHERROR) && bundleActionStatus.get(Job.Status.DONEWITHERROR) > 0 || bundleActionStatus.containsKey(Job.Status.RUNNINGWITHERROR) && bundleActionStatus.get(Job.Status.RUNNINGWITHERROR) > 0)) {
                    bundleStatus[0] = Job.Status.RUNNING;
                    ret = true;
                }
            }
            return ret;
        }

        private void updateBundleJob(HashMap<Job.Status, Integer> bundleActionStatus, List<BundleActionBean> bundleActions, BundleJobBean bundleJob, Job.Status bundleStatus) throws JPAExecutorException {
            String jobId = bundleJob.getId();
            boolean pendingBundleJob = bundleJob.isPending();
            int totalNonPendingActions = 0;
            for (Job.Status js : bundleActionStatus.keySet()) {
                totalNonPendingActions += bundleActionStatus.get(js).intValue();
            }
            if (totalNonPendingActions == bundleActions.size()) {
                pendingBundleJob = false;
            }
            bundleJob.setStatus(bundleStatus);
            if (pendingBundleJob) {
                bundleJob.setPending();
                LOG.info("Bundle job [" + jobId + "] Pending set to TRUE");
            } else {
                bundleJob.resetPending();
                LOG.info("Bundle job [" + jobId + "] Pending set to FALSE");
            }
            this.jpaService.execute(new BundleJobUpdateJPAExecutor(bundleJob));
        }

        private void updateCoordJob(HashMap<CoordinatorAction.Status, Integer> coordActionStatus, List<CoordinatorActionBean> coordActions, CoordinatorJobBean coordJob, Job.Status coordStatus) throws JPAExecutorException, CommandException {
            Job.Status prevStatus = coordJob.getStatus();
            if ((coordJob.getStatus() == Job.Status.SUCCEEDED || coordJob.getStatus() == Job.Status.FAILED || coordJob.getStatus() == Job.Status.KILLED || coordJob.getStatus() == Job.Status.DONEWITHERROR) && coordStatus == Job.Status.SUSPENDED) {
                LOG.info("Coord Job [" + coordJob.getId() + "] status can not be updated as its already in Terminal state");
                return;
            }
            this.checkCoordPending(coordActionStatus, coordActions, coordJob, false);
            coordJob.setStatus(coordStatus);
            coordJob.setStatus(StatusUtils.getStatus(coordJob));
            coordJob.setLastModifiedTime(new Date());
            this.jpaService.execute(new CoordJobUpdateJPAExecutor(coordJob));
            if (coordJob.getBundleId() != null && !prevStatus.equals((Object)coordJob.getStatus())) {
                BundleStatusUpdateXCommand bundleStatusUpdate = new BundleStatusUpdateXCommand(coordJob, prevStatus);
                bundleStatusUpdate.call();
            }
        }

        private void checkCoordPending(HashMap<CoordinatorAction.Status, Integer> coordActionStatus, List<CoordinatorActionBean> coordActions, CoordinatorJobBean coordJob, boolean saveToDB) throws JPAExecutorException {
            boolean pendingCoordJob = coordJob.isPending();
            int totalNonPendingActions = 0;
            for (CoordinatorAction.Status js : coordActionStatus.keySet()) {
                totalNonPendingActions += coordActionStatus.get(js).intValue();
            }
            if (totalNonPendingActions == coordActions.size()) {
                pendingCoordJob = false;
            }
            if (pendingCoordJob) {
                coordJob.setPending();
                LOG.info("Coord job [" + coordJob.getId() + "] Pending set to TRUE");
            } else {
                coordJob.resetPending();
                LOG.info("Coord job [" + coordJob.getId() + "] Pending set to FALSE");
            }
            if (saveToDB) {
                this.jpaService.execute(new CoordJobUpdateJPAExecutor(coordJob));
            }
        }

        private void coordTransit() throws JPAExecutorException, CommandException {
            List<CoordinatorJobBean> pendingJobCheckList = null;
            if (lastInstanceStartTime == null) {
                LOG.info("Running coordinator status service first instance");
                pendingJobCheckList = this.jpaService.execute(new CoordJobsGetPendingJPAExecutor(limit));
            } else {
                LOG.info("Running coordinator status service from last instance time =  " + DateUtils.convertDateToString(lastInstanceStartTime));
                List<CoordinatorActionBean> actionList = this.jpaService.execute(new CoordActionsGetByLastModifiedTimeJPAExecutor(lastInstanceStartTime));
                HashSet<String> coordIds = new HashSet<String>();
                for (CoordinatorActionBean action : actionList) {
                    coordIds.add(action.getJobId());
                }
                pendingJobCheckList = new ArrayList<CoordinatorJobBean>();
                for (String coordId : coordIds.toArray(new String[coordIds.size()])) {
                    CoordinatorJobBean coordJob = this.jpaService.execute(new CoordJobGetJPAExecutor(coordId));
                    if (!coordJob.isPending() && !coordJob.getStatus().equals((Object)Job.Status.RUNNING)) continue;
                    pendingJobCheckList.add(coordJob);
                }
            }
            this.aggregateCoordJobsStatus(pendingJobCheckList);
        }
    }
}

