/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import javax.persistence.EntityManager;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.CoordinatorStoreService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.SLAStoreService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.WorkflowStoreService;
import org.apache.oozie.store.CoordinatorStore;
import org.apache.oozie.store.SLAStore;
import org.apache.oozie.store.Store;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.store.WorkflowStore;

public class StoreService
implements Service {
    private JPAService jpaService;

    public <S extends Store> S getStore(Class<S> klass) throws StoreException {
        if (WorkflowStore.class.equals(klass)) {
            return (S)Services.get().get(WorkflowStoreService.class).create();
        }
        if (CoordinatorStore.class.equals(klass)) {
            return (S)Services.get().get(CoordinatorStoreService.class).create();
        }
        if (SLAStore.class.equals(klass)) {
            return (S)Services.get().get(SLAStoreService.class).create();
        }
        throw new StoreException(ErrorCode.E0607, " can not get store StoreService.getStore(Class)");
    }

    public <S extends Store, T extends Store> S getStore(Class<S> klass, T store) throws StoreException {
        if (WorkflowStore.class.equals(klass)) {
            return (S)Services.get().get(WorkflowStoreService.class).create(store);
        }
        if (CoordinatorStore.class.equals(klass)) {
            return (S)Services.get().get(CoordinatorStoreService.class).create(store);
        }
        if (SLAStore.class.equals(klass)) {
            return (S)Services.get().get(SLAStoreService.class).create(store);
        }
        throw new StoreException(ErrorCode.E0607, " StoreService.getStore(Class, store)");
    }

    @Override
    public Class<? extends Service> getInterface() {
        return StoreService.class;
    }

    @Override
    public void init(Services services) throws ServiceException {
        this.jpaService = Services.get().get(JPAService.class);
        if (this.jpaService == null) {
            throw new ServiceException(ErrorCode.E0610, new Object[0]);
        }
    }

    @Override
    public void destroy() {
    }

    public EntityManager getEntityManager() {
        return this.jpaService.getEntityManager();
    }
}

