/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.workflow.WorkflowApp;
import org.apache.oozie.workflow.WorkflowException;

public abstract class WorkflowAppService
implements Service {
    public static final String CONF_PREFIX = "oozie.service.WorkflowAppService.";
    public static final String SYSTEM_LIB_PATH = "oozie.service.WorkflowAppService.system.libpath";
    public static final String APP_LIB_PATH_LIST = "oozie.wf.application.lib";
    public static final String HADOOP_UGI = "hadoop.job.ugi";
    public static final String HADOOP_USER = "user.name";
    public static final String HADOOP_JT_KERBEROS_NAME = "mapreduce.jobtracker.kerberos.principal";
    public static final String HADOOP_NN_KERBEROS_NAME = "dfs.namenode.kerberos.principal";
    private Path systemLibPath;

    @Override
    public void init(Services services) {
        String path = services.getConf().get(SYSTEM_LIB_PATH, " ");
        if (path.trim().length() > 0) {
            this.systemLibPath = new Path(path.trim());
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public Class<? extends Service> getInterface() {
        return WorkflowAppService.class;
    }

    protected String readDefinition(String appPath, String user, String group, String autToken) throws WorkflowException {
        try {
            URI uri = new URI(appPath);
            FileSystem fs = Services.get().get(HadoopAccessorService.class).createFileSystem(user, group, uri, new Configuration());
            Path path = new Path(uri.getPath());
            if (!fs.isFile(path)) {
                path = new Path(path, "workflow.xml");
            }
            InputStreamReader reader = new InputStreamReader((InputStream)fs.open(path));
            StringWriter writer = new StringWriter();
            IOUtils.copyCharStream(reader, writer);
            return writer.toString();
        }
        catch (IOException ex) {
            throw new WorkflowException(ErrorCode.E0710, ex.getMessage(), ex);
        }
        catch (URISyntaxException ex) {
            throw new WorkflowException(ErrorCode.E0711, appPath, ex.getMessage(), ex);
        }
        catch (HadoopAccessorException ex) {
            throw new WorkflowException(ex);
        }
        catch (Exception ex) {
            throw new WorkflowException(ErrorCode.E0710, ex.getMessage(), ex);
        }
    }

    public XConfiguration createProtoActionConf(Configuration jobConf, String authToken, boolean isWorkflowJob) throws WorkflowException {
        XConfiguration conf = new XConfiguration();
        try {
            Path path;
            String user = jobConf.get(HADOOP_USER);
            String group = jobConf.get("group.name");
            String hadoopUgi = user + "," + group;
            conf.set(HADOOP_USER, user);
            conf.set("group.name", group);
            conf.set(HADOOP_UGI, hadoopUgi);
            conf.set(HADOOP_JT_KERBEROS_NAME, jobConf.get(HADOOP_JT_KERBEROS_NAME));
            conf.set(HADOOP_NN_KERBEROS_NAME, jobConf.get(HADOOP_NN_KERBEROS_NAME));
            URI uri = new URI(jobConf.get("oozie.wf.application.path"));
            FileSystem fs = Services.get().get(HadoopAccessorService.class).createFileSystem(user, group, uri, conf);
            Path appPath = new Path(uri.getPath());
            XLog.getLog(this.getClass()).debug("jobConf.libPath = " + jobConf.get("oozie.libpath"));
            XLog.getLog(this.getClass()).debug("jobConf.appPath = " + appPath);
            List<Object> filePaths = isWorkflowJob ? (!fs.isFile(path = new Path(uri.getPath())) ? this.getLibFiles(fs, new Path(appPath + "/lib")) : this.getLibFiles(fs, new Path(appPath.getParent(), "lib"))) : new ArrayList();
            String[] libPaths = jobConf.getStrings("oozie.libpath");
            if (libPaths != null && libPaths.length > 0) {
                for (int i = 0; i < libPaths.length; ++i) {
                    if (libPaths[i].trim().length() <= 0) continue;
                    Path libPath = new Path(libPaths[i].trim());
                    List<String> libFilePaths = this.getLibFiles(fs, libPath);
                    filePaths.addAll(libFilePaths);
                }
            }
            if (this.systemLibPath != null && jobConf.getBoolean("oozie.use.system.libpath", false)) {
                List<String> libFilePaths = this.getLibFiles(fs, this.systemLibPath);
                filePaths.addAll(libFilePaths);
            }
            conf.setStrings(APP_LIB_PATH_LIST, filePaths.toArray(new String[filePaths.size()]));
            for (Map.Entry entry : jobConf) {
                if (!((String)entry.getKey()).startsWith("oozie.")) continue;
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (conf.get(name) != null && name.equals(APP_LIB_PATH_LIST)) {
                    value = value + "," + conf.get(name);
                }
                conf.set(name, value);
            }
            return conf;
        }
        catch (IOException ex) {
            throw new WorkflowException(ErrorCode.E0712, jobConf.get("oozie.wf.application.path"), ex.getMessage(), ex);
        }
        catch (URISyntaxException ex) {
            throw new WorkflowException(ErrorCode.E0711, jobConf.get("oozie.wf.application.path"), ex.getMessage(), ex);
        }
        catch (HadoopAccessorException ex) {
            throw new WorkflowException(ex);
        }
        catch (Exception ex) {
            throw new WorkflowException(ErrorCode.E0712, jobConf.get("oozie.wf.application.path"), ex.getMessage(), ex);
        }
    }

    public abstract WorkflowApp parseDef(Configuration var1, String var2) throws WorkflowException;

    public abstract WorkflowApp parseDef(String var1) throws WorkflowException;

    private List<String> getLibFiles(FileSystem fs, Path libPath) throws IOException {
        ArrayList<String> libPaths = new ArrayList<String>();
        if (fs.exists(libPath)) {
            FileStatus[] files;
            for (FileStatus file : files = fs.listStatus(libPath, (PathFilter)new NoPathFilter())) {
                libPaths.add(file.getPath().toUri().getPath().trim());
            }
        } else {
            XLog.getLog(this.getClass()).warn("libpath [{0}] does not exists", libPath);
        }
        return libPaths;
    }

    private class NoPathFilter
    implements PathFilter {
        private NoPathFilter() {
        }

        public boolean accept(Path path) {
            return true;
        }
    }
}

