/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class MemoryLocks {
    private final HashMap<String, ReentrantReadWriteLock> locks = new HashMap();

    public int size() {
        return this.locks.size();
    }

    public LockToken getReadLock(String resource, long wait) throws InterruptedException {
        return this.getLock(resource, Type.READ, wait);
    }

    public LockToken getWriteLock(String resource, long wait) throws InterruptedException {
        return this.getLock(resource, Type.WRITE, wait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockToken getLock(String resource, Type type, long wait) throws InterruptedException {
        Lock lock;
        ReentrantReadWriteLock lockEntry;
        HashMap<String, ReentrantReadWriteLock> hashMap = this.locks;
        synchronized (hashMap) {
            if (this.locks.containsKey(resource)) {
                lockEntry = this.locks.get(resource);
            } else {
                lockEntry = new ReentrantReadWriteLock(true);
                this.locks.put(resource, lockEntry);
            }
        }
        Lock lock2 = lock = type.equals((Object)Type.READ) ? lockEntry.readLock() : lockEntry.writeLock();
        if (wait == -1L) {
            lock.lock();
        } else if (wait > 0L ? !lock.tryLock(wait, TimeUnit.MILLISECONDS) : !lock.tryLock()) {
            return null;
        }
        HashMap<String, ReentrantReadWriteLock> hashMap2 = this.locks;
        synchronized (hashMap2) {
            if (!this.locks.containsKey(resource)) {
                this.locks.put(resource, lockEntry);
            }
        }
        return new LockToken(lockEntry, lock, resource);
    }

    public class LockToken {
        private final ReentrantReadWriteLock rwLock;
        private final Lock lock;
        private final String resource;

        private LockToken(ReentrantReadWriteLock rwLock, Lock lock, String resource) {
            this.rwLock = rwLock;
            this.lock = lock;
            this.resource = resource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            int val = this.rwLock.getQueueLength();
            if (val == 0) {
                HashMap hashMap = MemoryLocks.this.locks;
                synchronized (hashMap) {
                    MemoryLocks.this.locks.remove(this.resource);
                }
            }
            this.lock.unlock();
        }
    }

    private static enum Type {
        READ,
        WRITE;

    }
}

