/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.oozie.util.XLogStreamer;

public class XLogReader {
    private BufferedReader logReader;
    private Writer logWriter;
    private boolean noFilter = false;
    private XLogStreamer.Filter logFilter;

    public XLogReader(InputStream logFileIS, XLogStreamer.Filter filter, Writer logWriter) {
        this.logReader = new BufferedReader(new InputStreamReader(logFileIS));
        this.logFilter = filter;
        this.logWriter = logWriter;
    }

    public void processLog() throws IOException {
        String line = this.logReader.readLine();
        boolean patternMatched = false;
        int lcnt = 0;
        if (this.logFilter == null || !this.logFilter.isFilterPresent()) {
            this.noFilter = true;
        } else {
            this.logFilter.constructPattern();
        }
        while (line != null) {
            if (this.noFilter) {
                this.logWriter.write(line + "\n");
            } else {
                ArrayList<String> logParts = this.logFilter.splitLogMessage(line);
                if (logParts != null) {
                    patternMatched = this.logFilter.matches(logParts);
                }
                if (patternMatched) {
                    this.logWriter.write(line + "\n");
                }
            }
            if (++lcnt % 20 == 0) {
                this.logWriter.flush();
            }
            line = this.logReader.readLine();
        }
        this.logWriter.flush();
    }

    public void close() throws IOException {
        this.logReader.close();
    }
}

