/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util.db;

import java.util.Date;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.SLAEventBean;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.executor.jpa.SLAEventInsertJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.StoreService;
import org.apache.oozie.store.SLAStore;
import org.apache.oozie.store.Store;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.XLog;
import org.jdom.Element;

public class SLADbOperations {
    public static final String CLIENT_ID_TAG = "oozie:sla:client-id";

    public static void writeSlaRegistrationEvent(Element eSla, Store store, String slaId, SLAEvent.SlaAppType appType, String user, String groupName) throws Exception {
        if (eSla == null) {
            return;
        }
        SLAEventBean sla = new SLAEventBean();
        sla.setAppName(SLADbOperations.getTagElement(eSla, "app-name"));
        sla.setParentClientId(SLADbOperations.getTagElement(eSla, "parent-child-id"));
        sla.setParentSlaId(SLADbOperations.getTagElement(eSla, "parent-sla-id"));
        String strNominalTime = SLADbOperations.getTagElement(eSla, "nominal-time");
        if (strNominalTime == null || strNominalTime.length() == 0) {
            throw new RuntimeException("Nominal time is required");
        }
        Date nominalTime = DateUtils.parseDateUTC(strNominalTime);
        String strRelExpectedStart = SLADbOperations.getTagElement(eSla, "should-start");
        if (strRelExpectedStart == null || strRelExpectedStart.length() == 0) {
            throw new RuntimeException("should-start can't be empty");
        }
        int relExpectedStart = Integer.parseInt(strRelExpectedStart);
        if (relExpectedStart < 0) {
            sla.setExpectedStart(null);
        } else {
            Date expectedStart = new Date(nominalTime.getTime() + (long)(relExpectedStart * 60 * 1000));
            sla.setExpectedStart(expectedStart);
        }
        String strRelExpectedEnd = SLADbOperations.getTagElement(eSla, "should-end");
        if (strRelExpectedEnd == null || strRelExpectedEnd.length() == 0) {
            throw new RuntimeException("should-end can't be empty");
        }
        int relExpectedEnd = Integer.parseInt(strRelExpectedEnd);
        if (relExpectedEnd < 0) {
            sla.setExpectedEnd(null);
        } else {
            Date expectedEnd = new Date(nominalTime.getTime() + (long)(relExpectedEnd * 60 * 1000));
            sla.setExpectedEnd(expectedEnd);
        }
        sla.setNotificationMsg(SLADbOperations.getTagElement(eSla, "notification-msg"));
        sla.setAlertContact(SLADbOperations.getTagElement(eSla, "alert-contact"));
        sla.setDevContact(SLADbOperations.getTagElement(eSla, "dev-contact"));
        sla.setQaContact(SLADbOperations.getTagElement(eSla, "qa-contact"));
        sla.setSeContact(SLADbOperations.getTagElement(eSla, "se-contact"));
        sla.setAlertFrequency(SLADbOperations.getTagElement(eSla, "alert-frequency"));
        sla.setAlertPercentage(SLADbOperations.getTagElement(eSla, "alert-percentage"));
        sla.setUpstreamApps(SLADbOperations.getTagElement(eSla, "upstream-apps"));
        sla.setSlaId(slaId);
        sla.setAppType(appType);
        sla.setUser(user);
        sla.setGroupName(groupName);
        sla.setJobStatus(SLAEvent.Status.CREATED);
        sla.setStatusTimestamp(new Date());
        SLAStore slaStore = Services.get().get(StoreService.class).getStore(SLAStore.class, store);
        slaStore.insertSLAEvent(sla);
    }

    public static void writeSlaRegistrationEvent(Element eSla, String slaId, SLAEvent.SlaAppType appType, String user, String groupName, XLog log) throws Exception {
        if (eSla == null) {
            return;
        }
        SLAEventBean sla = new SLAEventBean();
        sla.setAppName(SLADbOperations.getTagElement(eSla, "app-name"));
        sla.setParentClientId(SLADbOperations.getTagElement(eSla, "parent-child-id"));
        sla.setParentSlaId(SLADbOperations.getTagElement(eSla, "parent-sla-id"));
        String strNominalTime = SLADbOperations.getTagElement(eSla, "nominal-time");
        if (strNominalTime == null || strNominalTime.length() == 0) {
            throw new RuntimeException("Nominal time is required");
        }
        Date nominalTime = DateUtils.parseDateUTC(strNominalTime);
        String strRelExpectedStart = SLADbOperations.getTagElement(eSla, "should-start");
        if (strRelExpectedStart == null || strRelExpectedStart.length() == 0) {
            throw new RuntimeException("should-start can't be empty");
        }
        int relExpectedStart = Integer.parseInt(strRelExpectedStart);
        if (relExpectedStart < 0) {
            sla.setExpectedStart(null);
        } else {
            Date expectedStart = new Date(nominalTime.getTime() + (long)(relExpectedStart * 60 * 1000));
            sla.setExpectedStart(expectedStart);
        }
        String strRelExpectedEnd = SLADbOperations.getTagElement(eSla, "should-end");
        if (strRelExpectedEnd == null || strRelExpectedEnd.length() == 0) {
            throw new RuntimeException("should-end can't be empty");
        }
        int relExpectedEnd = Integer.parseInt(strRelExpectedEnd);
        if (relExpectedEnd < 0) {
            sla.setExpectedEnd(null);
        } else {
            Date expectedEnd = new Date(nominalTime.getTime() + (long)(relExpectedEnd * 60 * 1000));
            sla.setExpectedEnd(expectedEnd);
        }
        sla.setNotificationMsg(SLADbOperations.getTagElement(eSla, "notification-msg"));
        sla.setAlertContact(SLADbOperations.getTagElement(eSla, "alert-contact"));
        sla.setDevContact(SLADbOperations.getTagElement(eSla, "dev-contact"));
        sla.setQaContact(SLADbOperations.getTagElement(eSla, "qa-contact"));
        sla.setSeContact(SLADbOperations.getTagElement(eSla, "se-contact"));
        sla.setAlertFrequency(SLADbOperations.getTagElement(eSla, "alert-frequency"));
        sla.setAlertPercentage(SLADbOperations.getTagElement(eSla, "alert-percentage"));
        sla.setUpstreamApps(SLADbOperations.getTagElement(eSla, "upstream-apps"));
        sla.setSlaId(slaId);
        sla.setAppType(appType);
        sla.setUser(user);
        sla.setGroupName(groupName);
        sla.setJobStatus(SLAEvent.Status.CREATED);
        sla.setStatusTimestamp(new Date());
        JPAService jpaService = Services.get().get(JPAService.class);
        if (jpaService != null) {
            jpaService.execute(new SLAEventInsertJPAExecutor(sla));
        } else {
            log.error((Object)ErrorCode.E0610);
        }
    }

    public static void writeSlaStatusEvent(String id, SLAEvent.Status status, Store store, SLAEvent.SlaAppType appType) throws Exception {
        SLAEventBean sla = new SLAEventBean();
        sla.setSlaId(id);
        sla.setJobStatus(status);
        sla.setAppType(appType);
        sla.setStatusTimestamp(new Date());
        SLAStore slaStore = Services.get().get(StoreService.class).getStore(SLAStore.class, store);
        slaStore.insertSLAEvent(sla);
    }

    public static void writeSlaStatusEvent(String id, SLAEvent.Status status, SLAEvent.SlaAppType appType, XLog log) throws Exception {
        SLAEventBean sla = new SLAEventBean();
        sla.setSlaId(id);
        sla.setJobStatus(status);
        sla.setAppType(appType);
        sla.setStatusTimestamp(new Date());
        JPAService jpaService = Services.get().get(JPAService.class);
        if (jpaService != null) {
            jpaService.execute(new SLAEventInsertJPAExecutor(sla));
        } else {
            log.error((Object)ErrorCode.E0610);
        }
    }

    public static void writeStausEvent(String slaXml, String id, Store store, SLAEvent.Status stat, SLAEvent.SlaAppType appType) throws CommandException {
        if (slaXml == null || slaXml.length() == 0) {
            return;
        }
        try {
            SLADbOperations.writeSlaStatusEvent(id, stat, store, appType);
        }
        catch (Exception e) {
            throw new CommandException(ErrorCode.E1007, " id " + id, e);
        }
    }

    public static void writeStausEvent(String slaXml, String id, SLAEvent.Status stat, SLAEvent.SlaAppType appType, XLog log) throws CommandException {
        if (slaXml == null || slaXml.length() == 0) {
            return;
        }
        try {
            SLADbOperations.writeSlaStatusEvent(id, stat, appType, log);
        }
        catch (Exception e) {
            throw new CommandException(ErrorCode.E1007, " id " + id, e);
        }
    }

    public static String getClientId() {
        Services services = Services.get();
        if (services == null) {
            throw new RuntimeException("Services is not initialized");
        }
        String clientId = services.getConf().get(CLIENT_ID_TAG, "oozie-default-instance");
        if (clientId == null) {
            throw new RuntimeException("No SLA_CLIENT_ID defined in oozie-site.xml with property name oozie:sla:client-id");
        }
        return clientId;
    }

    private static String getTagElement(Element elem, String tagName) {
        if (elem != null && elem.getChild(tagName, elem.getNamespace("sla")) != null) {
            return elem.getChild(tagName, elem.getNamespace("sla")).getText().trim();
        }
        return null;
    }
}

