/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.workflow.lite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.lite.NodeDef;
import org.apache.oozie.workflow.lite.NodeHandler;

public class JoinNodeDef
extends NodeDef {
    JoinNodeDef() {
    }

    public JoinNodeDef(String name, String transition) {
        super(name, null, JoinNodeHandler.class, Arrays.asList(transition));
    }

    public static class JoinNodeHandler
    extends NodeHandler {
        @Override
        public void loopDetection(NodeHandler.Context context) throws WorkflowException {
            String flag = JoinNodeHandler.getLoopFlag(context.getNodeDef().getName());
            if (context.getVar(flag) != null) {
                throw new WorkflowException(ErrorCode.E0709, context.getNodeDef().getName());
            }
            String parentExecutionPath = context.getParentExecutionPath(context.getExecutionPath());
            String forkCount = context.getVar("workflow.fork." + parentExecutionPath);
            if (forkCount == null) {
                throw new WorkflowException(ErrorCode.E0720, context.getNodeDef().getName());
            }
            int count = Integer.parseInt(forkCount) - 1;
            if (count == 0) {
                context.setVar(flag, "true");
            }
        }

        @Override
        public boolean enter(NodeHandler.Context context) throws WorkflowException {
            String parentExecutionPath = context.getParentExecutionPath(context.getExecutionPath());
            String forkCount = context.getVar("workflow.fork." + parentExecutionPath);
            if (forkCount == null) {
                throw new WorkflowException(ErrorCode.E0720, context.getNodeDef().getName());
            }
            int count = Integer.parseInt(forkCount) - 1;
            if (count > 0) {
                context.setVar("workflow.fork." + parentExecutionPath, "" + count);
                context.deleteExecutionPath();
            } else {
                context.setVar("workflow.fork." + parentExecutionPath, null);
            }
            return count == 0;
        }

        @Override
        public List<String> multiExit(NodeHandler.Context context) {
            String parentExecutionPath = context.getParentExecutionPath(context.getExecutionPath());
            context.deleteExecutionPath();
            String transition = context.getNodeDef().getTransitions().get(0);
            String fullTransition = context.createFullTransition(parentExecutionPath, transition);
            ArrayList<String> transitions = new ArrayList<String>(1);
            transitions.add(fullTransition);
            return transitions;
        }

        @Override
        public String exit(NodeHandler.Context context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void kill(NodeHandler.Context context) {
        }

        @Override
        public void fail(NodeHandler.Context context) {
        }
    }
}

