/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.workflow.lite;

import java.util.ArrayList;
import java.util.List;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.lite.NodeDef;
import org.apache.oozie.workflow.lite.NodeHandler;

public class StartNodeDef
extends NodeDef {
    public static final String START = "::start::";

    public StartNodeDef() {
    }

    public StartNodeDef(String transitionTo) {
        super(START, null, StartNodeHandler.class, StartNodeDef.createList(ParamChecker.notEmpty(transitionTo, "transitionTo")));
    }

    private static List<String> createList(String transition) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(transition);
        return list;
    }

    public static class StartNodeHandler
    extends NodeHandler {
        @Override
        public boolean enter(NodeHandler.Context context) throws WorkflowException {
            if (!context.getSignalValue().equals(StartNodeDef.START)) {
                throw new WorkflowException(ErrorCode.E0715, context.getSignalValue());
            }
            return true;
        }

        @Override
        public String exit(NodeHandler.Context context) {
            return context.getNodeDef().getTransitions().get(0);
        }

        @Override
        public void kill(NodeHandler.Context context) {
        }

        @Override
        public void fail(NodeHandler.Context context) {
        }
    }
}

