/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.database.dialect;

import java.util.Iterator;
import java.util.Map;
import org.pentaho.database.DatabaseDialectException;
import org.pentaho.database.IValueMeta;
import org.pentaho.database.dialect.AbstractDatabaseDialect;
import org.pentaho.database.model.DatabaseAccessType;
import org.pentaho.database.model.DatabaseType;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.model.IDatabaseType;

public class TeradataDatabaseDialect
extends AbstractDatabaseDialect {
    private static final long serialVersionUID = -3869260264366995990L;
    private static final IDatabaseType DBTYPE = new DatabaseType("Teradata", "TERADATA", DatabaseAccessType.getList(DatabaseAccessType.NATIVE, DatabaseAccessType.ODBC, DatabaseAccessType.JNDI), 1025, "http://www.info.ncr.com/eTeradata-BrowseBy-Results.cfm?pl=&PID=&title=%25&release=&kword=CJDBC&sbrn=7&nm=Teradata+Tools+and+Utilities+-+Java+Database+Connectivity+(JDBC)");

    @Override
    public IDatabaseType getDatabaseType() {
        return DBTYPE;
    }

    @Override
    public String getURL(IDatabaseConnection connection) throws DatabaseDialectException {
        if (connection.getAccessType() == DatabaseAccessType.NATIVE) {
            String url = "jdbc:teradata://" + connection.getHostname();
            String sep = "/";
            if (connection.getDatabaseName() != null && connection.getDatabaseName().length() > 0) {
                url = url + "/DATABASE=" + connection.getDatabaseName();
                sep = ",";
            }
            if (connection.getDatabasePort() != null && connection.getDatabasePort().length() > 0) {
                url = url + sep + "DBS_PORT=" + connection.getDatabasePort();
            }
            return url;
        }
        return "jdbc:odbc:" + connection.getDatabaseName();
    }

    @Override
    public String getAddColumnStatement(String tablename, IValueMeta v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String getModifyColumnStatement(String tablename, IValueMeta v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " MODIFY " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (add_fieldname) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: {
                retval = retval + "TIMESTAMP";
                break;
            }
            case 4: {
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    retval = retval + "INTEGER";
                    break;
                }
                if (length > 0) {
                    if (precision > 0 || length > 9) {
                        retval = retval + "DECIMAL(" + length + ", " + precision + ")";
                        break;
                    }
                    if (length > 5) {
                        retval = retval + "INTEGER";
                        break;
                    }
                    if (length < 3) {
                        retval = retval + "BYTEINT";
                        break;
                    }
                    retval = retval + "SMALLINT";
                    break;
                }
                retval = retval + "DOUBLE PRECISION";
                break;
            }
            case 2: {
                if (length > 64000) {
                    retval = retval + "CLOB";
                    break;
                }
                retval = retval + "VARCHAR";
                if (length > 0) {
                    retval = retval + "(" + length + ")";
                    break;
                }
                retval = retval + "(64000)";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (add_cr) {
            retval = retval + " ";
        }
        return retval;
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"terajdbc4.jar", "tdgssjava.jar"};
    }

    @Override
    public String getNativeDriver() {
        return "com.teradata.jdbc.TeraDriver";
    }

    @Override
    public String getNativeJdbcPre() {
        return "jdbc:teradata://";
    }

    @Override
    public int getNotFoundTK(boolean use_autoinc) {
        if (this.supportsAutoInc() && use_autoinc) {
            return 1;
        }
        return super.getNotFoundTK(use_autoinc);
    }

    @Override
    public boolean needsPlaceHolder() {
        return false;
    }

    @Override
    public boolean needsToLockAllTables() {
        return false;
    }

    @Override
    public String getSQLQueryFields(String tableName) {
        return "SELECT * FROM " + tableName + " sample 1";
    }

    @Override
    public String getSQLTableExists(String tablename) {
        return "show table " + tablename;
    }

    @Override
    public String getSQLColumnExists(String columnname, String tablename) {
        return "SELECT * FROM DBC.columns WHERE tablename =" + tablename + " AND columnname =" + columnname;
    }

    public String getSQLQueryColumnFields(String columnname, String tableName) {
        return "SELECT " + columnname + " FROM " + tableName + " sample 1";
    }

    @Override
    public String getLimitClause(int nrRows) {
        return " sample " + Integer.toString(nrRows);
    }

    @Override
    public boolean supportsBitmapIndex() {
        return false;
    }

    @Override
    public String[] getReservedWords() {
        return new String[]{"ABORT", "ABORTSESSION", "ABS", "ABSOLUTE", "ACCESS_LOCK", "ACCOUNT", "ACOS", "ACOSH", "ACTION", "ADD", "ADD_MONTHS", "ADMIN", "AFTER", "AGGREGATE", "ALIAS", "ALL", "ALLOCATE", "ALTER", "AMP", "AND", "ANSIDATE", "ANY", "ARE", "ARRAY", "AS", "ASC", "ASIN", "ASINH", "ASSERTION", "AT", "ATAN", "ATAN2", "ATANH", "ATOMIC", "AUTHORIZATION", "AVE", "AVERAGE", "AVG", "BEFORE", "BEGIN", "BETWEEN", "BINARY", "BIT", "BLOB", "BOOLEAN", "BOTH", "BREADTH", "BT", "BUT", "BY", "BYTE", "BYTEINT", "BYTES", "CALL", "CASCADE", "CASCADED", "CASE", "CASE_N", "CASESPECIFIC", "CAST", "CATALOG", "CD", "CHAR", "CHAR_LENGTH", "CHAR2HEXINT", "CHARACTER", "CHARACTER_LENGTH", "CHARACTERS", "CHARS", "CHECK", "CHECKPOINT", "CLASS", "CLOB", "CLOSE", "CLUSTER", "CM", "COALESCE", "COLLATE", "COLLATION", "COLLECT", "COLUMN", "COMMENT", "COMMIT", "COMPLETION", "COMPRESS", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONSTRUCTOR", "CONTINUE", "CONVERT_TABLE_HEADER", "CORR", "CORRESPONDING", "COS", "COSH", "COUNT", "COVAR_POP", "COVAR_SAMP", "CREATE", "CROSS", "CS", "CSUM", "CT", "CUBE", "CURRENT", "CURRENT_DATE", "CURRENT_PATH", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CV", "CYCLE", "DATA", "DATABASE", "DATABLOCKSIZE", "DATE", "DATEFORM", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DEGREES", "DEL", "DELETE", "DEPTH", "DEREF", "DESC", "DESCRIBE", "DESCRIPTOR", "DESTROY", "DESTRUCTOR", "DETERMINISTIC", "DIAGNOSTIC", "DIAGNOSTICS", "DICTIONARY", "DISABLED", "DISCONNECT", "DISTINCT", "DO", "DOMAIN", "DOUBLE", "DROP", "DUAL", "DUMP", "DYNAMIC", "EACH", "ECHO", "ELSE", "ELSEIF", "ENABLED", "END", "END-EXEC", "EQ", "EQUALS", "ERROR", "ERRORFILES", "ERRORTABLES", "ESCAPE", "ET", "EVERY", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXIT", "EXP", "EXPLAIN", "EXTERNAL", "EXTRACT", "FALLBACK", "FALSE", "FASTEXPORT", "FETCH", "FIRST", "FLOAT", "FOR", "FOREIGN", "FORMAT", "FOUND", "FREE", "FREESPACE", "FROM", "FULL", "FUNCTION", "GE", "GENERAL", "GENERATED", "GET", "GIVE", "GLOBAL", "GO", "GOTO", "GRANT", "GRAPHIC", "GROUP", "GROUPING", "GT", "HANDLER", "HASH", "HASHAMP", "HASHBAKAMP", "HASHBUCKET", "HASHROW", "HAVING", "HELP", "HOST", "HOUR", "IDENTITY", "IF", "IGNORE", "IMMEDIATE", "IN", "INCONSISTENT", "INDEX", "INDICATOR", "INITIALIZE", "INITIALLY", "INITIATE", "INNER", "INOUT", "INPUT", "INS", "INSERT", "INSTEAD", "INT", "INTEGER", "INTEGERDATE", "INTERSECT", "INTERVAL", "INTO", "IS", "ISOLATION", "ITERATE", "JOIN", "JOURNAL", "KEY", "KURTOSIS", "LANGUAGE", "LARGE", "LAST", "LATERAL", "LE", "LEADING", "LEAVE", "LEFT", "LESS", "LEVEL", "LIKE", "LIMIT", "LN", "LOADING", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", "LOCATOR", "LOCK", "LOCKING", "LOG", "LOGGING", "LOGON", "LONG", "LOOP", "LOWER", "LT", "MACRO", "MAP", "MATCH", "MAVG", "MAX", "MAXIMUM", "MCHARACTERS", "MDIFF", "MERGE", "MIN", "MINDEX", "MINIMUM", "MINUS", "MINUTE", "MLINREG", "MLOAD", "MOD", "MODE", "MODIFIES", "MODIFY", "MODULE", "MONITOR", "MONRESOURCE", "MONSESSION", "MONTH", "MSUBSTR", "MSUM", "MULTISET", "NAMED", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NCLOB", "NE", "NEW", "NEW_TABLE", "NEXT", "NO", "NONE", "NOT", "NOWAIT", "NULL", "NULLIF", "NULLIFZERO", "NUMERIC", "OBJECT", "OBJECTS", "OCTET_LENGTH", "OF", "OFF", "OLD", "OLD_TABLE", "ON", "ONLY", "OPEN", "OPERATION", "OPTION", "OR", "ORDER", "ORDINALITY", "OUT", "OUTER", "OUTPUT", "OVER", "OVERLAPS", "OVERRIDE", "PAD", "PARAMETER", "PARAMETERS", "PARTIAL", "PASSWORD", "PATH", "PERCENT", "PERCENT_RANK", "PERM", "PERMANENT", "POSITION", "POSTFIX", "PRECISION", "PREFIX", "PREORDER", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVATE", "PRIVILEGES", "PROCEDURE", "PROFILE", "PROPORTIONAL", "PROTECTION", "PUBLIC", "QUALIFIED", "QUALIFY", "QUANTILE", "RADIANS", "RANDOM", "RANGE_N", "RANK", "READ", "READS", "REAL", "RECURSIVE", "REF", "REFERENCES", "REFERENCING", "REGR_AVGX", "REGR_AVGY", "REGR_COUNT", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXX", "REGR_SXY", "REGR_SYY", "RELATIVE", "RELEASE", "RENAME", "REPEAT", "REPLACE", "REPLICATION", "REPOVERRIDE", "REQUEST", "RESTART", "RESTORE", "RESTRICT", "RESULT", "RESUME", "RET", "RETRIEVE", "RETURN", "RETURNS", "REVALIDATE", "REVOKE", "RIGHT", "RIGHTS", "ROLE", "ROLLBACK", "ROLLFORWARD", "ROLLUP", "ROUTINE", "ROW", "ROW_NUMBER", "ROWID", "ROWS", "SAMPLE", "SAMPLEID", "SAVEPOINT", "SCHEMA", "SCOPE", "SCROLL", "SEARCH", "SECOND", "SECTION", "SEL", "SELECT", "SEQUENCE", "SESSION", "SESSION_USER", "SET", "SETRESRATE", "SETS", "SETSESSRATE", "SHOW", "SIN", "SINH", "SIZE", "SKEW", "SMALLINT", "SOME", "SOUNDEX", "SPACE", "SPECIFIC", "SPECIFICTYPE", "SPOOL", "SQL", "SQLEXCEPTION", "SQLSTATE", "SQLTEXT", "SQLWARNING", "SQRT", "SS", "START", "STARTUP", "STATE", "STATEMENT", "STATIC", "STATISTICS", "STDDEV_POP", "STDDEV_SAMP", "STEPINFO", "STRING_CS", "STRUCTURE", "SUBSCRIBER", "SUBSTR", "SUBSTRING", "SUM", "SUMMARY", "SUSPEND", "SYSTEM_USER", "TABLE", "TAN", "TANH", "TBL_CS", "TEMPORARY", "TERMINATE", "THAN", "THEN", "THRESHOLD", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TITLE", "TO", "TRACE", "TRAILING", "TRANSACTION", "TRANSLATE", "TRANSLATE_CHK", "TRANSLATION", "TREAT", "TRIGGER", "TRIM", "TRUE", "TYPE", "UC", "UNDEFINED", "UNDER", "UNDO", "UNION", "UNIQUE", "UNKNOWN", "UNNEST", "UNTIL", "UPD", "UPDATE", "UPPER", "UPPERCASE", "USAGE", "USER", "USING", "VALUE", "VALUES", "VAR_POP", "VAR_SAMP", "VARBYTE", "VARCHAR", "VARGRAPHIC", "VARIABLE", "VARYING", "VIEW", "VOLATILE", "WAIT", "WHEN", "WHENEVER", "WHERE", "WHILE", "WIDTH_BUCKET", "WITH", "WITHOUT", "WORK", "WRITE", "YEAR", "ZEROIFNULL", "ZONE"};
    }

    @Override
    public String[] getSynonymTypes() {
        return new String[0];
    }

    @Override
    public String getTruncateTableStatement(String tableName) {
        return "DELETE FROM " + tableName;
    }

    @Override
    public String getExtraOptionSeparator() {
        return ",";
    }

    @Override
    public String getExtraOptionValueSeparator() {
        return "=";
    }

    @Override
    public String getExtraOptionIndicator() {
        return "/";
    }

    @Override
    public String getURLWithExtraOptions(IDatabaseConnection connection) throws DatabaseDialectException {
        StringBuffer url = new StringBuffer(this.getURL(connection));
        if (this.supportsOptionsInURL()) {
            String optionIndicator = this.getExtraOptionIndicator();
            String optionSeparator = this.getExtraOptionSeparator();
            String valueSeparator = this.getExtraOptionValueSeparator();
            Map<String, String> map = connection.getExtraOptions();
            if (map.size() > 0) {
                Map.Entry<String, String> mapEntry = null;
                Iterator<Map.Entry<String, String>> it = map.entrySet().iterator();
                boolean first = true;
                while (it.hasNext()) {
                    mapEntry = it.next();
                    String typedParameter = mapEntry.getKey();
                    int dotIndex = typedParameter.indexOf(46);
                    if (dotIndex < 0) continue;
                    String typeCode = typedParameter.substring(0, dotIndex);
                    String parameter = typedParameter.substring(dotIndex + 1);
                    String value = mapEntry.getValue();
                    if (!connection.getDatabaseType().getShortName().equals(typeCode)) continue;
                    if (first && url.indexOf(optionIndicator) == -1) {
                        url.append(optionIndicator);
                    } else {
                        url.append(optionSeparator);
                    }
                    url.append(parameter);
                    if (!TeradataDatabaseDialect.isEmpty(value)) {
                        url.append(valueSeparator).append(value);
                    }
                    first = false;
                }
            }
        }
        return url.toString();
    }
}

