/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.geo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pentaho.agilebi.modeler.nodes.AbstractMetaDataModelNode;
import org.pentaho.agilebi.modeler.nodes.DataRole;
import org.pentaho.agilebi.modeler.nodes.annotations.IDataRoleAnnotation;
import org.pentaho.agilebi.modeler.nodes.annotations.IGeoRoleAnnotation;
import org.pentaho.agilebi.modeler.nodes.annotations.IMemberAnnotation;
import org.pentaho.metadata.model.olap.OlapAnnotation;
import org.pentaho.metadata.model.olap.OlapHierarchyLevel;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.stereotype.Bindable;

public class GeoRole
extends XulEventSourceAdapter
implements DataRole,
Serializable,
IMemberAnnotation,
IDataRoleAnnotation,
IGeoRoleAnnotation {
    private static final long serialVersionUID = 815135675387559794L;
    public static final String ANNOTATTION_GEO_VALUE = "Geography";
    private String name = null;
    private List<String> commonAliases;
    private String matchSeparator = "_";
    private List<GeoRole> requiredParentRoles;
    protected String displayName = "";

    public GeoRole() {
    }

    public GeoRole(String name, List<String> commonAliases) {
        this.name = name;
        this.displayName = name;
        this.commonAliases = commonAliases;
    }

    public GeoRole(String name, String commonAliases) {
        this.name = name;
        this.displayName = name;
        List<String> aliases = GeoRole.parse(commonAliases);
        if (aliases != null) {
            this.commonAliases = aliases;
        }
    }

    public GeoRole(String name, String displayName, String commonAliases) {
        this.name = name;
        this.displayName = displayName;
        List<String> aliases = GeoRole.parse(commonAliases);
        if (aliases != null) {
            this.commonAliases = aliases;
        }
    }

    @Override
    @Bindable
    public String getName() {
        return this.name;
    }

    @Bindable
    public void setName(String name) {
        this.name = name;
    }

    @Bindable
    public String getDisplayName() {
        return this.displayName;
    }

    @Bindable
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public List<String> getCommonAliases() {
        return this.commonAliases;
    }

    public void setCommonAliases(List<String> commonAliases) {
        this.commonAliases = commonAliases;
    }

    public String getMatchSeparator() {
        return this.matchSeparator;
    }

    public void setMatchSeparator(String matchSeparator) {
        this.matchSeparator = matchSeparator;
    }

    public boolean evaluate(String fieldName) {
        if (this.commonAliases == null || fieldName == null || fieldName.length() == 0) {
            return false;
        }
        for (String alias : this.commonAliases) {
            String testAlias;
            String testName = fieldName.toLowerCase();
            if (this.eval(testName, testAlias = alias.toLowerCase())) {
                return true;
            }
            if (this.eval(testName, testAlias.replaceAll(" ", ""))) {
                return true;
            }
            if (!this.eval(testName, testAlias.replaceAll(" ", this.getMatchSeparator()))) continue;
            return true;
        }
        return false;
    }

    protected boolean eval(String fieldName, String alias) {
        return fieldName.equals(alias);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoRole geoRole = (GeoRole)o;
        if (this.commonAliases != null ? !this.commonAliases.equals(geoRole.commonAliases) : geoRole.commonAliases != null) {
            return false;
        }
        if (this.matchSeparator != null ? !this.matchSeparator.equals(geoRole.matchSeparator) : geoRole.matchSeparator != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(geoRole.name) : geoRole.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.commonAliases != null ? this.commonAliases.hashCode() : 0);
        result = 31 * result + (this.matchSeparator != null ? this.matchSeparator.hashCode() : 0);
        return result;
    }

    public GeoRole clone() {
        ArrayList clonedAliases = (ArrayList)((ArrayList)this.commonAliases).clone();
        GeoRole clone = new GeoRole(this.name, clonedAliases);
        return clone;
    }

    protected static List<String> parse(String csv) {
        if (csv != null && csv.length() > 0) {
            String[] tokens = csv.split(",");
            ArrayList<String> aliases = new ArrayList<String>(tokens.length);
            for (String s : tokens) {
                aliases.add(s.trim());
            }
            return aliases;
        }
        return null;
    }

    public void setRequiredParentRoles(List<GeoRole> parentRoles) {
        this.requiredParentRoles = parentRoles;
    }

    public List<GeoRole> getRequiredParentRoles() {
        if (this.requiredParentRoles == null) {
            this.requiredParentRoles = new ArrayList<GeoRole>();
        }
        return this.requiredParentRoles;
    }

    @Override
    public void saveAnnotations(OlapHierarchyLevel level) {
        if (this.getName() == null) {
            return;
        }
        this.clearAnnotations(level);
        level.getAnnotations().add(new OlapAnnotation("Data.Role", ANNOTATTION_GEO_VALUE));
        level.getAnnotations().add(new OlapAnnotation("Geo.Role", this.getName()));
        if (this.getRequiredParentRoles().size() > 0) {
            String parents = this.combineRequiredParents(this);
            level.getAnnotations().add(new OlapAnnotation("Geo.RequiredParents", parents));
        }
    }

    public boolean hasAnnotation(String name, OlapHierarchyLevel level) {
        List annos = level.getAnnotations();
        if (annos == null) {
            return false;
        }
        for (OlapAnnotation anno : annos) {
            if (!anno.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private void clearAnnotations(OlapHierarchyLevel level) {
        List annos = level.getAnnotations();
        if (annos == null) {
            return;
        }
        ArrayList<OlapAnnotation> toRemove = new ArrayList<OlapAnnotation>();
        for (OlapAnnotation anno : annos) {
            String annoName = anno.getName();
            if (!annoName.equals("Geo.RequiredParents") && !annoName.equals("Geo.Role") && !annoName.equals("Data.Role")) continue;
            toRemove.add(anno);
        }
        annos.removeAll(toRemove);
    }

    protected String combineRequiredParents(GeoRole role) {
        if (role.getRequiredParentRoles().size() > 0) {
            StringBuffer sb = new StringBuffer();
            for (GeoRole r : role.getRequiredParentRoles()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(r.getName());
            }
            return sb.toString();
        }
        return null;
    }

    @Override
    public String getDataType() {
        return "Geo.Role";
    }

    @Override
    public String getGeoName() {
        return this.name;
    }

    @Override
    public boolean isValid(AbstractMetaDataModelNode node) {
        return true;
    }

    @Override
    public List<String> getValidationMessages(AbstractMetaDataModelNode node) {
        return Collections.emptyList();
    }

    @Override
    public void onAttach(AbstractMetaDataModelNode node) {
    }

    @Override
    public void onDetach(AbstractMetaDataModelNode node) {
    }
}

