/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.models.annotations;

import org.apache.commons.lang.StringUtils;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.models.annotations.AnnotationType;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotation;
import org.pentaho.agilebi.modeler.models.annotations.ModelProperty;
import org.pentaho.agilebi.modeler.models.annotations.util.MondrianSchemaHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.persist.MetaStoreAttribute;
import org.w3c.dom.Document;

public class UpdateAttribute
extends AnnotationType {
    private static final long serialVersionUID = 1201984935190601808L;
    public static final String NAME_ID = "name";
    public static final String NAME_NAME = "New Attribute Name";
    public static final int NAME_ORDER = 0;
    public static final String CUBE_ID = "cube";
    public static final String CUBE_NAME = "Cube";
    public static final int CUBE_ORDER = 1;
    public static final String DIMENSION_ID = "dimension";
    public static final String DIMENSION_NAME = "Dimension";
    public static final int DIMENSION_ORDER = 2;
    public static final String HIERARCHY_ID = "hierarchy";
    public static final String HIERARCHY_NAME = "Hierarchy";
    public static final int HIERARCHY_ORDER = 3;
    public static final String LEVEL_ID = "level";
    public static final String LEVEL_NAME = "Level";
    public static final int LEVEL_ORDER = 4;
    public static final String FORMAT_STRING_ID = "formatString";
    public static final String FORMAT_STRING_NAME = "Format String";
    public static final int FORMAT_STRING_ORDER = 5;
    @MetaStoreAttribute
    @ModelProperty(id="name", name="New Attribute Name", order=0)
    protected String name;
    @MetaStoreAttribute
    @ModelProperty(id="cube", name="Cube", order=1)
    protected String cube;
    @MetaStoreAttribute
    @ModelProperty(id="dimension", name="Dimension", order=2)
    protected String dimension;
    @MetaStoreAttribute
    @ModelProperty(id="hierarchy", name="Hierarchy", order=3)
    protected String hierarchy;
    @MetaStoreAttribute
    @ModelProperty(id="level", name="Level", order=4)
    protected String level;
    @MetaStoreAttribute
    @ModelProperty(id="formatString", name="Format String", order=5)
    protected String formatString;

    @Override
    public boolean apply(ModelerWorkspace workspace, IMetaStore metaStore) throws ModelerException {
        return false;
    }

    @Override
    public boolean apply(Document schema) throws ModelerException {
        MondrianSchemaHandler schemaHandler = new MondrianSchemaHandler(schema);
        boolean captioned = schemaHandler.captionLevel(this.getCube(), this.getDimension(), this.getHierarchy(), this.getLevel(), this.getName());
        if (captioned) {
            if (!StringUtils.isBlank((String)this.getFormatString())) {
                return schemaHandler.formatLevel(this.getCube(), this.getDimension(), this.getHierarchy(), this.getLevel(), this.getFormatString());
            }
            return schemaHandler.removeFormatting(this.getCube(), this.getDimension(), this.getHierarchy(), this.getLevel());
        }
        return false;
    }

    @Override
    public void validate() throws ModelerException {
        if (StringUtils.isBlank((String)this.getCube())) {
            throw new ModelerException(BaseMessages.getString((Class)MSG_CLASS, (String)"ModelAnnotation.UpdateAttribute.validation.CUBE_NAME_REQUIRED", (String[])new String[0]));
        }
        if (StringUtils.isBlank((String)this.getDimension())) {
            throw new ModelerException(BaseMessages.getString((Class)MSG_CLASS, (String)"ModelAnnotation.UpdateAttribute.validation.DIMENSION_NAME_REQUIRED", (String[])new String[0]));
        }
        if (StringUtils.isBlank((String)this.getHierarchy())) {
            throw new ModelerException(BaseMessages.getString((Class)MSG_CLASS, (String)"ModelAnnotation.UpdateAttribute.validation.HIERARCHY_NAME_REQUIRED", (String[])new String[0]));
        }
        if (StringUtils.isBlank((String)this.getLevel())) {
            throw new ModelerException(BaseMessages.getString((Class)MSG_CLASS, (String)"ModelAnnotation.UpdateAttribute.validation.LEVEL_NAME_REQUIRED", (String[])new String[0]));
        }
        if (StringUtils.isBlank((String)this.getName())) {
            throw new ModelerException(BaseMessages.getString((Class)MSG_CLASS, (String)"ModelAnnotation.UpdateAttribute.validation.NAME_REQUIRED", (String[])new String[0]));
        }
    }

    @Override
    public ModelAnnotation.Type getType() {
        return ModelAnnotation.Type.UPDATE_ATTRIBUTE;
    }

    @Override
    public String getSummary() {
        return BaseMessages.getString((Class)MSG_CLASS, (String)"Modeler.UpdateAttribute.Summary", (String[])new String[]{this.level, this.hierarchy, this.dimension, this.cube});
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getField() {
        return null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCube(String cube) {
        this.cube = cube;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public void setHierarchy(String hierarchy) {
        this.hierarchy = hierarchy;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getCube() {
        return this.cube;
    }

    public String getDimension() {
        return this.dimension;
    }

    public String getHierarchy() {
        return this.hierarchy;
    }

    public String getLevel() {
        return this.level;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public void setFormatString(String formatString) {
        this.formatString = formatString;
    }
}

