/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.models.annotations;

import java.util.Iterator;
import java.util.logging.Logger;
import mondrian.olap.MondrianDef;
import org.apache.commons.lang.StringUtils;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.models.annotations.AnnotationType;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotation;
import org.pentaho.agilebi.modeler.models.annotations.ModelProperty;
import org.pentaho.agilebi.modeler.models.annotations.util.MondrianSchemaHandler;
import org.pentaho.agilebi.modeler.nodes.MeasureMetaData;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.metadata.util.MondrianModelExporter;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.persist.MetaStoreAttribute;
import org.pentaho.metastore.persist.MetaStoreElementType;
import org.w3c.dom.Document;

@MetaStoreElementType(name="UpdateMeasure", description="UpdateMeasure Annotation")
public class UpdateMeasure
extends AnnotationType {
    private static final long serialVersionUID = -8365062607663928537L;
    private static transient Logger logger = Logger.getLogger(AnnotationType.class.getName());
    private static final String NAME_ID = "name";
    private static final String NAME_NAME = "Name";
    private static final int NAME_ORDER = 0;
    private static final String CUBE_ID = "cube";
    private static final String CUBE_NAME = "Cube";
    private static final int CUBE_ORDER = 1;
    private static final String AGGREGATION_TYPE_ID = "aggregationType";
    private static final String AGGREGATION_TYPE_NAME = "Aggregation Type";
    private static final int AGGREGATION_TYPE_ORDER = 2;
    private static final String FORMAT_ID = "format";
    private static final String FORMAT_NAME = "Format";
    private static final int FORMAT_ORDER = 3;
    private static final String MEASURE_ID = "measure";
    private static final String MEASURE_NAME = "Measure";
    private static final int MEASURE_ORDER = 4;
    private static final String CAPTION_ID = "caption";
    private static final String CAPTION_NAME = "Caption";
    private static final int CAPTION_ORDER = 5;
    @MetaStoreAttribute
    @ModelProperty(id="name", name="Name", order=0)
    private String name;
    @MetaStoreAttribute
    @ModelProperty(id="measure", name="Measure", order=4)
    private String measure;
    @MetaStoreAttribute
    @ModelProperty(id="cube", name="Cube", order=1)
    private String cube;
    @MetaStoreAttribute
    @ModelProperty(id="aggregationType", name="Aggregation Type", order=2)
    private AggregationType aggregationType;
    @MetaStoreAttribute
    @ModelProperty(id="format", name="Format", order=3)
    private String format;
    @MetaStoreAttribute
    @ModelProperty(id="caption", name="Caption", order=5)
    private String caption;

    private MeasureMetaData locateMeasureFromFormula(ModelerWorkspace workspace, String formula) {
        if (formula == null || workspace == null) {
            return null;
        }
        Iterator iterator = workspace.getModel().getMeasures().iterator();
        while (iterator.hasNext()) {
            MeasureMetaData measureMetaData = (MeasureMetaData)iterator.next();
            StringBuilder formulaBuilder = new StringBuilder();
            formulaBuilder.append("[Measures].[");
            formulaBuilder.append(measureMetaData.getName());
            formulaBuilder.append("]");
            if (!formula.equals(formulaBuilder.toString())) continue;
            return measureMetaData;
        }
        return null;
    }

    @Override
    public boolean apply(ModelerWorkspace workspace, IMetaStore metaStore) throws ModelerException {
        if (workspace == null) {
            throw new ModelerException(BaseMessages.getString((Class)MSG_CLASS, (String)"MondrianSchemaHelper.updateMeasure.UNABLE_TO_FIND_MEASURE", (String[])new String[0]));
        }
        MeasureMetaData existingMeasure = this.locateMeasureFromFormula(workspace, this.measure);
        if (existingMeasure == null) {
            return false;
        }
        StringBuilder newMeasureFormula = new StringBuilder();
        newMeasureFormula.append("[Measures].[");
        newMeasureFormula.append(this.name);
        newMeasureFormula.append("]");
        MeasureMetaData prexistingMeasure = this.locateMeasureFromFormula(workspace, newMeasureFormula.toString());
        if (!newMeasureFormula.toString().equals(this.measure) && prexistingMeasure != null) {
            return false;
        }
        if (this.aggregationType != null) {
            existingMeasure.setDefaultAggregation(this.aggregationType);
        }
        existingMeasure.setFormat(this.format);
        if (!StringUtils.isBlank((String)this.name)) {
            existingMeasure.setName(this.name);
        }
        workspace.getWorkspaceHelper().populateDomain(workspace);
        return true;
    }

    @Override
    public boolean apply(Document schema) throws ModelerException {
        MondrianSchemaHandler mondrianSchemaHandler;
        if (schema == null) {
            throw new ModelerException(BaseMessages.getString((Class)MSG_CLASS, (String)"MondrianSchemaHelper.updateMeasure.UNABLE_TO_FIND_MEASURE", (String[])new String[0]));
        }
        String mondrianAggregationType = null;
        if (this.aggregationType != null) {
            mondrianAggregationType = MondrianModelExporter.convertToMondrian((AggregationType)this.aggregationType);
        }
        if ((mondrianSchemaHandler = new MondrianSchemaHandler(schema)).isCalculatedMeasure(this.cube, this.measure)) {
            return mondrianSchemaHandler.updateCalculatedMeasure(this.cube, this.measure, this.caption, this.format);
        }
        MondrianDef.Measure updatedMeasure = new MondrianDef.Measure();
        updatedMeasure.name = this.name;
        updatedMeasure.aggregator = mondrianAggregationType;
        updatedMeasure.formatString = this.format;
        updatedMeasure.caption = this.caption;
        return mondrianSchemaHandler.updateMeasure(this.cube, this.measure, updatedMeasure);
    }

    @Override
    public void validate() throws ModelerException {
        if (StringUtils.isBlank((String)this.measure)) {
            throw new ModelerException(BaseMessages.getString((Class)MSG_CLASS, (String)"ModelAnnotation.UpdateMeasure.validation.MEASURE_NAME_REQUIRED", (String[])new String[0]));
        }
    }

    @Override
    public ModelAnnotation.Type getType() {
        return ModelAnnotation.Type.UPDATE_MEASURE;
    }

    private String summaryMsgKey() {
        return "Modeler.UpdateMeasure.Summary";
    }

    @Override
    public String getSummary() {
        return BaseMessages.getString((Class)MSG_CLASS, (String)this.summaryMsgKey(), (String[])new String[]{this.getMeasure(), this.getName()});
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMeasure() {
        return this.measure;
    }

    public void setMeasure(String measure) {
        this.measure = measure;
    }

    public String getCube() {
        return this.cube;
    }

    public void setCube(String cube) {
        this.cube = cube;
    }

    @Override
    public String getField() {
        return null;
    }

    public AggregationType getAggregationType() {
        return this.aggregationType;
    }

    public void setAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }
}

