/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.nodes;

import java.util.HashMap;
import org.pentaho.agilebi.modeler.ColumnBackedNode;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerMessagesHolder;
import org.pentaho.agilebi.modeler.ModelerPerspective;
import org.pentaho.agilebi.modeler.nodes.AbstractMetaDataModelNode;
import org.pentaho.agilebi.modeler.nodes.AvailableField;
import org.pentaho.agilebi.modeler.nodes.HierarchyMetaData;
import org.pentaho.agilebi.modeler.nodes.LevelMetaData;
import org.pentaho.agilebi.modeler.nodes.MeasureMetaData;
import org.pentaho.agilebi.modeler.propforms.DimensionPropertiesForm;
import org.pentaho.ui.xul.stereotype.Bindable;

public class DimensionMetaData
extends AbstractMetaDataModelNode<HierarchyMetaData> {
    private static final long serialVersionUID = -891901735974255178L;
    String name;
    String dimensionType = "StandardDimension";
    private static final String CLASSNAME = "pentaho-smalldimensionbutton";

    public DimensionMetaData() {
        super(CLASSNAME);
    }

    public DimensionMetaData(String name) {
        this(name, "StandardDimension");
    }

    public DimensionMetaData(String name, String dimensionType) {
        this();
        this.name = name;
        this.dimensionType = dimensionType;
    }

    @Bindable
    public String getName() {
        return this.name;
    }

    @Bindable
    public String getDisplayName() {
        return this.getName();
    }

    @Bindable
    public void setName(String name) {
        if (!name.equals(this.name)) {
            String oldName = this.name;
            this.name = name;
            this.firePropertyChange("name", oldName, name);
            this.firePropertyChange("displayName", oldName, name);
            this.validateNode();
        }
    }

    @Bindable
    public String getDimensionType() {
        return this.dimensionType;
    }

    @Bindable
    public void setDimensionType(String type) {
        String oldType = this.dimensionType;
        if (oldType.equals(type)) {
            return;
        }
        this.dimensionType = type;
        this.firePropertyChange("dimensionType", oldType, type);
    }

    @Bindable
    public boolean isTimeDimension() {
        return DimensionMetaData.isTimeDimension(this.dimensionType);
    }

    static boolean isTimeDimension(String dimensionType) {
        return "TimeDimension".equals(dimensionType);
    }

    @Bindable
    public void setTimeDimension(boolean timeDimension) {
        boolean oldTimeDimension = this.isTimeDimension();
        if (timeDimension == oldTimeDimension) {
            return;
        }
        this.setDimensionType(timeDimension ? "TimeDimension" : "StandardDimension");
        this.firePropertyChange("timeDimension", oldTimeDimension, timeDimension);
        this.validateNode();
    }

    @Bindable
    public String toString() {
        return "Dimension Name: " + this.name;
    }

    @Override
    @Bindable
    public String getValidImage() {
        return "images/sm_dim_icon.png";
    }

    @Override
    @Bindable
    public void validate() {
        this.validationMessages.clear();
        this.valid = true;
        if (this.name == null || "".equals(this.name)) {
            this.validationMessages.add(ModelerMessagesHolder.getMessages().getString("validation.dimension.MISSING_NAME", new String[0]));
            this.valid = false;
        }
        if (this.size() == 0) {
            this.validationMessages.add(ModelerMessagesHolder.getMessages().getString("validation.dimension.REQUIRES_AT_LEAST_ONE_HIERARCHY", new String[0]));
            this.valid = false;
        }
        HashMap<String, HierarchyMetaData> usedNames = new HashMap<String, HierarchyMetaData>();
        for (HierarchyMetaData hier : this.children) {
            hier.validate();
            this.valid &= hier.isValid();
            this.validationMessages.addAll(hier.getValidationMessages());
            if (usedNames.containsKey(hier.getName())) {
                HierarchyMetaData h;
                this.valid = false;
                String msg = ModelerMessagesHolder.getMessages().getString("validation.dimension.DUPLICATE_HIERARCHY_NAMES", hier.getName());
                this.validationMessages.add(msg);
                hier.invalidate();
                if (!hier.getValidationMessages().contains(msg)) {
                    hier.getValidationMessages().add(msg);
                }
                if (!(h = (HierarchyMetaData)usedNames.get(hier.getName())).isValid()) continue;
                h.invalidate();
                if (h.getValidationMessages().contains(msg)) continue;
                h.getValidationMessages().add(msg);
                continue;
            }
            usedNames.put(hier.getName(), hier);
        }
    }

    @Bindable
    public boolean equals(DimensionMetaData obj) {
        if (obj instanceof DimensionMetaData) {
            DimensionMetaData dim = obj;
            return this.name != null && this.name.equals(dim.name);
        }
        return false;
    }

    @Bindable
    public boolean isTime() {
        return this.isTimeDimension();
    }

    @Bindable
    public boolean isUiExpanded() {
        return true;
    }

    @Bindable
    public boolean isEditingDisabled() {
        return false;
    }

    @Override
    public Class<DimensionPropertiesForm> getPropertiesForm() {
        return DimensionPropertiesForm.class;
    }

    @Override
    public void onAdd(HierarchyMetaData child) {
        child.addPropertyChangeListener("name", this.nameListener);
        child.addPropertyChangeListener("valid", this.validListener);
        child.addPropertyChangeListener("children", this.childrenListener);
        this.validateNode();
    }

    @Override
    public void onRemove(HierarchyMetaData child) {
        child.removePropertyChangeListener(this.validListener);
        child.removePropertyChangeListener(this.nameListener);
        child.removePropertyChangeListener(this.childrenListener);
        this.validateNode();
    }

    @Override
    public boolean acceptsDrop(Object obj) {
        return obj instanceof AvailableField || obj instanceof HierarchyMetaData || obj instanceof LevelMetaData || obj instanceof MeasureMetaData;
    }

    @Override
    public Object onDrop(Object data) throws ModelerException {
        try {
            if (data instanceof AvailableField) {
                ColumnBackedNode node = this.getWorkspace().createColumnBackedNode((AvailableField)data, ModelerPerspective.ANALYSIS);
                return this.getWorkspace().createHierarchyForParentWithNode(this, node);
            }
            if (data instanceof HierarchyMetaData) {
                return data;
            }
            if (data instanceof LevelMetaData) {
                LevelMetaData level = (LevelMetaData)data;
                HierarchyMetaData hier = this.getWorkspace().createHierarchyForParentWithNode(this, level);
                hier.setName(level.getName());
                ((LevelMetaData)hier.get(0)).setName(level.getName());
                return hier;
            }
            if (data instanceof MeasureMetaData) {
                MeasureMetaData measure = (MeasureMetaData)data;
                HierarchyMetaData hier = this.getWorkspace().createHierarchyForParentWithNode(this, measure);
                hier.setName(measure.getName());
                ((LevelMetaData)hier.get(0)).setName(measure.getName());
                return hier;
            }
            throw new IllegalArgumentException(ModelerMessagesHolder.getMessages().getString("invalid_drop", new String[0]));
        }
        catch (Exception e) {
            throw new ModelerException(e);
        }
    }
}

