/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.nodes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerMessagesHolder;
import org.pentaho.agilebi.modeler.ModelerPerspective;
import org.pentaho.agilebi.modeler.nodes.AbstractMetaDataModelNode;
import org.pentaho.agilebi.modeler.nodes.AvailableField;
import org.pentaho.agilebi.modeler.nodes.AvailableTable;
import org.pentaho.agilebi.modeler.nodes.MeasureMetaData;
import org.pentaho.agilebi.modeler.propforms.GenericPropertiesForm;
import org.pentaho.agilebi.modeler.propforms.ModelerNodePropertiesForm;
import org.pentaho.metadata.model.IPhysicalTable;
import org.pentaho.ui.xul.stereotype.Bindable;

public class MeasuresCollection
extends AbstractMetaDataModelNode<MeasureMetaData>
implements Serializable {
    private static final long serialVersionUID = 5827211352596188503L;
    private String name = "Measures";
    public static String MEASURE_PROP = "potential_measure";
    private static final String CLASSNAME = "pentaho-smallcategorybutton";

    public MeasuresCollection() {
        super(CLASSNAME);
        this.valid = false;
    }

    @Bindable
    public String getName() {
        return this.name;
    }

    @Bindable
    public String getDisplayName() {
        return this.getName();
    }

    @Bindable
    public void setName(String name) {
        this.name = name;
    }

    @Bindable
    public boolean isUiExpanded() {
        return true;
    }

    @Override
    @Bindable
    public String getValidImage() {
        return "images/sm_folder_icon.png";
    }

    @Override
    public void validate() {
        this.valid = true;
        this.validationMessages.clear();
        if (this.size() == 0) {
            this.validationMessages.add(ModelerMessagesHolder.getMessages().getString("validation.measurecollecion.REQUIRES_AT_LEAST_ONE_MEASURE", new String[0]));
            this.valid = false;
        }
        HashMap<String, MeasureMetaData> usedNames = new HashMap<String, MeasureMetaData>();
        for (MeasureMetaData measure : this.children) {
            this.valid &= measure.isValid();
            this.validationMessages.addAll(measure.getValidationMessages());
            if (usedNames.containsKey(measure.getName())) {
                MeasureMetaData m;
                this.valid = false;
                String msg = ModelerMessagesHolder.getMessages().getString("validation.measurecollecion.DUPLICATE_MEASURE_NAMES", measure.getName());
                this.validationMessages.add(msg);
                measure.invalidate();
                if (!measure.getValidationMessages().contains(msg)) {
                    measure.getValidationMessages().add(msg);
                }
                if (!(m = (MeasureMetaData)usedNames.get(measure.getName())).isValid()) continue;
                m.invalidate();
                if (m.getValidationMessages().contains(msg)) continue;
                m.getValidationMessages().add(msg);
                continue;
            }
            usedNames.put(measure.getName(), measure);
        }
        if (!this.suppressEvents) {
            this.firePropertyChange("valid", null, this.valid);
        }
    }

    @Override
    public void onAdd(MeasureMetaData child) {
        child.setParent(this);
        child.addPropertyChangeListener("name", this.nameListener);
        child.addPropertyChangeListener("valid", this.validListener);
        child.addPropertyChangeListener("children", this.childrenListener);
        this.validateNode();
    }

    @Override
    public void onRemove(MeasureMetaData child) {
        child.removePropertyChangeListener(this.validListener);
        child.removePropertyChangeListener(this.nameListener);
        child.removePropertyChangeListener(this.childrenListener);
        this.validateNode();
    }

    @Bindable
    public boolean isEditingDisabled() {
        return true;
    }

    @Override
    public Class<? extends ModelerNodePropertiesForm> getPropertiesForm() {
        return GenericPropertiesForm.class;
    }

    @Override
    public boolean acceptsDrop(Object obj) {
        AvailableField field;
        boolean isSupportedType = false;
        boolean bl = isSupportedType = obj instanceof AvailableField || obj instanceof AvailableTable || obj instanceof MeasureMetaData;
        if (!isSupportedType) {
            return false;
        }
        if (obj instanceof MeasureMetaData) {
            return true;
        }
        return obj instanceof AvailableField ? this.isFactTable((field = (AvailableField)obj).getPhysicalColumn().getPhysicalTable()) || this.getWorkspace().getAvailableTables().size() == 1 : obj instanceof AvailableTable && (this.isFactTable((field = (AvailableTable)obj).getPhysicalTable()) || this.getWorkspace().getAvailableTables().size() == 1);
    }

    private boolean isFactTable(IPhysicalTable table) {
        String agileBiVersion = (String)this.getWorkspace().getLogicalModel(ModelerPerspective.ANALYSIS).getProperty("AGILE_BI_VERSION");
        if (agileBiVersion != null && (double)Float.parseFloat(agileBiVersion) >= 2.0 && this.getWorkspace().getAvailableTables().size() > 1) {
            Object factProp = table.getProperty("FACT_TABLE");
            return factProp != null && !factProp.equals(Boolean.FALSE);
        }
        return false;
    }

    @Override
    public Object onDrop(Object data) throws ModelerException {
        try {
            Object factProp;
            MeasureMetaData measure = null;
            if (data instanceof AvailableField) {
                measure = this.getWorkspace().createMeasureForNode((AvailableField)data);
            } else {
                if (data instanceof AvailableTable) {
                    MeasureMetaData firstField;
                    AvailableTable table = (AvailableTable)data;
                    ArrayList<MeasureMetaData> measureList = new ArrayList<MeasureMetaData>();
                    for (AvailableField field : table.getChildren()) {
                        measureList.add(this.getWorkspace().createMeasureForNode(field));
                    }
                    MeasureMetaData measureMetaData = firstField = measureList.size() > 0 ? (MeasureMetaData)measureList.get(0) : null;
                    if (firstField != null) {
                        measureList.remove(firstField);
                    }
                    this.addAll(measureList);
                    return firstField;
                }
                if (data instanceof MeasureMetaData) {
                    measure = (MeasureMetaData)data;
                    measure.setParent(this);
                } else {
                    throw new IllegalArgumentException(ModelerMessagesHolder.getMessages().getString("invalid_drop", new String[0]));
                }
            }
            String agileBiVersion = (String)this.getWorkspace().getLogicalModel(ModelerPerspective.ANALYSIS).getProperty("AGILE_BI_VERSION");
            if (measure != null && agileBiVersion != null && (double)Float.parseFloat(agileBiVersion) >= 2.0 && this.getWorkspace().getAvailableTables().size() > 1 && ((factProp = measure.getLogicalColumn().getLogicalTable().getPhysicalTable().getProperty("FACT_TABLE")) == null || factProp.equals(Boolean.FALSE))) {
                throw new IllegalStateException(ModelerMessagesHolder.getMessages().getString("DROP.ERROR.NON_FACT_TABLE", new String[0]));
            }
            return measure;
        }
        catch (Exception e) {
            throw new ModelerException(e);
        }
    }
}

