/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.nodes;

import java.util.Arrays;
import java.util.List;
import org.pentaho.agilebi.modeler.nodes.DataRole;
import org.pentaho.ui.xul.stereotype.Bindable;

public class TimeRole
implements DataRole {
    private static final long serialVersionUID = -1386985942519602868L;
    private static final String DEFAULT_NAME = "time";
    public String name;
    public String[] formats;
    public List<String> formatsList;
    public static final TimeRole DUMMY = new TimeRole("", new String[0]);
    public static final TimeRole YEARS = new TimeRole("Years", new String[]{"yy", "yyyy"});
    public static final TimeRole HALFYEARS = new TimeRole("HalfYears", new String[0]);
    public static final TimeRole QUARTERS = new TimeRole("Quarters", new String[]{"Q", "QQ", "QQQ"});
    public static final TimeRole MONTHS = new TimeRole("Months", new String[]{"M", "MM", "MMM"});
    public static final TimeRole WEEKS = new TimeRole("Weeks", new String[]{"w", "ww", "W"});
    public static final TimeRole DAYS = new TimeRole("Days", new String[]{"d", "dd", "D", "DDD", "yyyy-MM-dd"});
    public static final TimeRole HOURS = new TimeRole("Hours", new String[]{"k", "kk", "H", "HH", "K", "KK"});
    public static final TimeRole MINUTES = new TimeRole("Minutes", new String[]{"m", "mm"});
    public static final TimeRole SECONDS = new TimeRole("Seconds", new String[]{"s", "ss"});
    public static final TimeRole[] ALL_ROLES = new TimeRole[]{DUMMY, YEARS, HALFYEARS, QUARTERS, MONTHS, WEEKS, DAYS, HOURS, MINUTES, SECONDS};
    private static final List<TimeRole> allRoles = Arrays.asList(ALL_ROLES);

    public TimeRole(String name, String[] formats) {
        this.name = name;
        this.formats = formats;
        this.formatsList = Arrays.asList(formats);
    }

    @Override
    @Bindable
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return DEFAULT_NAME;
    }

    @Bindable
    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getName();
    }

    public List<String> getFormatsList() {
        return this.formatsList;
    }

    @Bindable
    public String getMondrianAttributeValue() {
        return "Time" + this.name;
    }

    public static String mondrianAttributeValueToRoleName(String mondrianAttributeValue) {
        return mondrianAttributeValue.substring("Time".length());
    }

    public static TimeRole fromMondrianAttributeValue(String mondrianAttributeValue) {
        for (TimeRole role : allRoles) {
            if (!role.getMondrianAttributeValue().equals(mondrianAttributeValue)) continue;
            return role;
        }
        return null;
    }

    public boolean equals(Object obj) {
        boolean eq;
        if (obj instanceof TimeRole) {
            TimeRole timeRoleObject = (TimeRole)obj;
            eq = this.getName().equals(timeRoleObject.getName());
        } else {
            eq = false;
        }
        return eq;
    }

    public static TimeRole findRoleByName(String name) {
        for (TimeRole role : ALL_ROLES) {
            if (!role.getName().equals(name)) continue;
            return role;
        }
        return null;
    }

    public static final List<TimeRole> getAllRoles() {
        return allRoles;
    }
}

