/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.propforms;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.pentaho.agilebi.modeler.ModelerMessagesHolder;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.geo.GeoRole;
import org.pentaho.agilebi.modeler.nodes.BaseColumnBackedMetaData;
import org.pentaho.agilebi.modeler.nodes.DataRole;
import org.pentaho.agilebi.modeler.nodes.HierarchyMetaData;
import org.pentaho.agilebi.modeler.nodes.LevelMetaData;
import org.pentaho.agilebi.modeler.nodes.TimeRole;
import org.pentaho.agilebi.modeler.nodes.annotations.IMemberAnnotation;
import org.pentaho.agilebi.modeler.propforms.AbstractModelerNodeForm;
import org.pentaho.metadata.model.IPhysicalColumn;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulCheckbox;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.components.XulMenuList;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulVbox;
import org.pentaho.ui.xul.stereotype.Bindable;

public class LevelsPropertiesForm
extends AbstractModelerNodeForm<BaseColumnBackedMetaData> {
    private static final long serialVersionUID = 7387695478794340469L;
    protected XulTextbox name;
    protected XulCheckbox hasUniqueMembers;
    protected XulLabel sourceLabel;
    protected XulLabel ordinalLabel;
    protected XulLabel level_message_label;
    protected XulVbox messageBox;
    protected String colName;
    protected String ordinalColName;
    protected XulButton clearOrdinalColumnBtn;
    protected String captionColName;
    protected String locale;
    protected XulButton messageBtn;
    protected XulMenuList geoList;
    protected XulMenuList timeLevelTypeList;
    protected XulMenuList timeLevelFormatList;
    protected String timeLevelFormat;
    protected List<GeoRole> geoRoles = new ArrayList<GeoRole>();
    protected GeoRole selectedGeoRole;
    protected GeoRole dummyGeoRole = new GeoRole(ModelerMessagesHolder.getMessages().getString("none", new String[0]), Collections.emptyList());
    protected List<TimeRole> timeRoles = new ArrayList<TimeRole>();
    protected TimeRole selectedTimeLevelType = TimeRole.DUMMY;
    protected PropertyChangeListener validListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (propertyName.equals("valid") || propertyName.equals("logicalColumn") || propertyName.equals("logicalOrdinalColumn") || propertyName.equals("ordinalColumnName") || propertyName.equals("logicalCaptionColumn") || propertyName.equals("timeLevelFormat")) {
                LevelsPropertiesForm.this.showValidations();
            }
        }
    };

    public LevelsPropertiesForm(String panelId, String locale) {
        super(panelId);
        this.locale = locale;
    }

    public LevelsPropertiesForm(String locale) {
        this("levelprops", locale);
    }

    @Override
    public void setObject(BaseColumnBackedMetaData metadata) {
        LevelMetaData levelMetaData = (LevelMetaData)metadata;
        if (this.getNode() != null) {
            ((BaseColumnBackedMetaData)this.getNode()).removePropertyChangeListener(this.validListener);
        }
        this.setNode(levelMetaData);
        if (levelMetaData == null) {
            return;
        }
        ((BaseColumnBackedMetaData)this.getNode()).addPropertyChangeListener(this.validListener);
        this.name.setValue(levelMetaData.getName());
        this.setColumnName(this.getColumnNameFromLogicalColumn(levelMetaData.getLogicalColumn()));
        this.ordinalColName = "";
        this.setOrdinalColumnName(this.getColumnNameFromLogicalColumn(levelMetaData.getLogicalOrdinalColumn()));
        this.hasUniqueMembers.setChecked(levelMetaData.isUniqueMembers());
        Map<String, IMemberAnnotation> annotations = levelMetaData.getMemberAnnotations();
        if (levelMetaData.isTimeLevel()) {
            this.setGeoLevelElementsVisible(false);
            this.setTimeLevelElementsVisible(true);
            DataRole dataRole = ((BaseColumnBackedMetaData)this.getNode()).getDataRole();
            this.setSelectedTimeLevelType(dataRole instanceof TimeRole ? (TimeRole)dataRole : TimeRole.DUMMY);
        } else {
            this.setGeoLevelElementsVisible(true);
            this.setTimeLevelElementsVisible(false);
            GeoRole geoRole = (GeoRole)annotations.get("Geo.Role");
            this.setSelectedGeoRole(geoRole);
            if (this.selectedGeoRole == null) {
                this.setSelectedGeoRole(this.dummyGeoRole);
            }
        }
        this.showValidations();
    }

    protected void showValidations() {
        if (this.getNode() == null) {
            return;
        }
        this.setNotValid(!((BaseColumnBackedMetaData)this.getNode()).isValid());
        LogicalColumn logicalColumn = ((BaseColumnBackedMetaData)this.getNode()).getLogicalColumn();
        this.setBackingColumnAvailable(logicalColumn != null);
        this.setColumnName(this.getColumnNameFromLogicalColumn(logicalColumn));
        logicalColumn = ((BaseColumnBackedMetaData)this.getNode()).getLogicalOrdinalColumn();
        this.setOrdinalColumnName(this.getColumnNameFromLogicalColumn(logicalColumn));
        this.messageBox.setVisible(((BaseColumnBackedMetaData)this.getNode()).getValidationMessages().size() > 0);
        this.setValidMessages(((BaseColumnBackedMetaData)this.getNode()).getValidationMessagesString());
    }

    protected void setGeoLevelElementsVisible(boolean visible) {
        this.setContainerVisible("geo_level_elements", visible);
    }

    protected void setTimeLevelElementsVisible(boolean visible) {
        this.setContainerVisible("time_level_elements", visible);
    }

    @Override
    public void init(ModelerWorkspace workspace) {
        super.init(workspace);
        this.bf.createBinding((Object)this, "notValid", "level_message", "visible", new BindingConvertor[0]);
        this.name = (XulTextbox)this.document.getElementById("level_name");
        this.hasUniqueMembers = (XulCheckbox)this.document.getElementById("has_unique_members");
        this.sourceLabel = (XulLabel)this.document.getElementById("level_source_col");
        this.ordinalLabel = (XulLabel)this.document.getElementById("level_ordinal_col");
        this.clearOrdinalColumnBtn = (XulButton)this.document.getElementById("clear_ordinal_column");
        this.level_message_label = (XulLabel)this.document.getElementById("level_message_label");
        this.messageBox = (XulVbox)this.document.getElementById("level_message");
        this.bf.createBinding((Object)this, "backingColumnAvailable", "fixLevelColumnsBtn", "!visible", new BindingConvertor[0]);
        this.bf.createBinding((Object)this, "columnName", (Object)this.sourceLabel, "value", new BindingConvertor[0]);
        this.bf.createBinding((Object)this, "ordinalColumnName", (Object)this.ordinalLabel, "value", new BindingConvertor[0]);
        this.bf.createBinding((Object)this, "ordinalColumnName", (Object)this.clearOrdinalColumnBtn, "image", new BindingConvertor[]{new BindingConvertor<String, String>(){

            public String sourceToTarget(String value) {
                return "images/" + (value == null ? "blank_button" : "remove") + ".png";
            }

            public String targetToSource(String value) {
                return null;
            }
        }});
        this.bf.createBinding((Object)this, "name", (Object)this.name, "value", new BindingConvertor[0]);
        this.bf.createBinding((Object)this, "uniqueMembers", (Object)this.hasUniqueMembers, "checked", new BindingConvertor[0]);
        this.bf.createBinding((Object)this, "validMessages", (Object)this.level_message_label, "value", new BindingConvertor[]{validMsgTruncatedBinding});
        this.messageBtn = (XulButton)this.document.getElementById("level_message_btn");
        this.bf.createBinding((Object)this, "validMessages", (Object)this.messageBtn, "visible", new BindingConvertor[]{showMsgBinding});
        this.geoList = (XulMenuList)this.document.getElementById("level_geo_role");
        this.geoRoles.clear();
        this.geoRoles.add(this.dummyGeoRole);
        this.geoRoles.addAll((Collection<GeoRole>)((Object)workspace.getGeoContext()));
        this.geoList.setElements(this.geoRoles);
        this.bf.createBinding((Object)this.geoList, "selectedItem", (Object)this, "selectedGeoRole", new BindingConvertor[0]);
        this.timeLevelTypeList = (XulMenuList)this.document.getElementById("time_level_type");
        this.timeRoles.clear();
        this.timeRoles.addAll(TimeRole.getAllRoles());
        this.timeLevelTypeList.setElements(this.timeRoles);
        this.bf.createBinding((Object)this.timeLevelTypeList, "selectedItem", (Object)this, "selectedTimeLevelType", new BindingConvertor[0]);
        this.timeLevelFormatList = (XulMenuList)this.document.getElementById("time_level_format");
        this.bf.createBinding((Object)this.timeLevelFormatList, "value", (Object)this, "timeLevelFormat", new BindingConvertor[0]);
    }

    protected String getColumnNameFromLogicalColumn(LogicalColumn col) {
        IPhysicalColumn physicalColumn;
        String columnName = "";
        if (col != null && (physicalColumn = col.getPhysicalColumn()) != null) {
            columnName = physicalColumn.getName(this.locale);
        }
        return columnName;
    }

    @Bindable
    public void setColumnName(String name) {
        String prevName = this.colName;
        if (prevName == null && "".equals(name)) {
            return;
        }
        if (prevName != null && name != null && prevName.equals(name)) {
            return;
        }
        this.colName = name;
        this.firePropertyChange("columnName", prevName, this.colName);
    }

    @Bindable
    public String getColumnName() {
        return this.colName;
    }

    @Bindable
    public void setOrdinalColumnName(String name) {
        String prevName = this.ordinalColName;
        if ("".equals(name)) {
            name = null;
        }
        if (prevName == null && name == null) {
            return;
        }
        if (prevName != null && name != null && prevName.equals(name)) {
            return;
        }
        this.ordinalColName = name;
        this.firePropertyChange("ordinalColumnName", prevName, this.ordinalColName);
    }

    @Bindable
    public String getOrdinalColumnName() {
        return this.ordinalColName;
    }

    @Bindable
    public void setCaptionColumnName(String name) {
        String prevName = this.captionColName;
        if (prevName == null && "".equals(name)) {
            return;
        }
        if (prevName != null && name != null && prevName.equals(name)) {
            return;
        }
        this.captionColName = name;
        this.firePropertyChange("captionColumnName", prevName, this.captionColName);
    }

    @Bindable
    public String geCaptionColumnName() {
        return this.captionColName;
    }

    @Bindable
    public void setName(String name) {
        if (this.getNode() != null) {
            ((BaseColumnBackedMetaData)this.getNode()).setName(name);
        }
        this.name.setValue(name);
    }

    @Bindable
    public String getName() {
        if (this.getNode() == null) {
            return null;
        }
        return ((BaseColumnBackedMetaData)this.getNode()).getName();
    }

    @Bindable
    public void setUniqueMembers(boolean uniqueMembers) {
        if (this.getNode() != null) {
            ((BaseColumnBackedMetaData)this.getNode()).setUniqueMembers(uniqueMembers);
        }
        if (uniqueMembers == this.hasUniqueMembers.isChecked()) {
            return;
        }
        this.hasUniqueMembers.setChecked(uniqueMembers);
    }

    @Bindable
    public boolean isUniqueMembers() {
        if (this.getNode() == null) {
            return false;
        }
        return ((BaseColumnBackedMetaData)this.getNode()).isUniqueMembers();
    }

    @Bindable
    public boolean isNotValid() {
        if (this.getNode() != null) {
            return !((BaseColumnBackedMetaData)this.getNode()).isValid();
        }
        return false;
    }

    @Bindable
    public void setNotValid(boolean notValid) {
        this.firePropertyChange("notValid", null, notValid);
    }

    @Bindable
    public boolean isBackingColumnAvailable() {
        if (this.getNode() != null) {
            return ((BaseColumnBackedMetaData)this.getNode()).getLogicalColumn() != null;
        }
        return false;
    }

    @Bindable
    public void setBackingColumnAvailable(boolean available) {
        this.firePropertyChange("backingColumnAvailable", null, available);
    }

    @Override
    public String getValidMessages() {
        if (this.getNode() != null) {
            return ((BaseColumnBackedMetaData)this.getNode()).getValidationMessagesString();
        }
        return null;
    }

    @Bindable
    public GeoRole getSelectedGeoRole() {
        return this.selectedGeoRole;
    }

    @Bindable
    public void setSelectedGeoRole(GeoRole selectedGeoRole) {
        GeoRole prevVal = this.selectedGeoRole;
        this.selectedGeoRole = selectedGeoRole;
        if (selectedGeoRole != null && selectedGeoRole != this.dummyGeoRole) {
            ((BaseColumnBackedMetaData)this.getNode()).getMemberAnnotations().put("Geo.Role", selectedGeoRole);
            ((BaseColumnBackedMetaData)this.getNode()).getMemberAnnotations().put("Data.Role", selectedGeoRole);
        } else {
            ((BaseColumnBackedMetaData)this.getNode()).getMemberAnnotations().remove("Data.Role");
            ((BaseColumnBackedMetaData)this.getNode()).getMemberAnnotations().remove("Geo.Role");
        }
        ((BaseColumnBackedMetaData)this.getNode()).validateNode();
        this.showValidations();
        this.firePropertyChange("selectedGeoRole", prevVal, selectedGeoRole);
    }

    @Bindable
    public TimeRole getSelectedTimeLevelType() {
        return this.selectedTimeLevelType;
    }

    @Bindable
    public void setSelectedTimeLevelType(TimeRole selectedTimeLevelType) {
        TimeRole oldTimeLevelType = this.getSelectedTimeLevelType();
        if (selectedTimeLevelType == null) {
            selectedTimeLevelType = TimeRole.DUMMY;
        }
        this.selectedTimeLevelType = selectedTimeLevelType;
        ((BaseColumnBackedMetaData)this.getNode()).setDataRole(selectedTimeLevelType);
        List<String> formatsList = selectedTimeLevelType.getFormatsList();
        String value = this.getTimeLevelFormat();
        int selectedIndex = formatsList.indexOf(value);
        this.timeLevelFormatList.setElements(formatsList);
        if (selectedIndex == -1) {
            if (value == null) {
                value = "";
            }
            this.timeLevelFormatList.setValue(value);
        } else {
            this.timeLevelFormatList.setSelectedIndex(selectedIndex);
        }
        this.firePropertyChange("selectedTimeLevelType", oldTimeLevelType, selectedTimeLevelType);
    }

    @Bindable
    public void setTimeLevelFormat(String format) {
        if ("".equals(format)) {
            format = null;
        }
        if (format == null && this.timeLevelFormat == null) {
            return;
        }
        if (format != null && this.timeLevelFormat != null && format.equals(this.timeLevelFormat)) {
            return;
        }
        if (this.getNode() != null) {
            ((BaseColumnBackedMetaData)this.getNode()).setTimeLevelFormat(format);
        }
        LevelMetaData levelMetaData = (LevelMetaData)this.getNode();
        HierarchyMetaData hierarchyMetaData = levelMetaData.getHierarchyMetaData();
        List<LevelMetaData> levels = hierarchyMetaData.getLevels();
        boolean isDescendant = false;
        for (LevelMetaData descendant : levels) {
            if (!isDescendant) {
                if (descendant != levelMetaData) continue;
                isDescendant = true;
                continue;
            }
            descendant.validateNode();
        }
        this.showValidations();
        this.timeLevelFormat = format;
    }

    @Bindable
    public String getTimeLevelFormat() {
        if (this.getNode() == null) {
            return null;
        }
        return ((BaseColumnBackedMetaData)this.getNode()).getTimeLevelFormat();
    }
}

