/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cassandra.cql;

import org.pentaho.cassandra.cql.CQLFunctions;

public class Selector {
    private static final String OPEN_BRACKET = "(";
    private String columnName;
    private String alias;
    private CQLFunctions function;
    private boolean isFunction;

    public Selector(String columnName) {
        this(columnName, null);
    }

    public Selector(String columnName, String alias) {
        this(columnName, alias, null);
    }

    public Selector(String columnName, String alias, String function) {
        this.columnName = columnName;
        this.alias = alias;
        this.function = CQLFunctions.getFromString(function);
        this.isFunction = this.function != null;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getColumnName() {
        return this.isFunction() ? this.getNomalizedFunctionName(this.columnName, this.getFunction().isCaseSensitive()) : this.columnName;
    }

    public CQLFunctions getFunction() {
        return this.function;
    }

    public boolean isFunction() {
        return this.isFunction;
    }

    public String toString() {
        return "Selector [columnName=" + this.columnName + ", alias=" + this.alias + ", function=" + (Object)((Object)this.function) + ", isFunction=" + this.isFunction + "]";
    }

    private String getNomalizedFunctionName(String function, boolean isCaseSensetive) {
        String nName = null;
        if (function != null) {
            nName = isCaseSensetive ? function : function.toLowerCase();
            StringBuffer newName = new StringBuffer(function.length());
            int ind = function.indexOf(OPEN_BRACKET);
            if (ind != -1) {
                nName = function.substring(0, ind).trim();
                nName = newName.append(isCaseSensetive ? nName : nName.toLowerCase()).append(function.substring(ind)).toString();
            }
        }
        return nName;
    }
}

